/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.StringVisitorModelInterpolator;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.model.root.DefaultRootLocator;
import org.apache.maven.model.root.RootLocator;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;

public final class Maven40ProfileUtil {
    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        Model nativeModel = Maven40ModelConverter.toNativeModel(model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
                    DefaultUrlNormalizer urlNormalizer = new DefaultUrlNormalizer();
                    DefaultRootLocator rootLocator = new DefaultRootLocator();
                    StringVisitorModelInterpolator interpolator = new StringVisitorModelInterpolator((PathTranslator)pathTranslator, (UrlNormalizer)urlNormalizer, (RootLocator)rootLocator);
                    expandedProfilesCache = Maven40ProfileUtil.doInterpolate(interpolator, nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                ModelProblemCollector collector = new ModelProblemCollector(){

                    public void add(ModelProblemCollectorRequest request) {
                    }
                };
                DefaultProfileActivationContext context = new DefaultProfileActivationContext();
                for (ProfileActivator eachActivator : Maven40ProfileUtil.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.isActive(eachExpandedProfile, (ProfileActivationContext)context, collector)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (Exception e) {
                        MavenServerGlobals.getLogger().warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(Maven40ModelConverter.convertModel(nativeModel), new MavenExplicitProfiles(Maven40ProfileUtil.collectProfilesIds(activatedProfiles), Maven40ProfileUtil.collectProfilesIds(deactivatedProfiles)));
    }

    private static ProfileActivator[] getProfileActivators(File basedir) {
        PropertyProfileActivator sysPropertyActivator = new PropertyProfileActivator();
        return new ProfileActivator[]{sysPropertyActivator, new JdkVersionProfileActivator(), new OperatingSystemProfileActivator()};
    }

    public static Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
        }
        return Maven40ProfileUtil.collectProfilesIds(profiles);
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        HashSet<String> result = new HashSet<String>();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) {
        Model nativeModel = Maven40ModelConverter.toNativeModel(model);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        DefaultUrlNormalizer urlNormalizer = new DefaultUrlNormalizer();
        DefaultRootLocator rootLocator = new DefaultRootLocator();
        StringVisitorModelInterpolator interpolator = new StringVisitorModelInterpolator((PathTranslator)pathTranslator, (UrlNormalizer)urlNormalizer, (RootLocator)rootLocator);
        Model result = Maven40ProfileUtil.doInterpolate(interpolator, nativeModel, basedir);
        MyDefaultPathTranslator myPathTranslator = new MyDefaultPathTranslator((PathTranslator)pathTranslator);
        myPathTranslator.alignToBaseDirectory(result, basedir);
        MavenModel mavenModel = Maven40ModelConverter.convertModel(result);
        if (mavenModel == null) {
            Maven40ProfileUtil.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    private static Model doInterpolate(StringVisitorModelInterpolator interpolator, @NotNull Model result, File basedir) {
        if (result == null) {
            Maven40ProfileUtil.$$$reportNull$$$0(1);
        }
        try {
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigProperties((File)basedir));
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setUserProperties(userProperties);
            request.setSystemProperties(MavenServerUtil.collectSystemProperties());
            request.setBuildStartTime(new Date());
            request.setFileModel(result);
            final ArrayList problems = new ArrayList();
            result = interpolator.interpolateModel(result, basedir, (ModelBuildingRequest)request, new ModelProblemCollector(){

                public void add(ModelProblemCollectorRequest request) {
                    problems.add(request);
                }
            });
            for (ModelProblemCollectorRequest problem : problems) {
                if (problem.getException() == null) continue;
                MavenServerGlobals.getLogger().warn((Throwable)problem.getException());
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/utils/Maven40ProfileUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/utils/Maven40ProfileUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDefaultPathTranslator {
        private final PathTranslator myPathTranslator;

        private MyDefaultPathTranslator(PathTranslator pathTranslator) {
            this.myPathTranslator = pathTranslator;
        }

        private String alignToBaseDirectory(String path, File basedir) {
            return this.myPathTranslator.alignToBaseDirectory(path, basedir);
        }

        private void alignToBaseDirectory(Model model, File basedir) {
            Reporting reporting;
            if (basedir == null) {
                return;
            }
            Build build = model.getBuild();
            if (build != null) {
                build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
                build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
                build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
                for (Resource resource : build.getResources()) {
                    resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
                }
                for (Resource resource : build.getTestResources()) {
                    resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
                }
                if (build.getFilters() != null) {
                    ArrayList<String> filters = new ArrayList<String>();
                    for (String filter : build.getFilters()) {
                        filters.add(this.alignToBaseDirectory(filter, basedir));
                    }
                    build.setFilters(filters);
                }
                build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
                build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
            }
            if ((reporting = model.getReporting()) != null) {
                reporting.setOutputDirectory(this.alignToBaseDirectory(reporting.getOutputDirectory(), basedir));
            }
        }
    }
}

