/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudUrls;
import org.jetbrains.qodana.cloud.api.QodanaCloudException;
import org.jetbrains.qodana.cloud.api.QodanaCloudOfflineException;
import org.jetbrains.qodana.cloud.api.QodanaCloudResponseException;
import org.jetbrains.qodana.cloud.api.RequestMethod;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0000\u001aS\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u000526\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\n\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0000\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"mapperNotFailingOnUnknown", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapperNotFailingOnUnknown", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "buildRequestToQodanaCloud", "Ljava/net/http/HttpRequest;", "path", "", "requestMethod", "Lorg/jetbrains/qodana/cloud/api/RequestMethod;", "headers", "", "authToken", "sendRequestToQodanaCloud", "T", "request", "responseProcessor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "body", "Ljava/net/http/HttpHeaders;", "(Ljava/net/http/HttpRequest;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toJson", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nrequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 request.kt\norg/jetbrains/qodana/cloud/api/RequestKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,75:1\n76#2:76\n96#2,5:77\n37#3,2:82\n*S KotlinDebug\n*F\n+ 1 request.kt\norg/jetbrains/qodana/cloud/api/RequestKt\n*L\n34#1:76\n34#1:77,5\n34#1:82,2\n*E\n"})
public final class RequestKt {
    @NotNull
    public static final ObjectMapper getMapperNotFailingOnUnknown() {
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().di\u2026IL_ON_UNKNOWN_PROPERTIES)");
        return objectMapper;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpRequest buildRequestToQodanaCloud(@NotNull String path, @NotNull RequestMethod requestMethod, @NotNull Map<String, String> headers, @Nullable String authToken) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestMethod, (String)"requestMethod");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Url url = Urls.newFromEncoded((String)(QodanaCloudUrls.INSTANCE.getCloudApi() + path));
        if (requestMethod instanceof RequestMethod.GET) {
            Url url2 = url.addParameters(((RequestMethod.GET)requestMethod).getParameters());
            Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url.addParameters(requestMethod.parameters)");
            url = url2;
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(url.toExternalForm())).header("Content-Type", "application/json");
        if (!headers.isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Collection $this$flatMap$iv;
            Map<String, String> map2 = headers;
            HttpRequest.Builder builder = requestBuilder;
            boolean $i$f$flatMap = false;
            void var9_9 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Object[] objectArray = new String[]{it.getKey(), it.getValue()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            builder.headers(Arrays.copyOf(stringArray, stringArray.length));
        }
        if (authToken != null) {
            requestBuilder.header("Authorization", "Bearer " + authToken);
        }
        if ((stringArray = requestMethod) instanceof RequestMethod.GET) {
            requestBuilder.GET();
        } else if (stringArray instanceof RequestMethod.POST) {
            requestBuilder.POST(HttpRequest.BodyPublishers.ofString(RequestKt.toJson(((RequestMethod.POST)requestMethod).getBody())));
        }
        HttpRequest httpRequest = requestBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"requestBuilder.build()");
        return httpRequest;
    }

    public static /* synthetic */ HttpRequest buildRequestToQodanaCloud$default(String string, RequestMethod requestMethod, Map map2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return RequestKt.buildRequestToQodanaCloud(string, requestMethod, map2, string2);
    }

    public static final <T> T sendRequestToQodanaCloud(@NotNull HttpRequest request, @NotNull Function2<? super String, ? super HttpHeaders, ? extends T> responseProcessor) throws QodanaCloudException {
        HttpResponse<String> httpResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseProcessor, (String)"responseProcessor");
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
        try {
            httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (ConnectException e) {
            throw new QodanaCloudOfflineException();
        }
        catch (IOException e) {
            throw new QodanaCloudResponseException(null, e.toString());
        }
        HttpResponse<String> response = httpResponse;
        int responseCode = response.statusCode();
        boolean bl = 200 <= responseCode ? responseCode < 300 : false;
        if (bl) {
            String string = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.body()");
            HttpHeaders httpHeaders = response.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"response.headers()");
            return (T)responseProcessor.invoke((Object)string, (Object)httpHeaders);
        }
        Integer n = responseCode;
        String string = response.body();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.body()");
        throw new QodanaCloudResponseException(n, string);
    }

    private static final String toJson(Map<String, ? extends Object> $this$toJson) {
        String string = ExtensionsKt.jacksonObjectMapper().writeValueAsString($this$toJson);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jacksonObjectMapper().writeValueAsString(this)");
        return string;
    }
}

