/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.yaml;

import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProjectInspectionProfileManager;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u0012\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a$\u0010\u0015\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0001H\u0000\u001a'\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\"\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010#\u001a\u0014\u0010$\u001a\u00020\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"QODANA_CONFIG_EXTENSION", "", "QODANA_CONFIG_NAME", "QODANA_INSPECTION_EXCLUDE_NAME", "QODANA_INSPECTION_EXCLUDE_PATHS", "QODANA_INSPECTION_INCLUDE_NAME", "QODANA_INSPECTION_INCLUDE_PATHS", "QODANA_PROFILE_NAME", "QODANA_YAML_PATTERN", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "getQODANA_YAML_PATTERN", "()Lcom/intellij/patterns/PatternCondition;", "fullYamlKey", "element", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getAllInspections", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "getInspectionFromElement", "fromParent", "", "isQodanaYaml", "originalFile", "Lcom/intellij/psi/PsiFile;", "retrieveYamlValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "showInspection", "", "inspectionName", "yamlKeysPattern", "keys", "", "([Ljava/lang/String;)Lcom/intellij/patterns/PatternCondition;", "groupDisplayPath", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaYamlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaYamlUtils.kt\norg/jetbrains/qodana/yaml/QodanaYamlUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1360#3:85\n1446#3,5:86\n1655#3,8:91\n1549#3:99\n1620#3,3:100\n*S KotlinDebug\n*F\n+ 1 QodanaYamlUtils.kt\norg/jetbrains/qodana/yaml/QodanaYamlUtilsKt\n*L\n55#1:85\n55#1:86,5\n58#1:91,8\n59#1:99\n59#1:100,3\n*E\n"})
public final class QodanaYamlUtilsKt {
    @NotNull
    public static final String QODANA_CONFIG_NAME = "qodana";
    @NotNull
    public static final String QODANA_CONFIG_EXTENSION = "yaml";
    @NotNull
    public static final String QODANA_INSPECTION_INCLUDE_NAME = "include.name";
    @NotNull
    public static final String QODANA_INSPECTION_EXCLUDE_NAME = "exclude.name";
    @NotNull
    public static final String QODANA_PROFILE_NAME = "profile.name";
    @NotNull
    public static final String QODANA_INSPECTION_INCLUDE_PATHS = "include.paths";
    @NotNull
    public static final String QODANA_INSPECTION_EXCLUDE_PATHS = "exclude.paths";
    @NotNull
    private static final PatternCondition<PsiElement> QODANA_YAML_PATTERN = (PatternCondition)new PatternCondition<PsiElement>(){

        public boolean accepts(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiFile psiFile2 = element2.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
            return QodanaYamlUtilsKt.isQodanaYaml(psiFile2);
        }
    };

    public static final boolean isQodanaYaml(@NotNull PsiFile originalFile) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        VirtualFile virtualFile2 = originalFile.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return originalFile instanceof YAMLFile && Intrinsics.areEqual((Object)virtualFile3.getNameWithoutExtension(), (Object)QODANA_CONFIG_NAME) && Intrinsics.areEqual((Object)virtualFile3.getExtension(), (Object)QODANA_CONFIG_EXTENSION);
    }

    @NotNull
    public static final PatternCondition<PsiElement> getQODANA_YAML_PATTERN() {
        return QODANA_YAML_PATTERN;
    }

    @NotNull
    public static final PatternCondition<PsiElement> yamlKeysPattern(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        return (PatternCondition)new PatternCondition<PsiElement>(keys){
            final /* synthetic */ String[] $keys;
            {
                this.$keys = $keys;
                super("yamlKeysPattern");
            }

            public boolean accepts(@NotNull PsiElement element2, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return element2 instanceof YAMLScalar && ArraysKt.contains((Object[])this.$keys, (Object)QodanaYamlUtilsKt.fullYamlKey((YAMLPsiElement)element2));
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String fullYamlKey(@Nullable YAMLPsiElement element2) {
        if (element2 == null) return "";
        YAMLPsiElement p0 = element2;
        boolean bl = false;
        String string = YAMLUtil.getConfigFullName((YAMLPsiElement)p0);
        if (string == null) return "";
        CharSequence charSequence = string;
        Regex regex = new Regex("\\[\\d+\\]");
        String string2 = "";
        String string3 = regex.replace(charSequence, string2);
        String string4 = string3;
        if (string3 != null) return string4;
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<InspectionToolWrapper<?, ?>> getAllInspections(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$flatMap$iv = QodanaProjectInspectionProfileManager.Companion.getInstance(project2).getAllProfiles();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            QodanaInspectionProfile it = (QodanaInspectionProfile)((Object)element$iv$iv);
            boolean bl = false;
            List list2 = it.getAllTools();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.allTools");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allTools = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allTools;
        boolean $i$f$distinctBy = false;
        Iterable<String> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ScopeToolState it = (ScopeToolState)e$iv;
            boolean bl = false;
            String key$iv = it.getTool().getShortName();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Iterable $this$map$iv = list$iv;
        boolean $i$f$map = false;
        set$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ScopeToolState bl = (ScopeToolState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(p0.getTool());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final InspectionToolWrapper<?, ?> getInspectionFromElement(@NotNull PsiElement element2, boolean fromParent) {
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Object object = element2.getParent();
            PsiElement it = object;
            boolean bl = false;
            Object object2 = fromParent ? object : null;
            if (object2 == null) {
                object2 = element2;
            }
            YAMLScalar yAMLScalar = QodanaYamlUtilsKt.retrieveYamlValue(object2);
            if (yAMLScalar == null) {
                return null;
            }
            YAMLScalar yamlValue = yAMLScalar;
            String key = QodanaYamlUtilsKt.fullYamlKey((YAMLPsiElement)yamlValue);
            if (!Intrinsics.areEqual((Object)key, (Object)QODANA_INSPECTION_INCLUDE_NAME) && !Intrinsics.areEqual((Object)key, (Object)QODANA_INSPECTION_EXCLUDE_NAME)) {
                return null;
            }
            Project project2 = yamlValue.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"yamlValue.project");
            object = QodanaYamlUtilsKt.getAllInspections(project2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                InspectionToolWrapper it2 = (InspectionToolWrapper)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getID(), (Object)yamlValue.getTextValue())) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    public static /* synthetic */ InspectionToolWrapper getInspectionFromElement$default(PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return QodanaYamlUtilsKt.getInspectionFromElement(psiElement, bl);
    }

    private static final YAMLScalar retrieveYamlValue(PsiElement element2) {
        if (!(element2 instanceof YAMLScalar) || !((YAMLScalar)element2).isValid()) {
            return null;
        }
        return (YAMLScalar)element2;
    }

    public static final void showInspection(@NotNull Project project2, @NotNull String inspectionName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)inspectionName, (String)"inspectionName");
        QodanaInspectionProfileManager projectProfileManager = QodanaInspectionProfileManager.Companion.getInstance(project2);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        EditInspectionToolsSettingsAction.editToolSettings((Project)project2, (InspectionProfileImpl)inspectionProfile, (String)inspectionName);
    }

    @NotNull
    public static final String groupDisplayPath(@NotNull InspectionToolWrapper<?, ?> $this$groupDisplayPath) {
        Intrinsics.checkNotNullParameter($this$groupDisplayPath, (String)"<this>");
        String[] stringArray = $this$groupDisplayPath.getGroupPath();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"groupPath");
        return ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }
}

