/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.ConstructorHeaderCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstructorHeaderCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructorHeaderCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,59:1\n1247#2,2:60\n*S KotlinDebug\n*F\n+ 1 ConstructorHeaderCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/ConstructorHeaderCallChecker\n*L\n48#1:60,2\n*E\n"})
public final class ConstructorHeaderCallChecker
implements CallChecker {
    @NotNull
    public static final ConstructorHeaderCallChecker INSTANCE = new ConstructorHeaderCallChecker();

    private ConstructorHeaderCallChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        ClassDescriptor labelReferenceClass;
        Object v;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClassDescriptor dispatchReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getDispatchReceiver());
        ClassDescriptor extensionReceiverClass = ConstructorHeaderCallCheckerKt.access$getClassDescriptorForImplicitReceiver(resolvedCall2.getExtensionReceiver());
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement callElement = ktElement;
        ClassDescriptor classDescriptor2 = callElement instanceof KtInstanceExpressionWithLabel ? ((v = context.getTrace().get(BindingContext.REFERENCE_TARGET, ((KtInstanceExpressionWithLabel)callElement).getInstanceReference())) instanceof ClassDescriptor ? (ClassDescriptor)v : null) : (labelReferenceClass = null);
        if (dispatchReceiverClass == null && extensionReceiverClass == null && labelReferenceClass == null) {
            return;
        }
        Object[] objectArray = new ClassDescriptor[]{dispatchReceiverClass, extensionReceiverClass, labelReferenceClass};
        Set classes2 = SetsKt.setOf((Object[])objectArray);
        Sequence<HierarchicalScope> $this$any$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return;
            Object element$iv = iterator2.next();
            HierarchicalScope scope = (HierarchicalScope)element$iv;
            boolean bl2 = false;
            if (scope instanceof LexicalScope && ((LexicalScope)scope).getKind() == LexicalScopeKind.CONSTRUCTOR_HEADER) {
                DeclarationDescriptor declarationDescriptor = ((LexicalScope)scope).getOwnerDescriptor();
                Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
                if (classes2.contains(((ClassConstructorDescriptor)declarationDescriptor).getContainingDeclaration())) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        boolean bl3 = true;
        if (!bl3) return;
        context.getTrace().report(Errors.INSTANCE_ACCESS_BEFORE_SUPER_CALL.on(reportOn, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
    }
}

