/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.codeInspection.i18n.folding.PropertyFoldingBuilder;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class I18nMessageGotoDeclarationHandler
extends GotoDeclarationHandlerBase {
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement element, Editor editor) {
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(element.getTextRange().getStartOffset());
        if (region == null) {
            return null;
        }
        PsiElement editableElement = EditPropertyValueAction.getEditableElement(region);
        UElement uElement = UastContextKt.toUElement((PsiElement)editableElement);
        if (uElement instanceof ULiteralExpression) {
            return JavaI18nUtil.resolveProperty((UExpression)((ULiteralExpression)uElement));
        }
        if (uElement instanceof UQualifiedReferenceExpression) {
            uElement = ((UQualifiedReferenceExpression)uElement).getSelector();
        }
        if (uElement instanceof UCallExpression) {
            UCallExpression call = (UCallExpression)uElement;
            for (UExpression expression : call.getValueArguments()) {
                Property property;
                if (!(expression instanceof ULiteralExpression) || !PropertyFoldingBuilder.isI18nProperty((ULiteralExpression)expression) || (property = JavaI18nUtil.resolveProperty(expression)) == null) continue;
                return property;
            }
        }
        return null;
    }
}

