/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.performance.performancePlugin.commands;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import com.jetbrains.performancePlugin.utils.VcsTestUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "kotlin.performanceExtendedPlugin"})
@SourceDebugExtension(value={"SMAP\nCreateKotlinFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateKotlinFileCommand.kt\ncom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,66:1\n21#2,3:67\n101#2,2:70\n116#2:72\n104#2,10:73\n*S KotlinDebug\n*F\n+ 1 CreateKotlinFileCommand.kt\ncom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand\n*L\n56#1:67,3\n56#1:70,2\n56#1:72\n56#1:73,10\n*E\n"})
public final class CreateKotlinFileCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "createKotlinFile";
    @NotNull
    public static final String PREFIX = "%createKotlinFile";
    @NotNull
    private static final Map<String, String> POSSIBLE_FILE_TYPES;

    public CreateKotlinFileCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context2, @NotNull Continuation<? super Unit> $completion) {
        String string2 = this.extractCommandArgument(PREFIX);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extractCommandArgument(PREFIX)");
        String[] stringArray = new String[]{","};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string2, (String)"\\s", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String fileName = (String)list2.get(0);
        String filePath = (String)list2.get(1);
        String fileType = (String)list2.get(2);
        PsiManagerImpl psiManagerImpl = new PsiManagerImpl(context2.getProject());
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
        if (virtualFile2 == null) {
            throw new RuntimeException("'guessProjectDir' dir returned 'null'");
        }
        VirtualFile virtualFile3 = VirtualFileUtil.findFileOrDirectory((VirtualFile)virtualFile2, (String)filePath);
        if (virtualFile3 == null) {
            throw new RuntimeException("Can't find file " + filePath);
        }
        PsiDirectoryImpl directory = new PsiDirectoryImpl(psiManagerImpl, virtualFile3);
        String string3 = fileType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String templateName = POSSIBLE_FILE_TYPES.get(string3);
        if (templateName == null) {
            throw new RuntimeException("File type must be one of '" + POSSIBLE_FILE_TYPES.keySet() + "'");
        }
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)directory.getProject()).getInternalTemplate(templateName);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInstance(directory.pr\u2026nalTemplate(templateName)");
        FileTemplate template2 = fileTemplate;
        Project project3 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"context.project");
        VcsTestUtil.provisionVcsAddFileConfirmation((Project)project3, (VcsTestUtil.VcsAddFileConfirmation)VcsTestUtil.VcsAddFileConfirmation.DO_NOTHING);
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> CreateKotlinFileCommand.doExecute$lambda$1(fileName, template2, directory)));
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doExecute$lambda$1(String $fileName, FileTemplate $template, PsiDirectoryImpl $directory) {
        Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
        Intrinsics.checkNotNullParameter((Object)$template, (String)"$template");
        Intrinsics.checkNotNullParameter((Object)$directory, (String)"$directory");
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder(NAME);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"TRACER.spanBuilder(NAME)");
        SpanBuilder $this$useWithScope$iv = spanBuilder;
        boolean $i$f$useWithScope = false;
        Span span$iv = $this$useWithScope$iv.startSpan();
        AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
        Throwable throwable = null;
        try {
            Unit unit2;
            Scope it$iv = (Scope)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)span$iv, (String)"span");
            Span $this$use$iv$iv = span$iv;
            boolean $i$f$use = false;
            try {
                Span it = $this$use$iv$iv;
                boolean bl2 = false;
                CreateFileFromTemplateAction.createFileFromTemplate((String)$fileName, (FileTemplate)$template, (PsiDirectory)((PsiDirectory)$directory), null, (boolean)true);
                unit2 = Unit.INSTANCE;
            }
            catch (CancellationException e$iv$iv) {
                throw e$iv$iv;
            }
            catch (ProcessCanceledException e$iv$iv) {
                throw e$iv$iv;
            }
            catch (Throwable e$iv$iv) {
                $this$use$iv$iv.recordException(e$iv$iv);
                $this$use$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv;
            }
            finally {
                $this$use$iv$iv.end();
            }
            Unit unit3 = unit2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"class", (Object)"Kotlin Class"), new Pair((Object)"script", (Object)"Kotlin script"), new Pair((Object)"worksheet", (Object)"Kotlin worksheet"), new Pair((Object)"data", (Object)"Kotlin Data Class"), new Pair((Object)"enum", (Object)"Kotlin Enum"), new Pair((Object)"annotation", (Object)"Kotlin Annotation"), new Pair((Object)"object", (Object)"Kotlin Object"), new Pair((Object)"file", (Object)"Kotlin File"), new Pair((Object)"interface", (Object)"Kotlin Interface")};
        POSSIBLE_FILE_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/performance/performancePlugin/commands/CreateKotlinFileCommand$Companion;", "", "()V", "NAME", "", "POSSIBLE_FILE_TYPES", "", "getPOSSIBLE_FILE_TYPES", "()Ljava/util/Map;", "PREFIX", "kotlin.performanceExtendedPlugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getPOSSIBLE_FILE_TYPES() {
            return POSSIBLE_FILE_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

