/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.LLFirModuleWithDependenciesSymbolProvider;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.resolve.providers.FirNullSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\r\u001a\u00020\u000e\"\f\b\u0000\u0010\u000f*\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J*\u0010\u001e\u001a\u00020\u000e2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0017J&\u0010\"\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020#0\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0017J&\u0010$\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020%0\u00122\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0017J\u0012\u0010&\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDependenciesSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "providers", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "getProviders", "()Ljava/util/List;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "addNewSymbolsConsideringJvmFacades", "", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "destination", "", "newSymbols", "facades", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassLikeSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbolsTo", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "jvmClassName", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirModuleWithDependenciesSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirModuleWithDependenciesSymbolProvider.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDependenciesSymbolProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 smartCollectionsBuilder.kt\norg/jetbrains/kotlin/analysis/utils/collections/SmartCollectionsBuilderKt\n*L\n1#1,182:1\n1726#2,3:183\n1#3:186\n11#4:187\n11#4:188\n11#4:189\n*S KotlinDebug\n*F\n+ 1 LLFirModuleWithDependenciesSymbolProvider.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirDependenciesSymbolProvider\n*L\n110#1:183,3\n125#1:187\n136#1:188\n147#1:189\n*E\n"})
public final class LLFirDependenciesSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> providers;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public LLFirDependenciesSymbolProvider(@NotNull FirSession session, @NotNull List<? extends FirSymbolProvider> providers) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            super(session);
            this.providers = providers;
            Iterable $this$all$iv = this.providers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirSymbolProvider it = (FirSymbolProvider)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof LLFirModuleWithDependenciesSymbolProvider)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string2 = Reflection.getOrCreateKotlinClass(LLFirDependenciesSymbolProvider.class).getSimpleName() + " may not contain " + Reflection.getOrCreateKotlinClass(LLFirModuleWithDependenciesSymbolProvider.class).getSimpleName() + ": dependency providers must be flattened during session creation.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.symbolNamesProvider = FirNullSymbolNamesProvider.INSTANCE;
    }

    @NotNull
    public final List<FirSymbolProvider> getProviders() {
        return this.providers;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = it.getClassLikeSymbolByClassId(classId);
                if (firClassLikeSymbol2 == null) continue;
                firClassLikeSymbol = firClassLikeSymbol2;
                break block1;
            }
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        SmartSet facades = SmartSet.Companion.create();
        for (FirSymbolProvider provider2 : this.providers) {
            boolean $i$f$buildSmartList = false;
            SmartList smartList = new SmartList();
            List $this$getTopLevelCallableSymbolsTo_u24lambda_u243 = (List)smartList;
            boolean bl = false;
            provider2.getTopLevelCallableSymbolsTo($this$getTopLevelCallableSymbolsTo_u24lambda_u243, packageFqName, name2);
            List newSymbols = (List)smartList;
            this.addNewSymbolsConsideringJvmFacades(destination, newSymbols, (Set)facades);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        SmartSet facades = SmartSet.Companion.create();
        for (FirSymbolProvider provider2 : this.providers) {
            boolean $i$f$buildSmartList = false;
            SmartList smartList = new SmartList();
            List $this$getTopLevelFunctionSymbolsTo_u24lambda_u244 = (List)smartList;
            boolean bl = false;
            provider2.getTopLevelFunctionSymbolsTo($this$getTopLevelFunctionSymbolsTo_u24lambda_u244, packageFqName, name2);
            List newSymbols = (List)smartList;
            this.addNewSymbolsConsideringJvmFacades(destination, newSymbols, (Set)facades);
        }
    }

    @Override
    @FirSymbolProviderInternals
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        SmartSet facades = SmartSet.Companion.create();
        for (FirSymbolProvider provider2 : this.providers) {
            boolean $i$f$buildSmartList = false;
            SmartList smartList = new SmartList();
            List $this$getTopLevelPropertySymbolsTo_u24lambda_u245 = (List)smartList;
            boolean bl = false;
            provider2.getTopLevelPropertySymbolsTo($this$getTopLevelPropertySymbolsTo_u24lambda_u245, packageFqName, name2);
            List newSymbols = (List)smartList;
            this.addNewSymbolsConsideringJvmFacades(destination, newSymbols, (Set)facades);
        }
    }

    @Override
    @Nullable
    public FqName getPackage(@NotNull FqName fqName2) {
        FqName fqName3;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FqName fqName4 = it.getPackage(fqName2);
                if (fqName4 == null) continue;
                fqName3 = fqName4;
                break block1;
            }
            fqName3 = null;
        }
        return fqName3;
    }

    private final <S extends FirCallableSymbol<?>> void addNewSymbolsConsideringJvmFacades(List<S> destination, List<? extends S> newSymbols, Set<JvmClassName> facades) {
        if (newSymbols.isEmpty()) {
            return;
        }
        SmartSet newFacades = SmartSet.Companion.create();
        for (FirCallableSymbol symbol2 : newSymbols) {
            JvmClassName facade = this.jvmClassName(symbol2);
            if (facade != null) {
                ((Collection)newFacades).add(facade);
                if (facades.contains(facade)) continue;
                ((Collection)destination).add(symbol2);
                continue;
            }
            ((Collection)destination).add(symbol2);
        }
        CollectionsKt.addAll((Collection)facades, (Iterable)((Iterable)newFacades));
    }

    private final JvmClassName jvmClassName(FirCallableSymbol<?> $this$jvmClassName) {
        DeserializedContainerSource deserializedContainerSource = ((FirCallableDeclaration)$this$jvmClassName.getFir()).getContainerSource();
        FacadeClassSource facadeClassSource = deserializedContainerSource instanceof FacadeClassSource ? (FacadeClassSource)deserializedContainerSource : null;
        if (facadeClassSource == null) {
            return null;
        }
        FacadeClassSource jvmPackagePartSource = facadeClassSource;
        JvmClassName jvmClassName = jvmPackagePartSource.getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = jvmPackagePartSource.getClassName();
        }
        return jvmClassName;
    }
}

