/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/JvmInlineVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$BasicInlineVisitor;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inalienableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitRegularClass", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers.jvm"})
public final class JvmInlineVisitor
extends FirInlineDeclarationChecker.BasicInlineVisitor {
    public JvmInlineVisitor(@NotNull FirFunction inlineFunction, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inalienableParameters, @NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)inlineFunction, (String)"inlineFunction");
        Intrinsics.checkNotNullParameter((Object)inlineFunEffectiveVisibility, (String)"inlineFunEffectiveVisibility");
        Intrinsics.checkNotNullParameter(inalienableParameters, (String)"inalienableParameters");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super(inlineFunction, inlineFunEffectiveVisibility, inalienableParameters, session, reporter);
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!regularClass.getClassKind().isSingleton() && CollectionsKt.lastOrNull(data2.getContainingDeclarations()) == this.getInlineFunction()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.getReporter(), (AbstractKtSourceElement)((AbstractKtSourceElement)regularClass.getSource()), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local classes", (DiagnosticContext)data2, null, (int)16, null);
        } else {
            super.visitRegularClass(regularClass, data2);
        }
    }

    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull CheckerContext data2) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (CollectionsKt.lastOrNull(data2.getContainingDeclarations()) == this.getInlineFunction()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.getReporter(), (AbstractKtSourceElement)((AbstractKtSourceElement)simpleFunction.getSource()), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Local functions", (DiagnosticContext)data2, null, (int)16, null);
        } else {
            super.visitSimpleFunction(simpleFunction, data2);
        }
    }
}

