/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinNameHighlightingStateUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/base/highlighting/HighlightingFactory;", "", "()V", "highlightName", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "message", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.base.highlighting"})
public final class HighlightingFactory {
    @NotNull
    public static final HighlightingFactory INSTANCE = new HighlightingFactory();

    private HighlightingFactory() {
    }

    @Nullable
    public final HighlightInfo.Builder highlightName(@NotNull PsiElement element3, @NotNull HighlightInfoType highlightInfoType, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)highlightInfoType, (String)"highlightInfoType");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        Project project3 = project2;
        if (!element3.getTextRange().isEmpty()) {
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            return this.highlightName(project3, textRange, highlightInfoType, message2);
        }
        return null;
    }

    public static /* synthetic */ HighlightInfo.Builder highlightName$default(HighlightingFactory highlightingFactory, PsiElement psiElement2, HighlightInfoType highlightInfoType, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return highlightingFactory.highlightName(psiElement2, highlightInfoType, string2);
    }

    @Nullable
    public final HighlightInfo.Builder highlightName(@NotNull Project project2, @NotNull TextRange textRange, @NotNull HighlightInfoType highlightInfoType, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightInfoType, (String)"highlightInfoType");
        if (KotlinNameHighlightingStateUtils.isNameHighlightingEnabled(project2)) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newHighlightInfo(highlightInfoType)");
            HighlightInfo.Builder builder3 = builder2;
            if (message2 != null) {
                builder3.descriptionAndTooltip(message2);
            }
            HighlightInfo.Builder builder4 = builder3.range(textRange);
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"builder\n              .range(textRange)");
            HighlightInfo.Builder annotation = builder4;
            return annotation;
        }
        return null;
    }

    public static /* synthetic */ HighlightInfo.Builder highlightName$default(HighlightingFactory highlightingFactory, Project project2, TextRange textRange, HighlightInfoType highlightInfoType, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        return highlightingFactory.highlightName(project2, textRange, highlightInfoType, string2);
    }
}

