/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinExactPackagesIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinPartialPackageNamesIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/KotlinPackageIndexUtils;", "", "()V", "findFilesWithExactPackage", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "getSubPackageFqNames", "scope", "nameFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "getSubpackages", "fqName", "packageExists", "kotlin.base.indices"})
public final class KotlinPackageIndexUtils {
    @NotNull
    public static final KotlinPackageIndexUtils INSTANCE = new KotlinPackageIndexUtils();

    private KotlinPackageIndexUtils() {
    }

    @NotNull
    public final Collection<FqName> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        return this.getSubpackages(packageFqName, scope2, nameFilter2);
    }

    @NotNull
    public final Collection<KtFile> findFilesWithExactPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string2 = packageFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqName.asString()");
        return KotlinExactPackagesIndex.Companion.getFiles(string2, project2, searchScope2);
    }

    public final boolean packageExists(@NotNull FqName fqName2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
        return this.packageExists(fqName2, globalSearchScope);
    }

    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        return !FileBasedIndex.getInstance().processValues(KotlinPartialPackageNamesIndex.Companion.getNAME(), (Object)packageFqName, null, KotlinPackageIndexUtils::packageExists$lambda$0, searchScope2);
    }

    @NotNull
    public final Collection<FqName> getSubpackages(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        HashSet result2 = new HashSet();
        FileBasedIndex.getInstance().processValues(KotlinPartialPackageNamesIndex.Companion.getNAME(), (Object)fqName2, null, (arg_0, arg_1) -> KotlinPackageIndexUtils.getSubpackages$lambda$1(nameFilter2, result2, fqName2, arg_0, arg_1), scope2);
        return result2;
    }

    private static final boolean packageExists$lambda$0(VirtualFile virtualFile2, Name name2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"<anonymous parameter 0>");
        return false;
    }

    private static final boolean getSubpackages$lambda$1(Function1 $nameFilter, HashSet $result, FqName $fqName, VirtualFile virtualFile2, Name subPackageName) {
        Intrinsics.checkNotNullParameter((Object)$nameFilter, (String)"$nameFilter");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$fqName, (String)"$fqName");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"<anonymous parameter 0>");
        if (subPackageName != null && ((Boolean)$nameFilter.invoke((Object)subPackageName)).booleanValue()) {
            $result.add($fqName.child(subPackageName));
        }
        return true;
    }
}

