/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.analysis.decompiled.light.classes.KtLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleInternalUtilsKt;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.UserDataModuleContainer;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoWithExpectedBy;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.util.MappingIterator;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.util.SeqKt;
import org.jetbrains.kotlin.idea.base.util.SeqScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 42\u00020\u0001:\u000245B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\u0002\b\u0016H\u0082\bJ'\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u00f8\u0001\u0000J'\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"\u00f8\u0001\u0000J:\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a0'j\b\u0012\u0004\u0012\u00020\u001a`(H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"H\u0002J+\u0010+\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00f8\u0001\u0000J+\u0010-\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00f8\u0001\u0000J3\u0010.\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190,2\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/2\u0006\u0010!\u001a\u00020\"H\u0002\u00f8\u0001\u0000J#\u00100\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190,2\u0006\u00101\u001a\u000202H\u0002\u00f8\u0001\u0000J#\u00103\u001a\u00020\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190,2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000R \u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "libraryInfoCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "getLibraryInfoCache", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "libraryInfoCache$delegate", "callExtensions", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProviderExtension;", "Lkotlin/ExtensionFunctionType;", "collect", "Lkotlin/sequences/Sequence;", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLibrarySource", "", "element", "Lcom/intellij/psi/PsiElement;", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "collectByOrderEntry", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectByElement", "Lorg/jetbrains/kotlin/idea/base/util/SeqScope;", "collectByFile", "collectByLightElement", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "collectByUserData", "container", "Lorg/jetbrains/kotlin/idea/base/projectStructure/UserDataModuleContainer;", "collectSourceRelatedByFile", "Companion", "Configuration", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,384:1\n170#1,6:385\n170#1,6:392\n146#2:391\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider\n*L\n162#1:385,6\n216#1:392,6\n183#1:391\n*E\n"})
public final class ModuleInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;
    @NotNull
    private final Lazy libraryInfoCache$delegate;
    @NotNull
    private static final Logger LOG;

    public ModuleInfoProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.fileIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectFileIndex>(this){
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectFileIndex invoke() {
                return ProjectFileIndex.getInstance((Project)ModuleInfoProvider.access$getProject$p(this.this$0));
            }
        }));
        this.libraryInfoCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibraryInfoCache>(this){
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LibraryInfoCache invoke() {
                return LibraryInfoCache.Companion.getInstance(ModuleInfoProvider.access$getProject$p(this.this$0));
            }
        }));
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    private final LibraryInfoCache getLibraryInfoCache() {
        Lazy lazy = this.libraryInfoCache$delegate;
        return (LibraryInfoCache)lazy.getValue();
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull PsiElement element3, @NotNull Configuration config2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        return SeqKt.seq((Function1)new Function1<SeqScope<? super Result<? extends IdeaModuleInfo>>, Unit>(this, element3, config2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ Configuration $config;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                this.$config = $config;
                super(1);
            }

            public final void invoke(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$seq) {
                Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                ModuleInfoProvider.access$collectByElement(this.this$0, $this$seq, this.$element, this.$config);
            }
        });
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, PsiElement psiElement2, Configuration configuration2, int n, Object object) {
        if ((n & 2) != 0) {
            configuration2 = Configuration.Companion.getDefault();
        }
        return moduleInfoProvider.collect(psiElement2, configuration2);
    }

    @NotNull
    public final Sequence<Result<IdeaModuleInfo>> collect(@NotNull VirtualFile virtualFile2, boolean isLibrarySource) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return SeqKt.seq((Function1)new Function1<SeqScope<? super Result<? extends IdeaModuleInfo>>, Unit>(this, virtualFile2, isLibrarySource){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $isLibrarySource;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$isLibrarySource = $isLibrarySource;
                super(1);
            }

            public final void invoke(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$seq) {
                Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                ModuleInfoProvider.access$collectByFile(this.this$0, $this$seq, this.$virtualFile, this.$isLibrarySource);
            }
        });
    }

    public static /* synthetic */ Sequence collect$default(ModuleInfoProvider moduleInfoProvider, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return moduleInfoProvider.collect(virtualFile2, bl);
    }

    private final void collectByElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByElement, PsiElement element3, Configuration config2) {
        VirtualFile virtualFile2;
        KtFile containingKtFile;
        ModuleInfo moduleInfo;
        PsiFile containingFile = element3.getContainingFile();
        if (containingFile != null && (moduleInfo = KotlinProjectStructureUtils.getForcedModuleInfo(containingFile)) instanceof IdeaModuleInfo) {
            ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)moduleInfo);
        }
        if (element3 instanceof KtLightElement) {
            this.collectByLightElement($this$collectByElement, (KtLightElement)element3, config2);
        }
        this.collectByUserData($this$collectByElement, new UserDataModuleContainer.ForElement(element3));
        if (containingFile == null) {
            String message2 = "Analyzing element of type " + element3.getClass() + " with no containing file";
            ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message2).withAttachment("element.kt", (Object)element3.getText()));
        }
        KtFile ktFile = containingKtFile = containingFile instanceof KtFile ? (KtFile)containingFile : null;
        if (containingKtFile != null) {
            ModuleInfo explicitModuleInfo;
            Object object = ((KtFile)containingFile).getVirtualFile();
            if (object != null && (object = KtModuleInternalUtilsKt.getAnalysisExtensionFileContextModule(object)) != null) {
                Object module2 = object;
                boolean bl = false;
                ModuleInfoProviderKt.register($this$collectByElement, KotlinProjectStructureUtils.getModuleInfo((KtModule)module2));
            }
            PsiElement analysisContext = KtPsiFactoryKt.getAnalysisContext((KtFile)containingKtFile);
            if (analysisContext != null) {
                this.collectByElement($this$collectByElement, analysisContext, config2);
            }
            if (KtPsiFactoryKt.getDoNotAnalyze((KtFile)containingKtFile) != null) {
                return;
            }
            Object object2 = KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)containingKtFile);
            if (object2 == null) {
                PsiFile bl = containingKtFile.getOriginalFile();
                KtFile ktFile2 = bl instanceof KtFile ? (KtFile)bl : null;
                object2 = ktFile2 != null ? KotlinProjectStructureUtils.getForcedModuleInfo((PsiFile)ktFile2) : null;
            }
            if ((explicitModuleInfo = object2) instanceof IdeaModuleInfo) {
                ModuleInfoProviderKt.register($this$collectByElement, (IdeaModuleInfo)explicitModuleInfo);
            }
            if (containingKtFile instanceof KtCodeFragment) {
                PsiElement context2 = ((KtCodeFragment)containingKtFile).getContext();
                if (context2 != null) {
                    this.collectByElement($this$collectByElement, context2, config2);
                } else {
                    String message3 = "Analyzing code fragment of type " + containingKtFile.getClass() + " with no context";
                    KotlinExceptionWithAttachments error2 = new KotlinExceptionWithAttachments(message3).withAttachment("file.kt", (Object)((KtCodeFragment)containingKtFile).getText());
                    ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)error2);
                }
            }
        }
        if ((virtualFile2 = containingFile.getOriginalFile().getVirtualFile()) != null) {
            KtFile ktFile3 = containingKtFile;
            boolean isLibrarySource = ktFile3 != null ? this.isLibrarySource(ktFile3, config2) : false;
            this.collectByFile($this$collectByElement, virtualFile2, isLibrarySource);
            ModuleInfoProvider this_$iv = this;
            boolean $i$f$callExtensions = false;
            Object[] objectArray = this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea.ge\u2026nsion.EP_NAME).extensions");
            ModuleInfoProviderExtension[] moduleInfoProviderExtensionArray = (ModuleInfoProviderExtension[])objectArray;
            int n = moduleInfoProviderExtensionArray.length;
            for (int j = 0; j < n; ++j) {
                ModuleInfoProviderExtension extension$iv;
                ModuleInfoProviderExtension $this$callExtensions_u24lambda_u242$iv = extension$iv = moduleInfoProviderExtensionArray[j];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$callExtensions_u24lambda_u242$iv, (String)"callExtensions$lambda$2");
                ModuleInfoProviderExtension $this$collectByElement_u24lambda_u241 = $this$callExtensions_u24lambda_u242$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)containingFile, (String)"containingFile");
                $this$collectByElement_u24lambda_u241.collectByElement($this$collectByElement, element3, containingFile, virtualFile2);
            }
        } else {
            String message4 = "Analyzing element of type " + element3.getClass() + " in non-physical file of type " + containingFile.getClass();
            ModuleInfoProviderKt.reportError($this$collectByElement, (Throwable)new KotlinExceptionWithAttachments(message4).withAttachment("file.kt", (Object)containingFile.getText()));
        }
    }

    private final void callExtensions(Function1<? super ModuleInfoProviderExtension, Unit> block2) {
        boolean $i$f$callExtensions = false;
        Object[] objectArray = this.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea.ge\u2026nsion.EP_NAME).extensions");
        ModuleInfoProviderExtension[] moduleInfoProviderExtensionArray = (ModuleInfoProviderExtension[])objectArray;
        int n = moduleInfoProviderExtensionArray.length;
        for (int j = 0; j < n; ++j) {
            ModuleInfoProviderExtension extension2;
            ModuleInfoProviderExtension $this$callExtensions_u24lambda_u242 = extension2 = moduleInfoProviderExtensionArray[j];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$callExtensions_u24lambda_u242, (String)"callExtensions$lambda$2");
            block2.invoke((Object)$this$callExtensions_u24lambda_u242);
        }
    }

    private final boolean isLibrarySource(KtFile containingKtFile, Configuration config2) {
        boolean isCompiled = containingKtFile.isCompiled();
        return config2.getCreateSourceLibraryInfoForLibraryBinaries() ? isCompiled : !isCompiled;
    }

    private final void collectByLightElement(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByLightElement, KtLightElement<?, ?> element3, Configuration config2) {
        KtElement originalElement;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
            VirtualFile virtualFile2 = element3.getContainingFile().getVirtualFile();
            if (virtualFile2 == null) {
                throw new IllegalStateException("Decompiled class should be build from physical file".toString());
            }
            VirtualFile virtualFile3 = virtualFile2;
            this.collectByFile($this$collectByLightElement, virtualFile3, false);
        }
        if ((originalElement = element3.getKotlinOrigin()) != null) {
            this.collectByElement($this$collectByLightElement, (PsiElement)originalElement, config2);
        } else if (element3 instanceof KtLightClassForFacade) {
            this.collectByElement($this$collectByLightElement, (PsiElement)CollectionsKt.first((Iterable)((KtLightClassForFacade)element3).getFiles()), config2);
        } else {
            KotlinExceptionWithAttachments error2 = new KotlinExceptionWithAttachments("Light element without origin is referenced by resolve").withAttachment("element.txt", element3);
            ModuleInfoProviderKt.reportError($this$collectByLightElement, (Throwable)error2);
        }
    }

    private final void collectByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByFile, VirtualFile virtualFile2, boolean isLibrarySource) {
        this.collectByUserData($this$collectByFile, new UserDataModuleContainer.ForVirtualFile(virtualFile2, this.project));
        this.collectSourceRelatedByFile($this$collectByFile, virtualFile2);
        $this$collectByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, virtualFile2, isLibrarySource){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ boolean $isLibrarySource;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$isLibrarySource = $isLibrarySource;
            }

            @NotNull
            public Iterator<Result<IdeaModuleInfo>> iterator() {
                ModuleInfoProvider moduleInfoProvider = this.this$0;
                VirtualFile virtualFile2 = this.$virtualFile;
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable(moduleInfoProvider, virtualFile2){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile$inlined;
                    {
                        this.this$0 = moduleInfoProvider;
                        this.$virtualFile$inlined = virtualFile2;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)ModuleInfoProvider.access$getFileIndex(this.this$0).getOrderEntriesForFile(this.$virtualFile$inlined);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { fileInde\u2026iesForFile(virtualFile) }");
                List orderEntries = (List)object;
                Iterator<E> iterator2 = orderEntries.iterator();
                HashSet<IdeaModuleInfo> visited = new HashSet<IdeaModuleInfo>();
                return new MappingIterator<E, T>(iterator2, (Function1)new Function1<OrderEntry, Result<? extends IdeaModuleInfo>>(this.this$0, this.$virtualFile, this.$isLibrarySource, visited){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ boolean $isLibrarySource;
                    final /* synthetic */ HashSet<IdeaModuleInfo> $visited;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        this.$isLibrarySource = $isLibrarySource;
                        this.$visited = $visited;
                        super(1);
                    }

                    @Nullable
                    public final Result<IdeaModuleInfo> invoke-CmtIpJM(OrderEntry orderEntry) {
                        Result result2;
                        Intrinsics.checkNotNullExpressionValue((Object)orderEntry, (String)"orderEntry");
                        IdeaModuleInfo ideaModuleInfo = ModuleInfoProvider.access$collectByOrderEntry(this.this$0, this.$virtualFile, orderEntry, this.$isLibrarySource, this.$visited);
                        if (ideaModuleInfo != null) {
                            IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
                            IdeaModuleInfo p0 = ideaModuleInfo2;
                            boolean bl = false;
                            result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                });
            }
        });
        ModuleInfoProvider this_$iv = this;
        boolean $i$f$callExtensions = false;
        Object[] objectArray = this_$iv.project.getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea.ge\u2026nsion.EP_NAME).extensions");
        ModuleInfoProviderExtension[] moduleInfoProviderExtensionArray = (ModuleInfoProviderExtension[])objectArray;
        int n = moduleInfoProviderExtensionArray.length;
        for (int j = 0; j < n; ++j) {
            ModuleInfoProviderExtension extension$iv;
            ModuleInfoProviderExtension $this$callExtensions_u24lambda_u242$iv = extension$iv = moduleInfoProviderExtensionArray[j];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$callExtensions_u24lambda_u242$iv, (String)"callExtensions$lambda$2");
            ModuleInfoProviderExtension $this$collectByFile_u24lambda_u243 = $this$callExtensions_u24lambda_u242$iv;
            boolean bl2 = false;
            $this$collectByFile_u24lambda_u243.collectByFile($this$collectByFile, this.project, virtualFile2, isLibrarySource);
        }
    }

    private final void collectSourceRelatedByFile(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectSourceRelatedByFile, VirtualFile virtualFile2) {
        $this$collectSourceRelatedByFile.yieldAll((Iterable<? super Result<? extends IdeaModuleInfo>>)new Iterable<Result<? extends IdeaModuleInfo>>(this, virtualFile2){
            final /* synthetic */ ModuleInfoProvider this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
            }

            @NotNull
            public Iterator<Result<IdeaModuleInfo>> iterator() {
                Sequence<T> modules2 = SeqKt.seq((Function1)new Function1<SeqScope<? super Module>, Unit>(this.this$0, this.$virtualFile){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull SeqScope<? super Module> $this$seq) {
                        void this_$iv;
                        Intrinsics.checkNotNullParameter($this$seq, (String)"$this$seq");
                        ModuleInfoProvider moduleInfoProvider = this.this$0;
                        VirtualFile virtualFile2 = this.$virtualFile;
                        boolean $i$f$runReadAction = false;
                        Module module2 = (Module)ApplicationManager.getApplication().runReadAction(new Computable(moduleInfoProvider, virtualFile2){
                            final /* synthetic */ ModuleInfoProvider this$0;
                            final /* synthetic */ VirtualFile $virtualFile$inlined;
                            {
                                this.this$0 = moduleInfoProvider;
                                this.$virtualFile$inlined = virtualFile2;
                            }

                            public final T compute() {
                                boolean bl = false;
                                return (T)ModuleInfoProvider.access$getFileIndex(this.this$0).getModuleForFile(this.$virtualFile$inlined);
                            }
                        });
                        if (module2 != null) {
                            Module module3 = module2;
                            boolean bl = false;
                            $this$seq.yield((Function0<? super Module>)((Function0)new Function0<Module>(module3){
                                final /* synthetic */ Module $module;
                                {
                                    this.$module = $module;
                                    super(0);
                                }

                                @Nullable
                                public final Module invoke() {
                                    return this.$module;
                                }
                            }));
                        }
                        ModuleInfoProvider moduleInfoProvider2 = this.this$0;
                        moduleInfoProvider = this.this$0;
                        virtualFile2 = this.$virtualFile;
                        boolean $i$f$callExtensions = false;
                        Object[] objectArray = ModuleInfoProvider.access$getProject$p((ModuleInfoProvider)this_$iv).getExtensionArea().getExtensionPoint(ModuleInfoProviderExtension.Companion.getEP_NAME()).getExtensions();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea.ge\u2026nsion.EP_NAME).extensions");
                        ModuleInfoProviderExtension[] moduleInfoProviderExtensionArray = (ModuleInfoProviderExtension[])objectArray;
                        int n = moduleInfoProviderExtensionArray.length;
                        for (int j = 0; j < n; ++j) {
                            ModuleInfoProviderExtension extension$iv;
                            ModuleInfoProviderExtension $this$callExtensions_u24lambda_u242$iv = extension$iv = moduleInfoProviderExtensionArray[j];
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$callExtensions_u24lambda_u242$iv, (String)"callExtensions$lambda$2");
                            ModuleInfoProviderExtension $this$invoke_u24lambda_u242 = $this$callExtensions_u24lambda_u242$iv;
                            boolean bl2 = false;
                            $this$invoke_u24lambda_u242.findContainingModules($this$seq, ModuleInfoProvider.access$getProject$p(moduleInfoProvider), virtualFile2);
                        }
                    }
                });
                Iterator iterator2 = modules2.iterator();
                return new MappingIterator<K, T>(iterator2, (Function1)new Function1<Module, Result<? extends ModuleSourceInfoWithExpectedBy>>(this.this$0, this.$virtualFile){
                    final /* synthetic */ ModuleInfoProvider this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        super(1);
                    }

                    @Nullable
                    public final Result<ModuleSourceInfoWithExpectedBy> invoke-CmtIpJM(@NotNull Module module2) {
                        Result result2;
                        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                        if (module2.isDisposed()) {
                            return null;
                        }
                        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)ModuleInfoProvider.access$getProject$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project)");
                        ProjectFileIndex projectFileIndex2 = projectFileIndex;
                        KotlinSourceRootType sourceRootType = KotlinProjectStructureUtils.getKotlinSourceRootType(projectFileIndex2, this.$virtualFile);
                        ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy = KotlinProjectStructureUtils.asSourceInfo(module2, sourceRootType);
                        if (moduleSourceInfoWithExpectedBy != null) {
                            ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy2 = moduleSourceInfoWithExpectedBy;
                            ModuleSourceInfoWithExpectedBy p0 = moduleSourceInfoWithExpectedBy2;
                            boolean bl = false;
                            result2 = Result.box-impl((Object)Result.constructor-impl((Object)p0));
                        } else {
                            result2 = null;
                        }
                        return result2;
                    }
                });
            }
        });
        VirtualFile fileOrigin = ProjectStructureUtils.getOutsiderFileOrigin(this.project, virtualFile2);
        if (fileOrigin != null) {
            this.collectSourceRelatedByFile($this$collectSourceRelatedByFile, fileOrigin);
        }
    }

    private final IdeaModuleInfo collectByOrderEntry(VirtualFile virtualFile2, OrderEntry orderEntry, boolean isLibrarySource, HashSet<IdeaModuleInfo> visited) {
        SdkInfo moduleInfo;
        Sdk sdk2;
        Library library2;
        if (orderEntry instanceof ModuleOrderEntry) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (!orderEntry.isValid()) {
            return null;
        }
        if (orderEntry instanceof LibraryOrderEntry && (library2 = ((LibraryOrderEntry)orderEntry).getLibrary()) != null) {
            if (!isLibrarySource && SourceKindFilterUtils.matches(RootKindFilter.libraryClasses, this.project, virtualFile2)) {
                for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library2)) {
                    if (!visited.add(libraryInfo)) continue;
                    return libraryInfo;
                }
            } else if (isLibrarySource || SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, this.project, virtualFile2)) {
                for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library2)) {
                    SourceForBinaryModuleInfo moduleInfo2 = libraryInfo.getSourcesModuleInfo();
                    if (!visited.add(moduleInfo2)) continue;
                    return moduleInfo2;
                }
            }
            return null;
        }
        if (orderEntry instanceof JdkOrderEntry && (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) != null && visited.add(moduleInfo = new SdkInfo(this.project, sdk2))) {
            return moduleInfo;
        }
        return null;
    }

    private final void collectByUserData(SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByUserData, UserDataModuleContainer container2) {
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(container2){
            final /* synthetic */ UserDataModuleContainer $container;
            {
                this.$container = $container;
                super(0);
            }

            @Nullable
            public final IdeaModuleInfo invoke() {
                Module module2 = this.$container.getModule();
                JpsModuleSourceRootType<?> sourceRootType = this.$container.getCustomSourceRootType();
                if (module2 != null && sourceRootType != null) {
                    ModuleSourceInfoWithExpectedBy moduleSourceInfoWithExpectedBy = KotlinProjectStructureUtils.asSourceInfo(module2, KotlinProjectStructureUtils.getSourceRootType(sourceRootType));
                    if (moduleSourceInfoWithExpectedBy != null) {
                        ModuleSourceInfoWithExpectedBy moduleInfo = moduleSourceInfoWithExpectedBy;
                        boolean bl = false;
                        return moduleInfo;
                    }
                }
                return null;
            }
        }));
        Library library2 = container2.getCustomLibrary();
        if (library2 != null) {
            Library library3 = library2;
            boolean bl = false;
            for (LibraryInfo libraryInfo : this.getLibraryInfoCache().get(library3)) {
                ModuleInfoProviderKt.register($this$collectByUserData, libraryInfo);
            }
        }
        ModuleInfoProviderKt.register($this$collectByUserData, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(container2, this){
            final /* synthetic */ UserDataModuleContainer $container;
            final /* synthetic */ ModuleInfoProvider this$0;
            {
                this.$container = $container;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final IdeaModuleInfo invoke() {
                SdkInfo sdkInfo;
                Sdk sdk2 = this.$container.getCustomSdk();
                if (sdk2 != null) {
                    Sdk sdk3 = sdk2;
                    ModuleInfoProvider moduleInfoProvider = this.this$0;
                    Sdk it = sdk3;
                    boolean bl = false;
                    sdkInfo = new SdkInfo(ModuleInfoProvider.access$getProject$p(moduleInfoProvider), it);
                } else {
                    sdkInfo = null;
                }
                return sdkInfo;
            }
        }));
    }

    public static final /* synthetic */ void access$collectByElement(ModuleInfoProvider $this, SeqScope $receiver, PsiElement element3, Configuration config2) {
        $this.collectByElement($receiver, element3, config2);
    }

    public static final /* synthetic */ void access$collectByFile(ModuleInfoProvider $this, SeqScope $receiver, VirtualFile virtualFile2, boolean isLibrarySource) {
        $this.collectByFile($receiver, virtualFile2, isLibrarySource);
    }

    public static final /* synthetic */ IdeaModuleInfo access$collectByOrderEntry(ModuleInfoProvider $this, VirtualFile virtualFile2, OrderEntry orderEntry, boolean isLibrarySource, HashSet visited) {
        return $this.collectByOrderEntry(virtualFile2, orderEntry, isLibrarySource, visited);
    }

    public static final /* synthetic */ ProjectFileIndex access$getFileIndex(ModuleInfoProvider $this) {
        return $this.getFileIndex();
    }

    static {
        Logger logger = Logger.getInstance(ModuleInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(ModuleInfoProvider::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$kotlin_base_project_structure", "()Lcom/intellij/openapi/diagnostic/Logger;", "findAnchorFile", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n29#2,3:385\n146#3:388\n1#4:389\n*S KotlinDebug\n*F\n+ 1 ModuleInfoProvider.kt\norg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Companion\n*L\n69#1:385,3\n77#1:388\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$kotlin_base_project_structure() {
            return LOG;
        }

        @NotNull
        public final ModuleInfoProvider getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ModuleInfoProvider> serviceClass$iv = ModuleInfoProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ModuleInfoProvider)object;
        }

        @Nullable
        public final PsiFile findAnchorFile(@NotNull PsiElement element3) {
            PsiFile psiFile2;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            if (!(element3 instanceof KtLightElement)) {
                psiFile2 = element3.getContainingFile();
            } else {
                PsiElement $this$getNonStrictParentOfType$iv = element3;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtLightClassForDecompiledDeclaration.class, (boolean)false) != null) {
                    psiFile2 = null;
                } else if (element3 instanceof KtLightClassForFacade) {
                    psiFile2 = (PsiFile)CollectionsKt.first((Iterable)((KtLightClassForFacade)element3).getFiles());
                } else {
                    KtElement ktElement = ((KtLightElement)element3).getKotlinOrigin();
                    if (ktElement != null) {
                        PsiElement p0 = (PsiElement)ktElement;
                        boolean bl = false;
                        psiFile2 = this.findAnchorFile(p0);
                    } else {
                        psiFile2 = null;
                    }
                }
            }
            return psiFile2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "", "createSourceLibraryInfoForLibraryBinaries", "", "(Z)V", "getCreateSourceLibraryInfoForLibraryBinaries", "()Z", "Companion", "kotlin.base.project-structure"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean createSourceLibraryInfoForLibraryBinaries;
        @NotNull
        private static final Configuration Default = new Configuration(false, 1, null);

        public Configuration(boolean createSourceLibraryInfoForLibraryBinaries) {
            this.createSourceLibraryInfoForLibraryBinaries = createSourceLibraryInfoForLibraryBinaries;
        }

        public /* synthetic */ Configuration(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getCreateSourceLibraryInfoForLibraryBinaries() {
            return this.createSourceLibraryInfoForLibraryBinaries;
        }

        public Configuration() {
            this(false, 1, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration$Companion;", "", "()V", "Default", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "getDefault", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "kotlin.base.project-structure"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Configuration getDefault() {
                return Default;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

