/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleSourceInfoBase;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinModificationTrackerProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoKt;
import org.jetbrains.kotlin.platform.compat.CompatConversionsKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.TargetPlatform;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010\u001d\u001a\u00020'H\u0017R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006(\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/TrackableModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/ModuleSourceInfoBase;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "displayedName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayedName", "()Ljava/lang/String;", "expectedBy", "", "getExpectedBy", "()Ljava/util/List;", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkValidity", "", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "kotlin.base.project-structure"})
public interface ModuleSourceInfo
extends org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo,
IdeaModuleInfo,
TrackableModuleInfo,
ModuleSourceInfoBase {
    @Override
    @NotNull
    public Module getModule();

    @NotNull
    public List<ModuleSourceInfo> getExpectedBy();

    @NotNull
    default public String getDisplayedName() {
        String string2 = this.getModule().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
        return string2;
    }

    @Override
    @NotNull
    default public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.MODULE;
    }

    @Override
    @NotNull
    default public Project getProject() {
        Project project2 = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return project2;
    }

    @NotNull
    default public org.jetbrains.kotlin.platform.TargetPlatform getPlatform() {
        return TargetPlatformDetectorUtils.getPlatform(this.getModule());
    }

    @Deprecated(message="This accessor is deprecated and will be removed soon, use API from 'org.jetbrains.kotlin.platform.*' packages instead", replaceWith=@ReplaceWith(expression="platform", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    default public TargetPlatform getPlatform() {
        return CompatConversionsKt.toOldPlatform((org.jetbrains.kotlin.platform.TargetPlatform)this.getPlatform());
    }

    @NotNull
    default public PlatformDependentAnalyzerServices getAnalyzerServices() {
        org.jetbrains.kotlin.platform.TargetPlatform targetPlatform = this.getPlatform();
        Project project2 = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return PlatformAnalyzerServicesUtils.findAnalyzerServices(targetPlatform, project2);
    }

    @NotNull
    default public ModificationTracker createModificationTracker() {
        Project project2 = this.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return KotlinModificationTrackerProvider.Companion.getInstance(project2).createModuleModificationTracker(this.getModule());
    }

    @Override
    default public void checkValidity() {
        ModuleSourceInfoKt.checkValidity(this.getModule());
    }
}

