/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoUtilsKt;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.KotlinLibraryToSourceAnalysisStateComponentUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.ResolutionAnchorCacheService;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.resolve.ResolutionAnchorProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinIdeResolutionAnchorService;", "Lorg/jetbrains/kotlin/resolve/ResolutionAnchorProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolutionAnchor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "kotlin.base.fe10.analysis"})
public final class KotlinIdeResolutionAnchorService
implements ResolutionAnchorProvider {
    @NotNull
    private final Project project;

    public KotlinIdeResolutionAnchorService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public ModuleDescriptor getResolutionAnchor(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (!KotlinLibraryToSourceAnalysisStateComponentUtils.getUseLibraryToSourceAnalysis(this.project)) {
            return null;
        }
        Map<LibraryInfo, ModuleSourceInfo> moduleToAnchor = ResolutionAnchorCacheService.Companion.getInstance(this.project).getResolutionAnchorsForLibraries();
        ModuleInfo moduleInfo = ModuleInfoUtilsKt.getModuleInfo((ModuleDescriptor)moduleDescriptor);
        if (moduleInfo == null) {
            return null;
        }
        ModuleInfo moduleInfo2 = moduleInfo;
        ModuleInfo keyModuleInfo = moduleInfo2 instanceof SourceForBinaryModuleInfo ? (ModuleInfo)((SourceForBinaryModuleInfo)moduleInfo2).getBinariesModuleInfo() : moduleInfo2;
        ModuleSourceInfo moduleSourceInfo = moduleToAnchor.get(keyModuleInfo);
        if (moduleSourceInfo == null) {
            return null;
        }
        ModuleSourceInfo mapped = moduleSourceInfo;
        ResolutionFacade resolutionFacade2 = KotlinCacheService.Companion.getInstance(this.project).getResolutionFacadeByModuleInfo((ModuleInfo)mapped, mapped.getPlatform());
        return resolutionFacade2 != null ? resolutionFacade2.getModuleDescriptor() : null;
    }
}

