/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.UntraceableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilationStatusListener;", "Lcom/intellij/openapi/compiler/CompilationStatusListener;", "()V", "compilationFinished", "", "aborted", "", "errors", "", "warnings", "compileContext", "Lcom/intellij/openapi/compiler/CompileContext;", "fileGenerated", "outputRoot", "", "relativePath", "Companion", "KotlinCompilerException", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilationStatusListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilationStatusListener.kt\norg/jetbrains/kotlin/idea/compiler/KotlinCompilationStatusListener\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,81:1\n76#2:82\n*S KotlinDebug\n*F\n+ 1 KotlinCompilationStatusListener.kt\norg/jetbrains/kotlin/idea/compiler/KotlinCompilationStatusListener\n*L\n60#1:82\n*E\n"})
public final class KotlinCompilationStatusListener
implements CompilationStatusListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String PREFIX_WITH_COMPILER_NAME = "Kotlin: [Internal Error] ";
    @NotNull
    private static final Set<String> FILE_EXTS_WHICH_NEEDS_REFRESH;

    public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
        Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
        CompilerMessage[] compilerMessageArray = compileContext.getMessages(CompilerMessageCategory.ERROR);
        Intrinsics.checkNotNullExpressionValue((Object)compilerMessageArray, (String)"compileContext.getMessag\u2026lerMessageCategory.ERROR)");
        for (CompilerMessage error2 : compilerMessageArray) {
            String message2 = error2.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
            if (!StringsKt.startsWith$default((String)message2, (String)"[Internal Error] ", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)message2, (String)PREFIX_WITH_COMPILER_NAME, (boolean)false, (int)2, null)) continue;
            LOG.error((Throwable)((Object)new KotlinCompilerException(message2)));
        }
    }

    public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)outputRoot, (String)"outputRoot");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String string2 = FileUtilRt.getExtension((String)relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(relativePath)");
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String ext = string3;
        if (FILE_EXTS_WHICH_NEEDS_REFRESH.contains(ext)) {
            String outFile = outputRoot + "/" + relativePath;
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(outFile);
            if (virtualFile2 == null) {
                throw new IllegalStateException(("Virtual file not found for generated file path: " + outFile).toString());
            }
            VirtualFile virtualFile3 = virtualFile2;
            virtualFile3.refresh(false, false);
        }
    }

    static {
        Logger logger = Logger.getInstance(KotlinCompilationStatusListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(KotlinCompil\u2026atusListener::class.java)");
        LOG = logger;
        Object[] objectArray = new String[]{".js", ".map"};
        FILE_EXTS_WHICH_NEEDS_REFRESH = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilationStatusListener$Companion;", "", "()V", "FILE_EXTS_WHICH_NEEDS_REFRESH", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX_WITH_COMPILER_NAME", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilationStatusListener$KotlinCompilerException;", "Lcom/intellij/diagnostic/PluginException;", "Lcom/intellij/openapi/diagnostic/UntraceableException;", "text", "", "(Ljava/lang/String;)V", "message", "getMessage", "()Ljava/lang/String;", "fillInStackTrace", "", "getStackTrace", "", "Ljava/lang/StackTraceElement;", "()[Ljava/lang/StackTraceElement;", "printStackTrace", "", "s", "Ljava/io/PrintStream;", "Ljava/io/PrintWriter;", "kotlin.jvm"})
    private static final class KotlinCompilerException
    extends PluginException
    implements UntraceableException {
        @NotNull
        private final String text;

        public KotlinCompilerException(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            PluginDescriptor pluginDescriptor = PluginManager.getPluginByClass(KotlinCompilationStatusListener.class);
            super("", (PluginId)(pluginDescriptor != null ? pluginDescriptor.getPluginId() : null));
            this.text = text2;
        }

        public void printStackTrace(@NotNull PrintWriter s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            s.print(this.text);
        }

        public void printStackTrace(@NotNull PrintStream s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            s.print(this.text);
        }

        @NotNull
        public synchronized Throwable fillInStackTrace() {
            return (Throwable)((Object)this);
        }

        @NotNull
        public StackTraceElement[] getStackTrace() {
            LOG.error("Somebody called getStackTrace() on KotlinCompilerException");
            StackTraceElement[] stackTraceElementArray = new UnsupportedOperationException().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"UnsupportedOperationException().stackTrace");
            return stackTraceElementArray;
        }

        @NotNull
        public String getMessage() {
            return "<Exception from standalone Kotlin compiler>";
        }
    }
}

