/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.KeywordCompletion;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 Q2\u00020\u0001:\u0007PQRSTUVB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J.\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J&\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\tH\u0002J2\u0010%\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020 0\u0019J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0013H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\tH\u0002JZ\u00100\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u00101\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00192\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020 0\u0019H\u0002J,\u00104\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00152\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020 0\u0019H\u0002J\u0018\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0013H\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\tH\u0002J \u00109\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;H\u0002J \u0010<\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0002J \u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010C\u001a\u00020 *\u00060\"j\u0002`#2\u0006\u0010D\u001a\u00020\tH\u0002J\u0014\u0010E\u001a\u00020\b*\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0002J\u001c\u0010F\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010G*\u00020\u00132\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0014\u0010H\u001a\u00020I*\u00020\t2\u0006\u0010J\u001a\u00020\tH\u0002J\u0012\u0010K\u001a\b\u0012\u0004\u0012\u00020\t0\u0010*\u00020\tH\u0002J\f\u0010L\u001a\u00020\b*\u00020\tH\u0002J\u0014\u0010M\u001a\u00020\b*\u00020N2\u0006\u0010O\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0018\u0010\u000b\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0018\u0010\u000e\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\r\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion;", "", "languageVersionSettingProvider", "Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;", "(Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;)V", "GENERAL_FILTER", "Lcom/intellij/psi/filters/NotFilter;", "isExplicitBackingFieldDeclaration", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "isExtensionReceiverInCallableDeclaration", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isTypeArgumentOfOuterKtTypeReference", "buildFilesWithKeywordApplication", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "keywordTokenType", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "prefixText", "", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "buildFilter", "Lkotlin/Function1;", "position", "buildFilterByText", "buildFilterWithContext", "contextElement", "buildFilterWithReducedContext", "buildReducedContextBefore", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scope", "complete", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "isJvmModule", "consumer", "Lcom/intellij/codeInsight/lookup/LookupElement;", "computeKeywordApplications", "keyword", "createLookupElementBuilder", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "getTopLevelClassName", "handleCompoundKeyword", "keywordToken", "nextKeyword", "parserFilter", "handleTopLevelClassName", "ignorePrefixForKeyword", "completionPosition", "isErrorElementBefore", "token", "isModifierSupportedAtLanguageLevel", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isModifierTargetSupportedAtLanguageLevel", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "isPossibleParentTarget", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "parentTarget", "appendReducedText", "element", "avoidSuggestingWith", "getNextPossibleKeywords", "", "getStartOffsetInAncestor", "", "ancestor", "goUpWhileIsLastChild", "isSemicolon", "matchesKeyword", "Lcom/intellij/psi/tree/IElementType;", "keywordType", "CommentFilter", "Companion", "FileFilter", "LanguageVersionSettingProvider", "ParentFilter", "SpaceAfterInsertHandler", "UseSiteAnnotationTargetInsertHandler", "kotlin.completion.impl-shared"})
@SourceDebugExtension(value={"SMAP\nKeywordCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,765:1\n1855#2,2:766\n2624#2,3:768\n1747#2,3:771\n1747#2,3:776\n2624#2,3:795\n1620#2,3:807\n1549#2:810\n1620#2,3:811\n1247#3,2:774\n1247#3,2:783\n1247#3,2:787\n179#3,2:789\n179#3,2:799\n2159#3,2:801\n15#4,2:779\n15#4,2:781\n15#4,2:785\n57#5,2:791\n1#6:793\n146#7:794\n125#7:798\n11065#8:803\n11400#8,3:804\n*S KotlinDebug\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion\n*L\n127#1:766,2\n190#1:768,3\n221#1:771,3\n259#1:776,3\n577#1:795,3\n69#1:807,3\n117#1:810\n117#1:811,3\n253#1:774,2\n337#1:783,2\n633#1:787,2\n702#1:789,2\n608#1:799,2\n609#1:801,2\n324#1:779,2\n325#1:781,2\n369#1:785,2\n508#1:791,2\n521#1:794\n582#1:798\n59#1:803\n59#1:804,3\n*E\n"})
public final class KeywordCompletion {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LanguageVersionSettingProvider languageVersionSettingProvider;
    @NotNull
    private final NotFilter GENERAL_FILTER;
    @NotNull
    private static final List<KtKeywordToken> ALL_KEYWORDS;
    @NotNull
    private static final HashSet<String> INCOMPATIBLE_KEYWORDS_AROUND_SEALED;
    @NotNull
    private static final Map<KtKeywordToken, Set<KtKeywordToken>> COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER;
    @NotNull
    private static final Map<KtKeywordToken, String> KEYWORD_CONSTRUCTS;
    @NotNull
    private static final List<String> NO_SPACE_AFTER;

    public KeywordCompletion(@NotNull LanguageVersionSettingProvider languageVersionSettingProvider) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettingProvider, (String)"languageVersionSettingProvider");
        this.languageVersionSettingProvider = languageVersionSettingProvider;
        ElementFilter[] elementFilterArray = new ElementFilter[]{new CommentFilter(), new ParentFilter((ElementFilter)new ClassFilter(KtLiteralStringTemplateEntry.class)), new ParentFilter((ElementFilter)new ClassFilter(KtConstantExpression.class)), new FileFilter((ElementFilter)new ClassFilter(KtTypeCodeFragment.class)), new LeftNeighbour((ElementFilter)new TextFilter(".")), new LeftNeighbour((ElementFilter)new TextFilter("?."))};
        this.GENERAL_FILTER = new NotFilter((ElementFilter)new OrFilter(elementFilterArray));
    }

    public final void complete(@NotNull PsiElement position, @NotNull PrefixMatcher prefixMatcher, boolean isJvmModule, @NotNull Function1<? super LookupElement, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.GENERAL_FILTER.isAcceptable((Object)position, position)) {
            return;
        }
        boolean sealedInterfacesEnabled = this.languageVersionSettingProvider.getLanguageVersionSetting(position).supportsFeature(LanguageFeature.SealedInterfaces);
        Function1<KtKeywordToken, Boolean> parserFilter = this.buildFilter(position);
        for (KtKeywordToken keywordToken : ALL_KEYWORDS) {
            Set set2 = this.getNextPossibleKeywords(keywordToken, position);
            if (set2 == null) {
                set2 = SetsKt.setOf(null);
            }
            Set nextKeywords = set2;
            Iterable $this$forEach$iv = nextKeywords;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtKeywordToken it = (KtKeywordToken)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.SEALED_KEYWORD) && Intrinsics.areEqual((Object)it, (Object)KtTokens.INTERFACE_KEYWORD) && !sealedInterfacesEnabled) continue;
                this.handleCompoundKeyword(position, keywordToken, it, isJvmModule, prefixMatcher, parserFilter, consumer);
            }
        }
    }

    private final Set<KtKeywordToken> getNextPossibleKeywords(KtKeywordToken $this$getNextPossibleKeywords, PsiElement position) {
        return Intrinsics.areEqual((Object)$this$getNextPossibleKeywords, (Object)KtTokens.SUSPEND_KEYWORD) && CompletionUtilsNoResolveKt.isInsideKtTypeReference(position) ? null : KeywordCompletion.Companion.getCompoundKeywords($this$getNextPossibleKeywords, this.languageVersionSettingProvider.getLanguageVersionSetting(position));
    }

    private final boolean avoidSuggestingWith(KtKeywordToken $this$avoidSuggestingWith, KtKeywordToken keywordToken) {
        Set<KtKeywordToken> set2 = COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER.get($this$avoidSuggestingWith);
        if (set2 == null) {
            return false;
        }
        Set<KtKeywordToken> nextKeywords = set2;
        return nextKeywords.contains(keywordToken);
    }

    private final boolean ignorePrefixForKeyword(PsiElement completionPosition, KtKeywordToken keywordToken) {
        KtKeywordToken ktKeywordToken = keywordToken;
        return Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.OVERRIDE_KEYWORD) ? true : ((((Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.THIS_KEYWORD) ? true : Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.RETURN_KEYWORD)) ? true : Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.BREAK_KEYWORD)) ? true : Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.CONTINUE_KEYWORD)) ? completionPosition instanceof KtExpressionWithLabel && ((KtExpressionWithLabel)completionPosition).getTargetLabel() != null : false);
    }

    private final void handleCompoundKeyword(PsiElement position, KtKeywordToken keywordToken, KtKeywordToken nextKeyword, boolean isJvmModule, PrefixMatcher prefixMatcher, Function1<? super KtKeywordToken, Boolean> parserFilter, Function1<? super LookupElement, Unit> consumer) {
        String string2 = keywordToken.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keywordToken.value");
        Object keyword = string2;
        boolean applicableAsCompound = false;
        if (nextKeyword != null) {
            boolean nextIsNotYetPresent;
            String next2 = null;
            PsiElement psiElement2 = PsiUtilsKt.nextLeaf((PsiElement)position, (Function1)handleCompoundKeyword.next.1.INSTANCE);
            String string3 = next2 = psiElement2 != null ? psiElement2.getText() : null;
            String string4 = next2 = string3 != null ? StringsKt.removePrefix((String)string3, (CharSequence)"$") : null;
            if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.SEALED_KEYWORD)) {
                String prev2;
                if (CollectionsKt.contains((Iterable)INCOMPATIBLE_KEYWORDS_AROUND_SEALED, (Object)next2)) {
                    return;
                }
                PsiElement psiElement3 = PsiUtilsKt.prevLeaf((PsiElement)position, (Function1)handleCompoundKeyword.prev.1.INSTANCE);
                String string5 = prev2 = psiElement3 != null ? psiElement3.getText() : null;
                if (CollectionsKt.contains((Iterable)INCOMPATIBLE_KEYWORDS_AROUND_SEALED, (Object)prev2)) {
                    return;
                }
            }
            Set<KtKeywordToken> set2 = this.getNextPossibleKeywords(keywordToken, position);
            if (set2 != null) {
                boolean bl;
                block17: {
                    Iterable $this$none$iv = set2;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtKeywordToken it = (KtKeywordToken)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)next2)) continue;
                            bl = false;
                            break block17;
                        }
                        bl = true;
                    }
                }
                v8 = bl;
            } else {
                v8 = nextIsNotYetPresent = false;
            }
            if (nextIsNotYetPresent && this.avoidSuggestingWith(keywordToken, nextKeyword)) {
                return;
            }
            if (nextIsNotYetPresent) {
                keyword = (String)keyword + " " + nextKeyword.getValue();
            } else {
                applicableAsCompound = true;
            }
        }
        if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.DYNAMIC_KEYWORD) && isJvmModule) {
            return;
        }
        if (!this.ignorePrefixForKeyword(position, keywordToken) && !prefixMatcher.isStartMatch((String)keyword)) {
            return;
        }
        if (!((Boolean)parserFilter.invoke((Object)keywordToken)).booleanValue()) {
            return;
        }
        String constructText = KEYWORD_CONSTRUCTS.get(keywordToken);
        if (constructText != null && !applicableAsCompound) {
            Project project2 = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"position.project");
            LookupElement element3 = HandlerUtilsKt.createKeywordConstructLookupElement$default(project2, (String)keyword, constructText, false, false, 24, null);
            consumer.invoke((Object)element3);
        } else {
            this.handleTopLevelClassName(position, (String)keyword, consumer);
            consumer.invoke((Object)this.createLookupElementBuilder((String)keyword, position));
        }
    }

    private final void handleTopLevelClassName(PsiElement position, String keyword, Function1<? super LookupElement, Unit> consumer) {
        String topLevelClassName = this.getTopLevelClassName(position);
        if (topLevelClassName != null) {
            boolean bl;
            block8: {
                Object[] objectArray = new KtKeywordToken[]{KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtKeywordToken it = (KtKeywordToken)element$iv;
                        boolean bl2 = false;
                        String string2 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.value");
                        if (!StringsKt.endsWith$default((String)keyword, (String)string2, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KeywordCompletion.handleTopLevelClassName$consumeClassNameWithoutBraces(consumer, this, keyword, topLevelClassName, position);
            }
            String string3 = KtTokens.CLASS_KEYWORD.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"CLASS_KEYWORD.value");
            if (StringsKt.endsWith$default((String)keyword, (String)string3, (boolean)false, (int)2, null)) {
                String string4 = KtTokens.DATA_KEYWORD.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DATA_KEYWORD.value");
                if (StringsKt.startsWith$default((String)keyword, (String)string4, (boolean)false, (int)2, null)) {
                    Project project2 = position.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"position.project");
                    consumer.invoke((Object)HandlerUtilsKt.createKeywordConstructLookupElement$default(project2, keyword, keyword + " " + topLevelClassName + "(caret)", false, false, 24, null));
                } else {
                    KeywordCompletion.handleTopLevelClassName$consumeClassNameWithoutBraces(consumer, this, keyword, topLevelClassName, position);
                }
            }
        }
    }

    private final LookupElementBuilder createLookupElementBuilder(String keyword, PsiElement position) {
        LookupElementBuilder lookupElementBuilder;
        PsiElement psiElement2 = PsiUtilsKt.prevLeaf$default((PsiElement)position, (boolean)false, (int)1, null);
        boolean isUseSiteAnnotationTarget = Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.AT);
        InsertHandler insertHandler = isUseSiteAnnotationTarget ? (InsertHandler)UseSiteAnnotationTargetInsertHandler.INSTANCE : (NO_SPACE_AFTER.contains(keyword) ? null : (InsertHandler)SpaceAfterInsertHandler.INSTANCE);
        LookupElementBuilder lookupElementBuilder2 = LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold().withInsertHandler(insertHandler);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"create(KeywordLookupObje\u2026ertHandler(insertHandler)");
        LookupElementBuilder element3 = lookupElementBuilder2;
        if (isUseSiteAnnotationTarget) {
            LookupElementBuilder lookupElementBuilder3 = element3.withPresentableText(keyword + ":");
            lookupElementBuilder = lookupElementBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder3, (String)"{\n            element.wi\u2026xt(\"$keyword:\")\n        }");
        } else {
            lookupElementBuilder = element3;
        }
        return lookupElementBuilder;
    }

    private final String getTopLevelClassName(PsiElement position) {
        String name2;
        block13: {
            block12: {
                boolean bl;
                block11: {
                    boolean bl2;
                    block10: {
                        Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)position);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!(it instanceof KtDeclaration)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        return null;
                    }
                    Iterator iterator2 = position.getContainingFile();
                    KtFile ktFile = iterator2 instanceof KtFile ? (KtFile)iterator2 : null;
                    if (ktFile == null) {
                        return null;
                    }
                    KtFile file2 = ktFile;
                    String string2 = FileUtil.getNameWithoutExtension((String)file2.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(file.name)");
                    name2 = string2;
                    if (!Name.isValidIdentifier((String)name2)) break block12;
                    Name name3 = Name.identifier((String)name2);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(name)");
                    if (!Intrinsics.areEqual((Object)RenderingUtilsKt.render((Name)name3), (Object)name2) || !Character.isUpperCase(name2.charAt(0))) break block12;
                    Iterable $this$any$iv = file2.getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl4 = false;
                            if (!(it instanceof KtClassOrObject && Intrinsics.areEqual((Object)((KtClassOrObject)it).getName(), (Object)name2))) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block13;
            }
            return null;
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<KtKeywordToken, Boolean> buildFilter(PsiElement position) {
        Ref.ObjectRef prevParent = new Ref.ObjectRef();
        prevParent.element = position;
        for (PsiElement parent2 = position.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBlockExpression) {
                Object v6;
                Object prefixText;
                block35: {
                    void $this$firstIsInstanceOrNull$iv;
                    if (prevParent.element instanceof KtScriptInitializer && ((KtBlockExpression)parent2).getParent() instanceof KtScript) {
                        Object v0;
                        boolean $i$f$firstIsInstanceOrNull;
                        Sequence $this$firstIsInstanceOrNull$iv2;
                        block32: {
                            $this$firstIsInstanceOrNull$iv2 = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)parent2);
                            $i$f$firstIsInstanceOrNull = false;
                            for (Object element$iv : $this$firstIsInstanceOrNull$iv2) {
                                if (!(element$iv instanceof KtScriptInitializer)) continue;
                                v0 = element$iv;
                                break block32;
                            }
                            v0 = null;
                        }
                        if (v0 == prevParent.element) {
                            Object v2;
                            block33: {
                                PsiElement psiElement3 = ((KtBlockExpression)parent2).getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent.parent");
                                $this$firstIsInstanceOrNull$iv2 = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)psiElement3);
                                $i$f$firstIsInstanceOrNull = false;
                                for (Object element$iv : $this$firstIsInstanceOrNull$iv2) {
                                    if (!(element$iv instanceof KtBlockExpression)) continue;
                                    v2 = element$iv;
                                    break block33;
                                }
                                v2 = null;
                            }
                            if (v2 == parent2) {
                                return this.buildFilterWithReducedContext("", null, position);
                            }
                        }
                    }
                    prefixText = "fun foo() { ";
                    if (prevParent.element instanceof KtExpression) {
                        PsiElement prevLeaf2 = PsiUtilsKt.prevLeaf((PsiElement)((PsiElement)prevParent.element), (Function1)buildFilter.prevLeaf.1.INSTANCE);
                        if (prevLeaf2 != null) {
                            boolean bl;
                            Iterator iterator2;
                            block34: {
                                Sequence<PsiElement> $this$any$iv = this.goUpWhileIsLastChild(prevLeaf2);
                                boolean $i$f$any = false;
                                iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    Object element$iv = iterator2.next();
                                    PsiElement it = (PsiElement)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtNodeTypes.THEN)) continue;
                                    bl = true;
                                    break block34;
                                }
                                bl = false;
                            }
                            boolean isAfterThen = bl;
                            boolean isAfterTry = false;
                            boolean isAfterCatch = false;
                            if (Intrinsics.areEqual((Object)prevLeaf2.getNode().getElementType(), (Object)KtTokens.RBRACE)) {
                                PsiElement psiElement4 = prevLeaf2.getParent();
                                KtBlockExpression ktBlockExpression = psiElement4 instanceof KtBlockExpression ? (KtBlockExpression)psiElement4 : null;
                                Object object = iterator2 = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
                                if (iterator2 instanceof KtTryExpression) {
                                    isAfterTry = true;
                                } else if (iterator2 instanceof KtCatchClause) {
                                    isAfterTry = true;
                                    isAfterCatch = true;
                                }
                            }
                            if (isAfterThen) {
                                prefixText = (String)prefixText + (isAfterTry ? "if (a)\n" : "if (a) {}\n");
                            }
                            if (isAfterTry) {
                                prefixText = (String)prefixText + "try {}\n";
                            }
                            if (isAfterCatch) {
                                prefixText = (String)prefixText + "catch (e: E) {}\n";
                            }
                        }
                        return this.buildFilterWithContext((String)prefixText, (PsiElement)prevParent.element, position);
                    }
                    Sequence isAfterThen = PsiUtilsKt.siblings((PsiElement)((PsiElement)prevParent.element), (boolean)false, (boolean)false);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v6 = element$iv;
                        break block35;
                    }
                    v6 = null;
                }
                KtExpression lastExpression = v6;
                if (lastExpression != null) {
                    String contextAfterExpression2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)lastExpression), (boolean)true, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef<PsiElement>)prevParent){
                        final /* synthetic */ Ref.ObjectRef<PsiElement> $prevParent;
                        {
                            this.$prevParent = $prevParent;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !Intrinsics.areEqual((Object)it, (Object)this.$prevParent.element);
                        }
                    })), null, null, null, (int)0, null, (Function1)buildFilter.contextAfterExpression.2.INSTANCE, (int)31, null);
                    return this.buildFilterWithContext((String)prefixText + "x" + contextAfterExpression2, (PsiElement)prevParent.element, position);
                }
            } else if (psiElement2 instanceof KtDeclarationWithInitializer) {
                KtExpression initializer2 = ((KtDeclarationWithInitializer)parent2).getInitializer();
                if (Intrinsics.areEqual((Object)prevParent.element, (Object)initializer2)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)initializer2, position);
                }
            } else if (psiElement2 instanceof KtParameter) {
                KtExpression ktExpression = ((KtParameter)parent2).getDefaultValue();
                if (Intrinsics.areEqual((Object)prevParent.element, (Object)ktExpression)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)ktExpression, position);
                }
            } else if (psiElement2 instanceof KtTypeReference) {
                boolean shouldIntroduceTypeReferenceContext;
                boolean bl = this.isExtensionReceiverInCallableDeclaration((KtTypeReference)parent2) ? false : (shouldIntroduceTypeReferenceContext = !(((KtTypeReference)parent2).getParent() instanceof KtConstructorCalleeExpression));
                if (shouldIntroduceTypeReferenceContext) {
                    String prefixText = this.isTypeArgumentOfOuterKtTypeReference((KtTypeReference)parent2) ? "fun foo(x: X<" : "fun foo(x: ";
                    return this.buildFilterWithContext(prefixText, parent2, position);
                }
            } else if (psiElement2 instanceof KtDeclaration) {
                PsiElement psiElement5 = ((KtDeclaration)parent2).getParent();
                if (psiElement5 instanceof KtClassOrObject) {
                    return parent2 instanceof KtPrimaryConstructor ? this.buildFilterWithReducedContext("class X ", parent2, position) : this.buildFilterWithReducedContext("class X { ", parent2, position);
                }
                if (psiElement5 instanceof KtFile) {
                    return this.buildFilterWithReducedContext("", parent2, position);
                }
            }
            prevParent.element = parent2;
        }
        return this.buildFilterWithReducedContext("", null, position);
    }

    private final boolean isExtensionReceiverInCallableDeclaration(KtTypeReference $this$isExtensionReceiverInCallableDeclaration) {
        PsiElement parent2 = $this$isExtensionReceiverInCallableDeclaration.getParent();
        return parent2 instanceof KtCallableDeclaration && Intrinsics.areEqual((Object)((KtCallableDeclaration)parent2).getReceiverTypeReference(), (Object)$this$isExtensionReceiverInCallableDeclaration);
    }

    private final boolean isTypeArgumentOfOuterKtTypeReference(KtTypeReference $this$isTypeArgumentOfOuterKtTypeReference) {
        KtUserType userType2;
        KtTypeArgumentList typeArgumentList2;
        KtTypeProjection typeProjection;
        PsiElement psiElement2 = $this$isTypeArgumentOfOuterKtTypeReference.getParent();
        KtTypeProjection ktTypeProjection = typeProjection = psiElement2 instanceof KtTypeProjection ? (KtTypeProjection)psiElement2 : null;
        PsiElement psiElement3 = ktTypeProjection != null ? ktTypeProjection.getParent() : null;
        KtTypeArgumentList ktTypeArgumentList = typeArgumentList2 = psiElement3 instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement3 : null;
        PsiElement psiElement4 = ktTypeArgumentList != null ? ktTypeArgumentList.getParent() : null;
        KtUserType ktUserType2 = userType2 = psiElement4 instanceof KtUserType ? (KtUserType)psiElement4 : null;
        return (ktUserType2 != null ? ktUserType2.getParent() : null) instanceof KtTypeReference;
    }

    private final Sequence<String> computeKeywordApplications(String prefixText, KtKeywordToken keyword) {
        Sequence sequence2;
        if (Intrinsics.areEqual((Object)keyword, (Object)KtTokens.SUSPEND_KEYWORD)) {
            Object[] objectArray = new String[]{"suspend () -> Unit>", "suspend X"};
            sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (StringsKt.endsWith$default((String)prefixText, (String)"@", (boolean)false, (int)2, null)) {
            Object[] objectArray = new String[]{keyword.getValue() + ":X Y.Z"};
            sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{keyword.getValue() + " X"};
            sequence2 = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence2;
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithContext(String prefixText, PsiElement contextElement, PsiElement position) {
        int offset2 = this.getStartOffsetInAncestor(position, contextElement);
        String string2 = contextElement.getText();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2.substring(0, offset2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String truncatedContext = string3;
        return this.buildFilterByText(prefixText + truncatedContext, position);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithReducedContext(String prefixText, PsiElement contextElement, PsiElement position) {
        StringBuilder builder2 = new StringBuilder();
        this.buildReducedContextBefore(builder2, position, contextElement);
        return this.buildFilterByText(prefixText + builder2, position);
    }

    private final Sequence<KtFile> buildFilesWithKeywordApplication(KtKeywordToken keywordTokenType, String prefixText, KtPsiFactory psiFactory) {
        return SequencesKt.map(this.computeKeywordApplications(prefixText, keywordTokenType), (Function1)((Function1)new Function1<String, KtFile>(psiFactory, prefixText){
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ String $prefixText;
            {
                this.$psiFactory = $psiFactory;
                this.$prefixText = $prefixText;
                super(1);
            }

            @NotNull
            public final KtFile invoke(@NotNull String application) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                return this.$psiFactory.createFile(this.$prefixText + application);
            }
        }));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterByText(String prefixText, PsiElement position) {
        Project project2 = position.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"position.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        return (Function1)new Function1<KtKeywordToken, Boolean>(this, prefixText, psiFactory, position){
            final /* synthetic */ KeywordCompletion this$0;
            final /* synthetic */ String $prefixText;
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ PsiElement $position;
            {
                this.this$0 = $receiver;
                this.$prefixText = $prefixText;
                this.$psiFactory = $psiFactory;
                this.$position = $position;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull KtKeywordToken keywordTokenType) {
                boolean bl;
                block1: {
                    void $this$any$iv;
                    Sequence files2;
                    Intrinsics.checkNotNullParameter((Object)keywordTokenType, (String)"keywordTokenType");
                    Sequence sequence2 = files2 = KeywordCompletion.access$buildFilesWithKeywordApplication(this.this$0, keywordTokenType, this.$prefixText, this.$psiFactory);
                    String string2 = this.$prefixText;
                    PsiElement psiElement2 = this.$position;
                    KeywordCompletion keywordCompletion2 = this.this$0;
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        KtFile file2 = (KtFile)element$iv;
                        boolean bl2 = false;
                        if (!KeywordCompletion.access$buildFilterByText$isKeywordCorrectlyApplied(string2, psiElement2, keywordCompletion2, keywordTokenType, file2)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
        };
    }

    private final boolean isSemicolon(PsiElement $this$isSemicolon) {
        return Intrinsics.areEqual((Object)$this$isSemicolon.getNode().getElementType(), (Object)KtTokens.SEMICOLON);
    }

    private final boolean isErrorElementBefore(PsiElement token) {
        for (PsiElement leaf : PsiUtilsKt.getPrevLeafs((PsiElement)token)) {
            boolean bl;
            block3: {
                if (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) continue;
                Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)leaf);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PsiErrorElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (leaf.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private final boolean matchesKeyword(IElementType $this$matchesKeyword, KtKeywordToken keywordType) {
        IElementType iElementType = $this$matchesKeyword;
        return Intrinsics.areEqual((Object)iElementType, (Object)keywordType) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) ? Intrinsics.areEqual((Object)keywordType, (Object)KtTokens.IN_KEYWORD) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS) ? Intrinsics.areEqual((Object)keywordType, (Object)KtTokens.IS_KEYWORD) : false));
    }

    private final boolean isModifierSupportedAtLanguageLevel(PsiElement position, KtKeywordToken keyword, LanguageVersionSettings languageVersionSettings2) {
        LanguageFeature languageFeature;
        KtKeywordToken ktKeywordToken = keyword;
        if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.TYPE_ALIAS_KEYWORD)) {
            languageFeature = LanguageFeature.TypeAliases;
        } else {
            if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.HEADER_KEYWORD) ? true : Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.IMPL_KEYWORD)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.EXPECT_KEYWORD) ? true : Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.ACTUAL_KEYWORD)) {
                languageFeature = LanguageFeature.MultiPlatformProjects;
            } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.SUSPEND_KEYWORD)) {
                languageFeature = LanguageFeature.Coroutines;
            } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.FIELD_KEYWORD)) {
                if (!this.isExplicitBackingFieldDeclaration(position)) {
                    return true;
                }
                languageFeature = LanguageFeature.ExplicitBackingFields;
            } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.CONTEXT_KEYWORD)) {
                languageFeature = LanguageFeature.ContextReceivers;
            } else {
                return true;
            }
        }
        LanguageFeature feature = languageFeature;
        return languageVersionSettings2.supportsFeature(feature);
    }

    private final boolean isModifierTargetSupportedAtLanguageLevel(KtKeywordToken keyword, KotlinTarget target2, LanguageVersionSettings languageVersionSettings2) {
        if (Intrinsics.areEqual((Object)keyword, (Object)KtTokens.LATEINIT_KEYWORD)) {
            LanguageFeature languageFeature;
            switch (WhenMappings.$EnumSwitchMapping$0[target2.ordinal()]) {
                case 3: {
                    languageFeature = LanguageFeature.LateinitTopLevelProperties;
                    break;
                }
                case 4: {
                    languageFeature = LanguageFeature.LateinitLocalVariables;
                    break;
                }
                default: {
                    return true;
                }
            }
            LanguageFeature feature = languageFeature;
            return languageVersionSettings2.supportsFeature(feature);
        }
        return true;
    }

    private final void buildReducedContextBefore(StringBuilder builder2, PsiElement position, PsiElement scope2) {
        Object v2;
        PsiElement parent2;
        block10: {
            if (Intrinsics.areEqual((Object)position, (Object)scope2)) {
                return;
            }
            if (position instanceof KtCodeFragment) {
                PsiElement psiElement2 = ((KtCodeFragment)position).getContext();
                KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
                if (ktElement == null) {
                    return;
                }
                KtElement ktContext = ktElement;
                this.buildReducedContextBefore(builder2, (PsiElement)ktContext, scope2);
                return;
            }
            if (position instanceof PsiFile) {
                return;
            }
            PsiElement psiElement3 = position.getParent();
            if (psiElement3 == null) {
                return;
            }
            parent2 = psiElement3;
            this.buildReducedContextBefore(builder2, parent2, scope2);
            Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)position, (boolean)false, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtDeclaration)) continue;
                v2 = element$iv;
                break block10;
            }
            v2 = null;
        }
        PsiElement prevDeclaration = v2;
        PsiElement child2 = parent2.getFirstChild();
        while (!Intrinsics.areEqual((Object)child2, (Object)position)) {
            if (child2 instanceof KtDeclaration) {
                if (Intrinsics.areEqual((Object)child2, (Object)prevDeclaration)) {
                    this.appendReducedText(builder2, child2);
                }
            } else {
                PsiElement psiElement4 = child2;
                Intrinsics.checkNotNull((Object)psiElement4);
                builder2.append(psiElement4.getText());
            }
            child2 = child2.getNextSibling();
        }
    }

    private final void appendReducedText(StringBuilder $this$appendReducedText, PsiElement element3) {
        PsiElement child2 = element3.getFirstChild();
        if (child2 == null) {
            String string2 = element3.getText();
            Intrinsics.checkNotNull((Object)string2);
            $this$appendReducedText.append(string2);
        } else {
            while (child2 != null) {
                PsiElement psiElement2 = child2;
                if (psiElement2 instanceof KtBlockExpression ? true : psiElement2 instanceof KtClassBody) {
                    $this$appendReducedText.append("{}");
                } else {
                    this.appendReducedText($this$appendReducedText, child2);
                }
                child2 = child2.getNextSibling();
            }
        }
    }

    private final int getStartOffsetInAncestor(PsiElement $this$getStartOffsetInAncestor, PsiElement ancestor) {
        if (Intrinsics.areEqual((Object)ancestor, (Object)$this$getStartOffsetInAncestor)) {
            return 0;
        }
        PsiElement psiElement2 = $this$getStartOffsetInAncestor.getParent();
        Intrinsics.checkNotNull((Object)psiElement2);
        return this.getStartOffsetInAncestor(psiElement2, ancestor) + $this$getStartOffsetInAncestor.getStartOffsetInParent();
    }

    private final Sequence<PsiElement> goUpWhileIsLastChild(PsiElement $this$goUpWhileIsLastChild) {
        return SequencesKt.generateSequence((Object)$this$goUpWhileIsLastChild, (Function1)goUpWhileIsLastChild.1.INSTANCE);
    }

    private final boolean isPossibleParentTarget(KtModifierKeywordToken modifier2, KotlinTarget parentTarget, LanguageVersionSettings languageVersionSettings2) {
        TargetAllowedPredicate targetAllowedPredicate;
        Set it;
        Set set2 = (Set)ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get(modifier2);
        if (set2 != null) {
            it = set2;
            boolean bl = false;
            if (it.contains(parentTarget)) {
                return false;
            }
        }
        if ((targetAllowedPredicate = (TargetAllowedPredicate)ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get(modifier2)) != null) {
            it = targetAllowedPredicate;
            boolean bl = false;
            return it.isAllowed(parentTarget, languageVersionSettings2);
        }
        return true;
    }

    private final boolean isExplicitBackingFieldDeclaration(PsiElement $this$isExplicitBackingFieldDeclaration) {
        return $this$isExplicitBackingFieldDeclaration.getParent() instanceof KtBackingField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean handleCompoundKeyword$isSpace(PsiElement $this$handleCompoundKeyword_u24isSpace) {
        if (!($this$handleCompoundKeyword_u24isSpace instanceof PsiWhiteSpace)) return false;
        String string2 = $this$handleCompoundKeyword_u24isSpace.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText()");
        if (StringsKt.contains$default((CharSequence)string2, (char)'\n', (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final void handleTopLevelClassName$consumeClassNameWithoutBraces(Function1<? super LookupElement, Unit> $consumer, KeywordCompletion this$0, String $keyword, String topLevelClassName, PsiElement $position) {
        $consumer.invoke((Object)this$0.createLookupElementBuilder($keyword + " " + topLevelClassName, $position));
    }

    private static final boolean buildFilterByText$isSecondaryConstructorInObjectDeclaration(PsiElement $this$buildFilterByText_u24isSecondaryConstructorInObjectDeclaration) {
        PsiElement $this$parentOfType_u24default$iv = $this$buildFilterByText_u24isSecondaryConstructorInObjectDeclaration;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtSecondaryConstructor.class, (boolean)true);
        if (ktSecondaryConstructor == null) {
            return false;
        }
        KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
        return secondaryConstructor.getContainingClassOrObject() instanceof KtObjectDeclaration;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final boolean buildFilterByText$isKeywordCorrectlyApplied(String $prefixText, PsiElement $position, KeywordCompletion this$0, KtKeywordToken keywordTokenType, KtFile file) {
        block49: {
            block48: {
                block47: {
                    v0 = file.findElementAt($prefixText.length());
                    Intrinsics.checkNotNull((Object)v0);
                    elementAt = v0;
                    v1 = ModuleUtilCore.findModuleForPsiElement((PsiElement)$position);
                    if (v1 == null) break block47;
                    var9_6 = v1;
                    var10_7 = this$0.languageVersionSettingProvider;
                    p0 = var9_6;
                    $i$a$-let-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$languageVersionSettings$1 = false;
                    v2 = var10_7.getLanguageVersionSetting(p0);
                    v1 = v2;
                    if (v2 != null) break block48;
                }
                v1 = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
            }
            languageVersionSettings = v1;
            v3 = elementAt.getNode();
            Intrinsics.checkNotNull((Object)v3);
            v4 = v3.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"elementAt.node!!.elementType");
            if (!this$0.matchesKeyword(v4, keywordTokenType)) {
                return false;
            }
            $this$getNonStrictParentOfType$iv = elementAt;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, PsiErrorElement.class, (boolean)false) != null) {
                return false;
            }
            if (this$0.isErrorElementBefore((PsiElement)elementAt)) {
                return false;
            }
            if (!this$0.isModifierSupportedAtLanguageLevel((PsiElement)elementAt, keywordTokenType, (LanguageVersionSettings)languageVersionSettings)) {
                return false;
            }
            if ((Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.VAL_KEYWORD) || Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.VAR_KEYWORD)) && elementAt.getParent() instanceof KtParameter && PsiTreeUtilKt.parentOfTypes$default((PsiElement)elementAt, (KClass[])($this$getNonStrictParentOfType$iv = new KClass[]{Reflection.getOrCreateKotlinClass(KtNamedFunction.class), Reflection.getOrCreateKotlinClass(KtSecondaryConstructor.class)}), (boolean)false, (int)2, null) != null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONSTRUCTOR_KEYWORD) && KeywordCompletion.buildFilterByText$isSecondaryConstructorInObjectDeclaration((PsiElement)elementAt)) {
                return false;
            }
            if (!(keywordTokenType instanceof KtModifierKeywordToken)) {
                return true;
            }
            var10_7 = elementAt.getParent();
            v5 = var10_7 instanceof KtModifierList != false ? (KtModifierList)var10_7 : null;
            v6 /* !! */  = v5 != null ? v5.getParent() : null;
            if (v6 /* !! */  == null) {
                return true;
            }
            container = v6 /* !! */ ;
            var9_6 = container;
            if (var9_6 instanceof KtParameter) {
                if (((KtParameter)container).getOwnerFunction() instanceof KtPrimaryConstructor) {
                    var10_7 = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.MEMBER_PROPERTY};
                    v7 = CollectionsKt.listOf((Object[])var10_7);
                } else {
                    v7 = CollectionsKt.listOf((Object)KotlinTarget.VALUE_PARAMETER);
                }
            } else if (var9_6 instanceof KtTypeParameter) {
                v7 = CollectionsKt.listOf((Object)KotlinTarget.TYPE_PARAMETER);
            } else if (var9_6 instanceof KtEnumEntry) {
                v7 = CollectionsKt.listOf((Object)KotlinTarget.ENUM_ENTRY);
            } else if (var9_6 instanceof KtClassBody) {
                var10_7 = new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
                v7 = CollectionsKt.listOf((Object[])var10_7);
            } else if (var9_6 instanceof KtFile) {
                var10_7 = new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
                v7 = CollectionsKt.listOf((Object[])var10_7);
            } else {
                v7 = CollectionsKt.emptyList();
            }
            possibleTargets = v7;
            v8 = (Set)ModifierCheckerHelpersKt.getPossibleTargetMap().get(keywordTokenType);
            v9 = modifierTargets = v8 != null ? CollectionsKt.intersect((Iterable)v8, (Iterable)possibleTargets) : null;
            if (modifierTargets != null && ((Collection)possibleTargets).isEmpty() == false) {
                block46: {
                    $this$none$iv = modifierTargets;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v10 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (KotlinTarget)element$iv;
                            $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$1 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!this$0.isModifierTargetSupportedAtLanguageLevel(keywordTokenType, it, (LanguageVersionSettings)languageVersionSettings)) continue;
                            v10 = false;
                            break block46;
                        }
                        v10 = true;
                    }
                }
                if (v10) {
                    return false;
                }
            }
            $i$a$-let-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$languageVersionSettings$1 = container;
            strict$iv = true;
            $i$f$getParentOfType = false;
            ownerDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv);
            if (ownerDeclaration == null) {
                v11 = KotlinTarget.FILE;
            } else if (ownerDeclaration instanceof KtClass) {
                v11 = ((KtClass)ownerDeclaration).isInterface() ? KotlinTarget.INTERFACE : (((KtClass)ownerDeclaration).isEnum() ? KotlinTarget.ENUM_CLASS : (((KtClass)ownerDeclaration).isAnnotation() ? KotlinTarget.ANNOTATION_CLASS : KotlinTarget.CLASS_ONLY));
            } else if (ownerDeclaration instanceof KtObjectDeclaration) {
                v11 = ((KtObjectDeclaration)ownerDeclaration).isObjectLiteral() ? KotlinTarget.OBJECT_LITERAL : KotlinTarget.OBJECT;
            } else {
                return Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONST_KEYWORD) == false;
            }
            parentTarget = v11;
            if (!this$0.isPossibleParentTarget((KtModifierKeywordToken)keywordTokenType, parentTarget, (LanguageVersionSettings)languageVersionSettings)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONST_KEYWORD)) break block49;
            switch (WhenMappings.$EnumSwitchMapping$0[parentTarget.ordinal()]) {
                case 1: {
                    v12 = true;
                    break;
                }
                case 2: {
                    v13 = elementAt.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"elementAt.parent");
                    prevSiblings = PsiUtilsKt.siblings((PsiElement)v13, (boolean)false, (boolean)false);
                    $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$1 = SequencesKt.takeWhile((Sequence)prevSiblings, (Function1)((Function1)new Function1<PsiElement, Boolean>(this$0){
                        final /* synthetic */ KeywordCompletion this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it instanceof PsiWhiteSpace || KeywordCompletion.access$isSemicolon(this.this$0, it);
                        }
                    }));
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-firstOrNull-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$hasLineBreak$2 = false;
                        v14 = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it.text");
                        if (!(StringsKt.contains$default((CharSequence)v14, (CharSequence)"\n", (boolean)false, (int)2, null) != false || this$0.isSemicolon(it) != false)) continue;
                        v15 = element$iv;
                        ** GOTO lbl127
                    }
                    v15 = null;
lbl127:
                    // 2 sources

                    v16 = hasLineBreak = v15 != null;
                    if (hasLineBreak) ** GOTO lbl139
                    $this$none$iv = prevSiblings;
                    $i$f$none = false;
                    for (E element$iv : $this$none$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$2 = false;
                        if (!(it instanceof PsiWhiteSpace == false && this$0.isSemicolon(it) == false && it instanceof KtImportList == false && it instanceof KtPackageDirective == false)) continue;
                        v17 = false;
                        ** GOTO lbl138
                    }
                    v17 = true;
lbl138:
                    // 2 sources

                    if (!v17) ** GOTO lbl141
lbl139:
                    // 2 sources

                    v12 = true;
                    break;
lbl141:
                    // 1 sources

                    v12 = false;
                    break;
                }
                default: {
                    v12 = false;
                }
            }
            return v12;
        }
        return true;
    }

    public static final /* synthetic */ boolean access$handleCompoundKeyword$isSpace(PsiElement $receiver) {
        return KeywordCompletion.handleCompoundKeyword$isSpace($receiver);
    }

    public static final /* synthetic */ Sequence access$buildFilesWithKeywordApplication(KeywordCompletion $this, KtKeywordToken keywordTokenType, String prefixText, KtPsiFactory psiFactory) {
        return $this.buildFilesWithKeywordApplication(keywordTokenType, prefixText, psiFactory);
    }

    public static final /* synthetic */ boolean access$buildFilterByText$isKeywordCorrectlyApplied(String $prefixText, PsiElement $position, KeywordCompletion this$0, KtKeywordToken keywordTokenType, KtFile file2) {
        return KeywordCompletion.buildFilterByText$isKeywordCorrectlyApplied($prefixText, $position, this$0, keywordTokenType, file2);
    }

    public static final /* synthetic */ boolean access$isSemicolon(KeywordCompletion $this, PsiElement $receiver) {
        return $this.isSemicolon($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_7;
        void $this$mapTo$iv$iv;
        Object[] $this$mapTo$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Companion = new Companion(null);
        IElementType[] iElementTypeArray = KtTokens.KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"KEYWORDS.types");
        Object[] objectArray = iElementTypeArray;
        IElementType[] iElementTypeArray2 = KtTokens.SOFT_KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray2, (String)"SOFT_KEYWORDS.types");
        Object $this$map$iv = ArraysKt.plus((Object[])objectArray, (Object[])iElementTypeArray2);
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean bl = false;
        for (KtKeywordToken item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            IElementType iElementType = (IElementType)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtKeywordToken");
            object.add((KtKeywordToken)it);
        }
        ALL_KEYWORDS = (List)destination$iv$iv;
        $this$map$iv = new KtModifierKeywordToken[]{KtTokens.SEALED_KEYWORD, KtTokens.ANNOTATION_KEYWORD, KtTokens.DATA_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.ABSTRACT_KEYWORD};
        $this$map$iv = SetsKt.setOf((Object[])$this$map$iv);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo232 = false;
        for (Object e : $this$mapTo$iv) {
            void it;
            KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)e;
            object = destination$iv;
            boolean bl3 = false;
            object.add(it.getValue());
        }
        INCOMPATIBLE_KEYWORDS_AROUND_SEALED = (HashSet)destination$iv;
        COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER = MapsKt.mapOf((Pair)TuplesKt.to((Object)KtTokens.SEALED_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.FUN_KEYWORD)));
        $this$mapTo$iv = new Pair[]{TuplesKt.to((Object)KtTokens.IF_KEYWORD, (Object)"fun foo() { if (caret)"), TuplesKt.to((Object)KtTokens.WHILE_KEYWORD, (Object)"fun foo() { while(caret)"), TuplesKt.to((Object)KtTokens.FOR_KEYWORD, (Object)"fun foo() { for(caret)"), TuplesKt.to((Object)KtTokens.TRY_KEYWORD, (Object)"fun foo() { try {\ncaret\n}"), TuplesKt.to((Object)KtTokens.CATCH_KEYWORD, (Object)"fun foo() { try {} catch (caret)"), TuplesKt.to((Object)KtTokens.FINALLY_KEYWORD, (Object)"fun foo() { try {\n}\nfinally{\ncaret\n}"), TuplesKt.to((Object)KtTokens.DO_KEYWORD, (Object)"fun foo() { do {\ncaret\n}"), TuplesKt.to((Object)KtTokens.INIT_KEYWORD, (Object)"class C { init {\ncaret\n}"), TuplesKt.to((Object)KtTokens.CONSTRUCTOR_KEYWORD, (Object)"class C { constructor(caret)")};
        KEYWORD_CONSTRUCTS = MapsKt.mapOf((Pair[])$this$mapTo$iv);
        $this$mapTo$iv = new KtKeywordToken[]{KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.DYNAMIC_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        $i$f$map = false;
        Object $i$f$mapTo232 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtKeywordToken item$iv$iv2;
            item$iv$iv2 = (KtKeywordToken)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object.add(it.getValue());
        }
        NO_SPACE_AFTER = CollectionsKt.plus((Collection)((List)var3_7), (Object)"companion object");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$CommentFilter;", "Lcom/intellij/psi/filters/ElementFilter;", "()V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "isClassAcceptable", "hintClass", "Ljava/lang/Class;", "kotlin.completion.impl-shared"})
    private static final class CommentFilter
    implements ElementFilter {
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            return element3 instanceof PsiElement && KtPsiUtil.isInComment((PsiElement)((PsiElement)element3));
        }

        public boolean isClassAcceptable(@NotNull Class<? extends Object> hintClass) {
            Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$Companion;", "", "()V", "ALL_KEYWORDS", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER", "", "", "INCOMPATIBLE_KEYWORDS_AROUND_SEALED", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "KEYWORD_CONSTRUCTS", "NO_SPACE_AFTER", "getCompoundKeywords", "token", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin.completion.impl-shared"})
    @SourceDebugExtension(value={"SMAP\nKeywordCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,765:1\n1#2:766\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<KtKeywordToken> getCompoundKeywords(KtKeywordToken token, LanguageVersionSettings languageVersionSettings2) {
            KtKeywordToken ktKeywordToken;
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to((Object)KtTokens.COMPANION_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.OBJECT_KEYWORD));
            Object[] objectArray = new KtKeywordToken[2];
            objectArray[0] = KtTokens.CLASS_KEYWORD;
            KtKeywordToken ktKeywordToken2 = ktKeywordToken = KtTokens.OBJECT_KEYWORD;
            int n = 1;
            Object[] objectArray2 = objectArray;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
            int n2 = 1;
            Pair[] pairArray2 = pairArray;
            boolean bl = false;
            boolean bl2 = languageVersionSettings2.supportsFeature(LanguageFeature.DataObjects);
            objectArray2[n] = bl2 ? ktKeywordToken : null;
            pairArray2[n2] = TuplesKt.to((Object)ktModifierKeywordToken, (Object)SetsKt.setOfNotNull((Object[])objectArray));
            pairArray[2] = TuplesKt.to((Object)KtTokens.ENUM_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.CLASS_KEYWORD));
            pairArray[3] = TuplesKt.to((Object)KtTokens.ANNOTATION_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.CLASS_KEYWORD));
            objectArray = new KtKeywordToken[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.FUN_KEYWORD};
            pairArray[4] = TuplesKt.to((Object)KtTokens.SEALED_KEYWORD, (Object)SetsKt.setOf((Object[])objectArray));
            pairArray[5] = TuplesKt.to((Object)KtTokens.LATEINIT_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.VAR_KEYWORD));
            pairArray[6] = TuplesKt.to((Object)KtTokens.CONST_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.VAL_KEYWORD));
            pairArray[7] = TuplesKt.to((Object)KtTokens.SUSPEND_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.FUN_KEYWORD));
            return (Set)MapsKt.mapOf((Pair[])pairArray).get(token);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$FileFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl-shared"})
    private static final class FileFilter
    extends PositionElementFilter {
        public FileFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            if (!(element3 instanceof PsiElement)) return false;
            PsiElement psiElement2 = (PsiElement)element3;
            if (psiElement2 == null) return false;
            PsiFile psiFile2 = psiElement2.getContainingFile();
            PsiFile file2 = psiFile2;
            if (file2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)file2, context2);
            if (!bl) return false;
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;", "", "getLanguageVersionSetting", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "module", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl-shared"})
    public static interface LanguageVersionSettingProvider {
        @NotNull
        public LanguageVersionSettings getLanguageVersionSetting(@NotNull PsiElement var1);

        @NotNull
        public LanguageVersionSettings getLanguageVersionSetting(@NotNull Module var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$ParentFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl-shared"})
    private static final class ParentFilter
    extends PositionElementFilter {
        public ParentFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            if (!(element3 instanceof PsiElement)) return false;
            PsiElement psiElement2 = (PsiElement)element3;
            if (psiElement2 == null) return false;
            PsiElement psiElement3 = psiElement2.getParent();
            PsiElement parent2 = psiElement3;
            if (parent2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)parent2, context2);
            if (!bl) return false;
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$SpaceAfterInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "kotlin.completion.impl-shared"})
    private static final class SpaceAfterInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final SpaceAfterInsertHandler INSTANCE = new SpaceAfterInsertHandler();

        private SpaceAfterInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            WithTailInsertHandler.Companion.getSPACE().postHandleInsert(context2, item);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$UseSiteAnnotationTargetInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "kotlin.completion.impl-shared"})
    private static final class UseSiteAnnotationTargetInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final UseSiteAnnotationTargetInsertHandler INSTANCE = new UseSiteAnnotationTargetInsertHandler();

        private UseSiteAnnotationTargetInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            new WithTailInsertHandler(":", false, false, false, 8, null).postHandleInsert(context2, item);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinTarget.values().length];
            try {
                nArray[KotlinTarget.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.TOP_LEVEL_PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.LOCAL_VARIABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

