/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.SmartCompletionTailOffsetProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "tailText", "", "spaceBefore", "", "spaceAfter", "overwriteText", "(Ljava/lang/String;ZZZ)V", "asPostInsertHandler", "getAsPostInsertHandler", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "getOverwriteText", "()Z", "getSpaceAfter", "getSpaceBefore", "getTailText", "()Ljava/lang/String;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "postHandleInsert", "shouldOverwriteChar", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "Companion", "kotlin.completion.impl-shared"})
@SourceDebugExtension(value={"SMAP\nWithTailInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WithTailInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,100:1\n51#2:101\n*S KotlinDebug\n*F\n+ 1 WithTailInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler\n*L\n44#1:101\n*E\n"})
public final class WithTailInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tailText;
    private final boolean spaceBefore;
    private final boolean spaceAfter;
    private final boolean overwriteText;
    @NotNull
    private static final WithTailInsertHandler COMMA = new WithTailInsertHandler(",", false, true, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler RPARENTH = new WithTailInsertHandler(")", false, false, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler RBRACKET = new WithTailInsertHandler("]", false, false, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler RBRACE = new WithTailInsertHandler("}", true, false, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler ELSE = new WithTailInsertHandler("else", true, true, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler EQ = new WithTailInsertHandler("=", true, true, false, 8, null);
    @NotNull
    private static final WithTailInsertHandler SPACE = new WithTailInsertHandler(" ", false, false, true);

    public WithTailInsertHandler(@NotNull String tailText2, boolean spaceBefore, boolean spaceAfter, boolean overwriteText) {
        Intrinsics.checkNotNullParameter((Object)tailText2, (String)"tailText");
        this.tailText = tailText2;
        this.spaceBefore = spaceBefore;
        this.spaceAfter = spaceAfter;
        this.overwriteText = overwriteText;
    }

    public /* synthetic */ WithTailInsertHandler(String string2, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        this(string2, bl, bl2, bl3);
    }

    @NotNull
    public final String getTailText() {
        return this.tailText;
    }

    public final boolean getSpaceBefore() {
        return this.spaceBefore;
    }

    public final boolean getSpaceAfter() {
        return this.spaceAfter;
    }

    public final boolean getOverwriteText() {
        return this.overwriteText;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        item.handleInsert(context2);
        this.postHandleInsert(context2, item);
    }

    @NotNull
    public final InsertHandler<LookupElement> getAsPostInsertHandler() {
        return (arg_0, arg_1) -> WithTailInsertHandler._get_asPostInsertHandler_$lambda$0(this, arg_0, arg_1);
    }

    public final void postHandleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        block11: {
            char completionChar;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Character c = StringsKt.singleOrNull((CharSequence)this.tailText);
            if (c != null && (completionChar = context2.getCompletionChar()) == c.charValue() || this.spaceAfter && completionChar == ' ') {
                context2.setAddCompletionChar(false);
            }
            Document document = context2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(document2);
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            SmartCompletionTailOffsetProvider smartCompletionTailOffsetProvider = (SmartCompletionTailOffsetProvider)(application != null ? application.getService(SmartCompletionTailOffsetProvider.class) : null);
            int tailOffset = smartCompletionTailOffsetProvider != null ? smartCompletionTailOffsetProvider.getTailOffset(context2, item) : context2.getTailOffset();
            boolean moveCaret = context2.getEditor().getCaretModel().getOffset() == tailOffset;
            boolean insert = true;
            if (this.overwriteText) {
                int offset2 = tailOffset;
                if (!Intrinsics.areEqual((Object)this.tailText, (Object)" ")) {
                    CharSequence charSequence2 = document2.getCharsSequence();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.charsSequence");
                    offset2 = HandlerUtilsKt.skipSpacesAndLineBreaks(charSequence2, offset2);
                }
                if (this.shouldOverwriteChar(document2, offset2)) {
                    insert = false;
                    tailOffset = offset2 += this.tailText.length();
                    if (this.spaceAfter) {
                        CharSequence charSequence3 = document2.getCharsSequence();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"document.charsSequence");
                        if (HandlerUtilsKt.isCharAt(charSequence3, offset2, ' ')) {
                            document2.deleteString(offset2, offset2 + 1);
                        }
                    }
                }
            }
            Object textToInsert = "";
            if (insert) {
                textToInsert = this.tailText;
                if (this.spaceBefore) {
                    textToInsert = " " + (String)textToInsert;
                }
            }
            if (this.spaceAfter) {
                textToInsert = (String)textToInsert + " ";
            }
            document2.insertString(tailOffset, (CharSequence)textToInsert);
            if (!moveCaret) break block11;
            context2.getEditor().getCaretModel().moveToOffset(tailOffset + ((String)textToInsert).length());
            if (Intrinsics.areEqual((Object)this.tailText, (Object)",")) {
                AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context2.getProject());
                if (autoPopupController != null) {
                    autoPopupController.autoPopupParameterInfo(context2.getEditor(), null);
                }
            }
        }
    }

    private final boolean shouldOverwriteChar(Document document, int offset2) {
        if (!HandlerUtilsKt.isTextAt(document, offset2, this.tailText)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tailText, (Object)" ")) {
            CharSequence charSequence2 = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.charsSequence");
            if (HandlerUtilsKt.isCharAt(charSequence2, offset2 + 1, '}')) {
                return false;
            }
        }
        return true;
    }

    private static final void _get_asPostInsertHandler_$lambda$0(WithTailInsertHandler this$0, InsertionContext context2, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this$0.postHandleInsert(context2, item);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler$Companion;", "", "()V", "COMMA", "Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "getCOMMA", "()Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "ELSE", "getELSE", "EQ", "getEQ", "RBRACE", "getRBRACE", "RBRACKET", "getRBRACKET", "RPARENTH", "getRPARENTH", "SPACE", "getSPACE", "kotlin.completion.impl-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WithTailInsertHandler getCOMMA() {
            return COMMA;
        }

        @NotNull
        public final WithTailInsertHandler getRPARENTH() {
            return RPARENTH;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACKET() {
            return RBRACKET;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACE() {
            return RBRACE;
        }

        @NotNull
        public final WithTailInsertHandler getELSE() {
            return ELSE;
        }

        @NotNull
        public final WithTailInsertHandler getEQ() {
            return EQ;
        }

        @NotNull
        public final WithTailInsertHandler getSPACE() {
            return SPACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

