/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.filter.KotlinExtraSteppingFilterKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter;", "Lcom/intellij/debugger/engine/ExtraSteppingFilter;", "()V", "getStepRequestDepth", "", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "isApplicable", "", "kotlin.jvm-debugger.core"})
public final class KotlinExtraSteppingFilter
implements ExtraSteppingFilter {
    public boolean isApplicable(@Nullable SuspendContext context2) {
        SuspendContext suspendContext = context2;
        if (suspendContext == null || (suspendContext = suspendContext.getDebugProcess()) == null) {
            return false;
        }
        SuspendContext debugProcess = suspendContext;
        Object object = context2.getFrameProxy();
        if (object == null || (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) == null) {
            return false;
        }
        Object location2 = object;
        ReferenceType referenceType = location2.declaringType();
        String string2 = referenceType != null ? referenceType.defaultStratum() : null;
        if (string2 == null) {
            return false;
        }
        String defaultStratum = string2;
        if (!Intrinsics.areEqual((Object)defaultStratum, (Object)"Kotlin")) {
            return false;
        }
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>((DebugProcess)debugProcess, (Location)location2){
            final /* synthetic */ DebugProcess $debugProcess;
            final /* synthetic */ Location $location;
            {
                this.$debugProcess = $debugProcess;
                this.$location = $location;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                KotlinPositionManager positionManager = new KotlinPositionManager(this.$debugProcess);
                SourcePosition sourcePosition2 = SafeUtilKt.safeGetSourcePosition((PositionManager)positionManager, this.$location);
                if (sourcePosition2 == null) {
                    return false;
                }
                SourcePosition sourcePosition3 = sourcePosition2;
                if (DebuggerUtil.isInSuspendMethod(this.$location) && DebuggerUtil.isOnSuspendReturnOrReenter(this.$location) && !KotlinExtraSteppingFilterKt.access$isOneLineMethod(this.$location)) {
                    return true;
                }
                DebuggerSettings settings2 = DebuggerSettings.getInstance();
                if (settings2.TRACING_FILTERS_ENABLED) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Project project2 = this.$debugProcess.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
                    GlobalSearchScope globalSearchScope = this.$debugProcess.getSearchScope();
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"debugProcess.searchScope");
                    ClassNameProvider classNameProvider = new ClassNameProvider(project2, globalSearchScope, ClassNameProvider.Configuration.copy$default(ClassNameProvider.Configuration.Companion.getDEFAULT(), false, false, 2, null));
                    Iterable iterable = classNameProvider.getCandidates(sourcePosition3);
                    boolean $i$f$map = false;
                    ClassFilter[] classFilterArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(StringsKt.replace$default((String)it, (char)'/', (char)'.', (boolean)false, (int)4, null));
                    }
                    List classNames = (List)destination$iv$iv;
                    for (String className : classNames) {
                        Intrinsics.checkNotNullExpressionValue((Object)settings2.getSteppingFilters(), (String)"settings.steppingFilters");
                        for (ClassFilter filter2 : classFilterArray) {
                            if (!filter2.isEnabled() || !filter2.matches(className)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }));
    }

    public int getStepRequestDepth(@Nullable SuspendContext context2) {
        return 1;
    }
}

