/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.VariableWithLocation;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrame;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrameProxyKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00192\u0006\u0010$\u001a\u00020%R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;", "", "scopeVariable", "Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "enclosingStackFrame", "visibleVariablesWithLocations", "", "depth", "", "(Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo;Ljava/util/List;I)V", "callLocation", "Lcom/sun/jdi/Location;", "getCallLocation", "()Lcom/sun/jdi/Location;", "setCallLocation", "(Lcom/sun/jdi/Location;)V", "getDepth", "()I", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "getScopeVariable", "()Lorg/jetbrains/kotlin/idea/debugger/core/VariableWithLocation;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "getVisibleVariables", "()Ljava/util/List;", "getVisibleVariablesWithLocations", "toXStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "visibleVariableProxies", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nInlineStackTraceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n1620#2,3:388\n1549#2:391\n1620#2,3:392\n*S KotlinDebug\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrameInfo\n*L\n79#1:388,3\n85#1:391\n85#1:392,3\n*E\n"})
public final class KotlinStackFrameInfo {
    @Nullable
    private final VariableWithLocation scopeVariable;
    @Nullable
    private final KotlinStackFrameInfo enclosingStackFrame;
    @NotNull
    private final List<VariableWithLocation> visibleVariablesWithLocations;
    private final int depth;
    @Nullable
    private Location callLocation;

    public KotlinStackFrameInfo(@Nullable VariableWithLocation scopeVariable, @Nullable KotlinStackFrameInfo enclosingStackFrame, @NotNull List<VariableWithLocation> visibleVariablesWithLocations, int depth2) {
        Intrinsics.checkNotNullParameter(visibleVariablesWithLocations, (String)"visibleVariablesWithLocations");
        this.scopeVariable = scopeVariable;
        this.enclosingStackFrame = enclosingStackFrame;
        this.visibleVariablesWithLocations = visibleVariablesWithLocations;
        this.depth = depth2;
    }

    @Nullable
    public final VariableWithLocation getScopeVariable() {
        return this.scopeVariable;
    }

    @NotNull
    public final List<VariableWithLocation> getVisibleVariablesWithLocations() {
        return this.visibleVariablesWithLocations;
    }

    public final int getDepth() {
        return this.depth;
    }

    @Nullable
    public final Location getCallLocation() {
        return this.callLocation;
    }

    public final void setCallLocation(@Nullable Location location2) {
        this.callLocation = location2;
    }

    @Nullable
    public final String getDisplayName() {
        List groupValues;
        Object object = this.scopeVariable;
        if (object == null || (object = ((VariableWithLocation)object).getName()) == null) {
            return null;
        }
        Object scopeVariableName = object;
        if (StringsKt.startsWith$default((String)scopeVariableName, (String)"$i$f$", (boolean)false, (int)2, null)) {
            return StringsKt.substringAfter$default((String)scopeVariableName, (String)"$i$f$", null, (int)2, null);
        }
        MatchResult matchResult2 = InlineStackTraceCalculatorKt.access$getINLINE_LAMBDA_REGEX$p().matchEntire((CharSequence)scopeVariableName);
        List list2 = groupValues = matchResult2 != null ? matchResult2.getGroupValues() : null;
        if (groupValues != null) {
            String lambdaName = (String)CollectionsKt.getOrNull((List)groupValues, (int)1);
            String declarationFunctionName = (String)CollectionsKt.getOrNull((List)groupValues, (int)2);
            return "lambda '" + lambdaName + "' in '" + declarationFunctionName + "'";
        }
        return scopeVariableName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariable> getVisibleVariables() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.visibleVariablesWithLocations;
        Object object = this.enclosingStackFrame;
        if (object == null || (object = ((KotlinStackFrameInfo)object).getVisibleVariables()) == null || (object = CollectionsKt.toMutableList((Collection)((Collection)object))) == null) {
            object = new ArrayList();
        }
        Collection destination$iv = (Collection)object;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VariableWithLocation variableWithLocation = (VariableWithLocation)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getVariable());
        }
        return StackFrameUtilsKt.filterRepeatedVariables((List)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariableProxyImpl> visibleVariableProxies(@NotNull StackFrameProxyImpl frameProxy) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Iterable $this$map$iv = this.getVisibleVariables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalVariable localVariable = (LocalVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LocalVariableProxyImpl(frameProxy, (LocalVariable)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final XStackFrame toXStackFrame(@NotNull StackFrameDescriptorImpl descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        StackFrameProxyImpl stackFrameProxyImpl = descriptor2.getFrameProxy();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"descriptor.frameProxy");
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        List<LocalVariableProxyImpl> variables2 = this.visibleVariableProxies(frameProxy);
        String string2 = this.getDisplayName();
        if (string2 != null) {
            String name2 = string2;
            boolean bl = false;
            return (XStackFrame)new InlineStackFrame(this.callLocation, name2, frameProxy, this.depth, variables2);
        }
        if (Intrinsics.areEqual((Object)descriptor2.getLocation(), (Object)this.callLocation)) {
            return (XStackFrame)new KotlinStackFrame(descriptor2, variables2);
        }
        return (XStackFrame)new KotlinStackFrame(InlineStackFrameProxyKt.safeInlineStackFrameProxy(this.callLocation, 0, frameProxy), variables2);
    }
}

