/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.util.InlineAnalysisUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.FragmentProjectFileDependencyCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"analyzeCalls", "", "fragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "gatherProjectFilesDependedOnByFragment", "", "kotlin.jvm-debugger.evaluation"})
public final class FragmentProjectFileDependencyCollectorKt {
    @NotNull
    public static final Set<KtFile> gatherProjectFilesDependedOnByFragment(@NotNull KtCodeFragment fragment, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(fragment);
        Set result2 = new LinkedHashSet();
        List<KtFile> files2 = InlineAnalysisUtilsKt.analyzeInlinedFunctions(resolutionFacade2, (KtFile)fragment, false);
        boolean bl = false;
        for (KtFile file2 : files2) {
            result2.add(file2);
        }
        FragmentProjectFileDependencyCollectorKt.analyzeCalls(fragment, bindingContext2, result2);
        return result2;
    }

    private static final void analyzeCalls(KtCodeFragment fragment, BindingContext bindingContext2, Set<KtFile> files2) {
        Project project2 = fragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"fragment.project");
        Project project3 = project2;
        fragment.accept((PsiElementVisitor)new KtTreeVisitorVoid(bindingContext2, project3, files2){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<KtFile> $files;
            {
                this.$bindingContext = $bindingContext;
                this.$project = $project;
                this.$files = $files;
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                Call call = (Call)this.$bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression2);
                if (call == null) {
                    return;
                }
                Call call2 = call;
                Object[] objectArray = (Object[])this.$bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                if (objectArray == null) {
                    return;
                }
                Object[] resolvedCall2 = objectArray;
                CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                Project project2 = this.$project;
                Set<KtFile> set2 = this.$files;
                Object $this$visitExpression_u24lambda_u240 = resolvedCall2;
                boolean bl = false;
                analyzeCalls.1.visitExpression$processClassReceiver(project2, set2, $this$visitExpression_u24lambda_u240.getDispatchReceiver());
                List list2 = $this$visitExpression_u24lambda_u240.getContextReceivers();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"contextReceivers");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ReceiverValue p0 = (ReceiverValue)element$iv;
                    boolean bl2 = false;
                    analyzeCalls.1.visitExpression$processClassReceiver(project2, set2, p0);
                }
                if (descriptor2 instanceof ReceiverParameterDescriptor) {
                    analyzeCalls.1.visitExpression$processClassReceiver(this.$project, this.$files, ((ReceiverParameterDescriptor)descriptor2).getValue());
                }
                MemberDescriptor memberDescriptor = descriptor2 instanceof MemberDescriptor ? (MemberDescriptor)descriptor2 : null;
                boolean bl3 = memberDescriptor != null ? memberDescriptor.isActual() : false;
                if (bl3) {
                    void $this$forEach$iv2;
                    Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
                    PsiElement actualDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                    KtDeclaration ktDeclaration = actualDeclaration instanceof KtDeclaration ? (KtDeclaration)actualDeclaration : null;
                    KtDeclaration expectedDeclaration = ktDeclaration != null ? ExpectActualUtilKt.expectedDeclarationIfAny(ktDeclaration) : null;
                    $this$visitExpression_u24lambda_u240 = new PsiElement[]{actualDeclaration, expectedDeclaration};
                    $this$visitExpression_u24lambda_u240 = CollectionsKt.listOfNotNull((Object[])$this$visitExpression_u24lambda_u240);
                    Set<KtFile> set3 = this.$files;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl4 = false;
                        PsiFile psiFile2 = it.getContainingFile();
                        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        set3.add((KtFile)psiFile2);
                    }
                }
                if (Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                    if (psiElement2 == null) {
                        return;
                    }
                    declaration = psiElement2;
                    PsiFile psiFile3 = declaration.getContainingFile();
                    Intrinsics.checkNotNull((Object)psiFile3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    this.$files.add((KtFile)psiFile3);
                } else {
                    ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
                    if (Intrinsics.areEqual((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL)) {
                        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getDispatchReceiverParameter();
                        var7_7 = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getValue() : null;
                        ThisClassReceiver thisClassReceiver = var7_7 instanceof ThisClassReceiver ? (ThisClassReceiver)var7_7 : null;
                        if (thisClassReceiver == null) {
                            return;
                        }
                        ThisClassReceiver thisReceiver2 = thisClassReceiver;
                        PsiElement psiElement3 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)thisReceiver2.getClassDescriptor()));
                        if (psiElement3 == null) {
                            return;
                        }
                        PsiElement declaration2 = psiElement3;
                        PsiFile psiFile4 = declaration2.getContainingFile();
                        KtFile ktFile = psiFile4 instanceof KtFile ? (KtFile)psiFile4 : null;
                        if (ktFile == null) {
                            return;
                        }
                        this.$files.add(ktFile);
                    } else {
                        ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
                        if (Intrinsics.areEqual((Object)(classConstructorDescriptor != null && (classConstructorDescriptor = classConstructorDescriptor.getConstructedClass()) != null ? classConstructorDescriptor.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL)) {
                            ClassDescriptor classDescriptor = ((ClassConstructorDescriptor)descriptor2).getConstructedClass();
                            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor).constructedClass");
                            PsiElement psiElement4 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor));
                            if (psiElement4 == null) {
                                return;
                            }
                            declaration = psiElement4;
                            var7_7 = declaration.getContainingFile();
                            KtFile ktFile = var7_7 instanceof KtFile ? (KtFile)var7_7 : null;
                            if (ktFile == null) {
                                return;
                            }
                            this.$files.add(ktFile);
                        }
                    }
                }
            }

            private static final void visitExpression$processClassReceiver(Project project2, Set<KtFile> $files, ReceiverValue receiver2) {
                if (receiver2 instanceof ContextClassReceiver || receiver2 instanceof ImplicitClassReceiver && Intrinsics.areEqual((Object)((ImplicitClassReceiver)receiver2).getClassDescriptor().getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
                    ImplicitReceiver implicitReceiver = receiver2 instanceof ImplicitReceiver ? (ImplicitReceiver)receiver2 : null;
                    if (implicitReceiver == null || (implicitReceiver = implicitReceiver.getDeclarationDescriptor()) == null) {
                        return;
                    }
                    ImplicitReceiver declarationDescriptor = implicitReceiver;
                    PsiElement psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)declarationDescriptor);
                    if (psiElement2 == null) {
                        return;
                    }
                    PsiElement declaration2 = psiElement2;
                    PsiFile psiFile2 = declaration2.getContainingFile();
                    Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    $files.add((KtFile)psiFile2);
                }
            }
        });
    }
}

