/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.sequence;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.StreamCallChecker;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/sequence/SequenceCallChecker;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;", "()V", "isIntermediateCall", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isSequenceInheritor", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isSequenceType", "isTerminationCall", "kotlin.jvm-debugger.sequence"})
@SourceDebugExtension(value={"SMAP\nSequenceCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SequenceCallChecker.kt\norg/jetbrains/kotlin/idea/debugger/sequence/psi/sequence/SequenceCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1747#2,3:32\n*S KotlinDebug\n*F\n+ 1 SequenceCallChecker.kt\norg/jetbrains/kotlin/idea/debugger/sequence/psi/sequence/SequenceCallChecker\n*L\n27#1:32,3\n*E\n"})
public final class SequenceCallChecker
implements StreamCallChecker {
    @Override
    public boolean isIntermediateCall(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KotlinType kotlinType = UtilsKt.receiverType(expression2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType receiverType2 = kotlinType;
        KotlinType kotlinType2 = UtilsKt.resolveType$default((KtExpression)expression2, null, 1, null);
        if (kotlinType2 == null) {
            return false;
        }
        KotlinType expressionType2 = kotlinType2;
        return this.isSequenceInheritor(receiverType2) && this.isSequenceInheritor(expressionType2);
    }

    @Override
    public boolean isTerminationCall(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KotlinType kotlinType = UtilsKt.receiverType(expression2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType receiverType2 = kotlinType;
        KotlinType kotlinType2 = UtilsKt.resolveType$default((KtExpression)expression2, null, 1, null);
        if (kotlinType2 == null) {
            return false;
        }
        KotlinType expressionType2 = kotlinType2;
        return this.isSequenceInheritor(receiverType2) && !this.isSequenceInheritor(expressionType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSequenceInheritor(KotlinType type2) {
        KotlinType p0;
        if (this.isSequenceType(type2)) return true;
        Iterable $this$any$iv = TypeUtilsKt.supertypes((KotlinType)type2);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            p0 = (KotlinType)element$iv;
            boolean bl = false;
        } while (!this.isSequenceType(p0));
        return true;
    }

    private final boolean isSequenceType(KotlinType type2) {
        return Intrinsics.areEqual((Object)"kotlin.sequences.Sequence", (Object)KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2));
    }
}

