/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

final class LtGtTypingUtils {
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE});

    private LtGtTypingUtils() {
    }

    static void handleKotlinAutoCloseLT(Editor editor2) {
        TypedHandlerUtil.handleAfterGenericLT((Editor)editor2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean handleKotlinGTInsert(Editor editor2) {
        return TypedHandlerUtil.handleGenericGT((Editor)editor2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static void handleKotlinLTDeletion(Editor editor2, int offset2) {
        TypedHandlerUtil.handleGenericLTDeletion((Editor)editor2, (int)offset2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean shouldAutoCloseAngleBracket(int offset2, Editor editor2) {
        return LtGtTypingUtils.isAfterClassIdentifier(offset2, editor2) || LtGtTypingUtils.isAfterToken(offset2, editor2, (KtToken)KtTokens.FUN_KEYWORD);
    }

    private static boolean isAfterClassIdentifier(int offset2, Editor editor2) {
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return TypedHandlerUtil.isClassLikeIdentifier((int)offset2, (Editor)editor2, (HighlighterIterator)iterator2, (IElementType)KtTokens.IDENTIFIER);
    }

    static boolean isAfterToken(int offset2, Editor editor2, KtToken tokenType) {
        HighlighterIterator iterator2 = editor2.getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        if (iterator2.getTokenType() == KtTokens.WHITE_SPACE && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return iterator2.getTokenType() == tokenType;
    }
}

