/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "()V", "getOriginalPsiClassOrCreateLightClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "getTarget", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetByContainingElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinTypeHierarchyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypeHierarchyProvider.kt\norg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,93:1\n146#2:94\n*S KotlinDebug\n*F\n+ 1 KotlinTypeHierarchyProvider.kt\norg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider\n*L\n68#1:94\n*E\n"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiClass getOriginalPsiClassOrCreateLightClass(KtClassOrObject classOrObject, Module module2) {
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            Module module3 = module2;
            if (JvmPlatformKt.isJvm((TargetPlatform)(module3 != null ? TargetPlatformDetectorUtils.getPlatform(module3) : null))) {
                FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
                Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"fqName.toUnsafe()");
                ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
                if (javaClassId != null) {
                    return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
                }
            }
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
        return ktLightClass != null ? (PsiClass)ktLightClass : (PsiClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)classOrObject);
    }

    private final PsiClass getTargetByReference(Project project2, Editor editor2, Module module2) {
        PsiClass psiClass2;
        PsiElement target2 = TargetElementUtil.findTargetElement((Editor)editor2, (int)TargetElementUtil.getInstance().getAllAccepted());
        if (target2 instanceof PsiClass) {
            psiClass2 = (PsiClass)target2;
        } else if (target2 instanceof KtConstructor) {
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass(((KtConstructor)target2).getContainingClassOrObject(), module2);
        } else if (target2 instanceof KtClassOrObject) {
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target2, module2);
        } else if (target2 instanceof KtNamedFunction) {
            String returnTypeText;
            String string2 = ((KtNamedFunction)target2).getName();
            if (string2 == null) {
                return null;
            }
            String functionName = string2;
            KtTypeReference ktTypeReference = ((KtNamedFunction)target2).getTypeReference();
            String string3 = returnTypeText = ktTypeReference != null ? ktTypeReference.getText() : null;
            if (!Intrinsics.areEqual(string3 != null ? StringsKt.substringAfter$default((String)string3, (String)".", null, (int)2, null) : null, (Object)functionName)) {
                return null;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)KotlinClassShortNameIndex.Helper.get(functionName, project2, globalSearchScope));
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass(classOrObject, module2);
        } else {
            psiClass2 = null;
        }
        return psiClass2;
    }

    private final PsiClass getTargetByContainingElement(Editor editor2, PsiFile file2) {
        PsiElement element3;
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element3 = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return this.getOriginalPsiClassOrCreateLightClass(classOrObject, GenericPsiUtils.getModule((PsiElement)file2));
    }

    @Nullable
    public PsiClass getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        Editor editor2 = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor2 != null) {
            PsiClass psiElement2;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(editor2.getDocument());
            if (psiFile2 == null) {
                return null;
            }
            PsiFile file2 = psiFile2;
            if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)file2)) {
                return null;
            }
            PsiClass psiClass2 = this.getTargetByReference(project3, editor2, GenericPsiUtils.getModule((PsiElement)file2));
            if (psiClass2 == null) {
                psiClass2 = this.getTargetByContainingElement(editor2, file2);
            }
            if ((psiElement2 = psiClass2) instanceof PsiNamedElement && psiElement2.getName() == null) {
                return null;
            }
            return psiElement2;
        }
        PsiElement element3 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element3 instanceof KtClassOrObject) {
            return this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element3, GenericPsiUtils.getModule(element3));
        }
        return null;
    }
}

