/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtDiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticKt;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixService;
import org.jetbrains.kotlin.idea.highlighting.KotlinDiagnosticHighlightVisitor;
import org.jetbrains.kotlin.idea.inspections.suppress.CompilerWarningIntentionAction;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressableWarningProblemGroup;
import org.jetbrains.kotlin.idea.statistics.compilationError.KotlinCompilationErrorFrequencyStatsCollector;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0003J\u001c\u0010\u001f\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "()V", "addDiagnostic", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "diagnostic", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "analyze", "", "file", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "action", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/psi/KtFile;", "clone", "isInternalOrUnitTestMode", "suitableForFile", "visit", "element", "Lcom/intellij/psi/PsiElement;", "getHighlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "getMessageToRender", "", "Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnostic;", "isDeprecatedDiagnostic", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/diagnostics/KtDiagnosticWithPsi;)Z", "isUnresolvedDiagnostic", "kotlin.highlighting"})
@SourceDebugExtension(value={"SMAP\nKotlinDiagnosticHighlightVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDiagnosticHighlightVisitor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n32#2,7:147\n55#3:154\n54#3,3:155\n75#3,8:158\n1#4:166\n1855#5,2:167\n*S KotlinDebug\n*F\n+ 1 KotlinDiagnosticHighlightVisitor.kt\norg/jetbrains/kotlin/idea/highlighting/KotlinDiagnosticHighlightVisitor\n*L\n54#1:147,7\n54#1:154\n54#1:155,3\n54#1:158,8\n75#1:167,2\n*E\n"})
public final class KotlinDiagnosticHighlightVisitor
implements HighlightVisitor {
    public boolean suitableForFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof KtFile;
    }

    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (!(file2 instanceof KtFile)) {
            return false;
        }
        HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance((Project)((KtFile)file2).getProject());
        if (highlightingLevelManager.runEssentialHighlightingOnly((PsiElement)file2)) {
            return true;
        }
        try {
            this.analyze((KtFile)file2, holder);
            action2.run();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void analyze(KtFile file2, HighlightInfoHolder holder) {
        void this_$iv$iv$iv;
        void this_$iv$iv;
        Object nonDefaultLifetimeTokenFactory$iv = null;
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)file2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtLifetimeTokenFactory factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
        void var8_8 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)file2, factory$iv$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtAnalysisSession $this$analyze_u24lambda_u240 = analysisSession$iv$iv$iv;
            boolean bl = false;
            Collection<KtDiagnosticWithPsi<?>> diagnostics2 = $this$analyze_u24lambda_u240.collectDiagnosticsForFile(file2, KtDiagnosticCheckerFilter.ONLY_COMMON_CHECKERS);
            for (KtDiagnosticWithPsi<?> diagnostic : diagnostics2) {
                this.addDiagnostic($this$analyze_u24lambda_u240, diagnostic, holder);
            }
            KotlinCompilationErrorFrequencyStatsCollector.Companion.recordCompilationErrorsHappened((Sequence<String>)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)diagnostics2), (Function1)analyze.1.1.INSTANCE), (Function1)((Function1)analyze.1.2.INSTANCE)), file2);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    private final void addDiagnostic(KtAnalysisSession _context_receiver_0, KtDiagnosticWithPsi<?> diagnostic, HighlightInfoHolder holder) {
        List list2;
        boolean isWarning = diagnostic.getSeverity() == Severity.WARNING;
        String factoryName = diagnostic.getFactoryName();
        List it = list2 = KotlinQuickFixService.Companion.getInstance().getQuickFixesFor(_context_receiver_0, diagnostic);
        boolean bl = false;
        List list3 = !((Collection)it).isEmpty() ? list2 : null;
        if (list3 == null) {
            list3 = isWarning && factoryName != null ? CollectionsKt.listOf((Object)((Object)new CompilerWarningIntentionAction(factoryName))) : CollectionsKt.emptyList();
        }
        List fixes2 = list3;
        KotlinSuppressableWarningProblemGroup problemGroup = isWarning && factoryName != null ? new KotlinSuppressableWarningProblemGroup(factoryName) : null;
        Iterable $this$forEach$iv = diagnostic.getTextRanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HighlightInfo.Builder infoBuilder;
            TextRange range2 = (TextRange)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)HighlightInfo.newHighlightInfo((HighlightInfoType)this.getHighlightInfoType(_context_receiver_0, diagnostic)).descriptionAndTooltip(this.getMessageToRender(diagnostic)).range(range2), (String)"newHighlightInfo(diagnos\u2026            .range(range)");
            if (problemGroup != null) {
                infoBuilder.problemGroup((ProblemGroup)problemGroup);
            }
            for (IntentionAction quickFixInfo : fixes2) {
                List options2 = new ArrayList();
                if (quickFixInfo instanceof IntentionActionWithOptions) {
                    Collection collection = options2;
                    List list4 = ((IntentionActionWithOptions)quickFixInfo).getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"quickFixInfo.options");
                    CollectionsKt.addAll((Collection)collection, (Iterable)list4);
                }
                if (problemGroup != null) {
                    CollectionsKt.addAll((Collection)options2, (Object[])problemGroup.getSuppressActions((PsiElement)diagnostic.getPsi()));
                }
                infoBuilder.registerFix(quickFixInfo, options2, null, null, null);
            }
            holder.add(infoBuilder.create());
        }
    }

    @NlsSafe
    private final String getMessageToRender(KtDiagnostic $this$getMessageToRender) {
        return this.isInternalOrUnitTestMode() ? KtDiagnosticKt.getDefaultMessageWithFactoryName($this$getMessageToRender) : $this$getMessageToRender.getDefaultMessage();
    }

    private final boolean isInternalOrUnitTestMode() {
        Application application = ApplicationManager.getApplication();
        return application.isInternal() || application.isUnitTestMode();
    }

    private final HighlightInfoType getHighlightInfoType(KtAnalysisSession _context_receiver_0, KtDiagnosticWithPsi<?> $this$getHighlightInfoType) {
        HighlightInfoType highlightInfoType;
        if (this.isUnresolvedDiagnostic(_context_receiver_0, $this$getHighlightInfoType)) {
            HighlightInfoType highlightInfoType2 = HighlightInfoType.WRONG_REF;
            highlightInfoType = highlightInfoType2;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType2, (String)"WRONG_REF");
        } else if (this.isDeprecatedDiagnostic(_context_receiver_0, $this$getHighlightInfoType)) {
            HighlightInfoType highlightInfoType3 = HighlightInfoType.DEPRECATED;
            highlightInfoType = highlightInfoType3;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType3, (String)"DEPRECATED");
        } else {
            HighlightInfoType highlightInfoType4 = switch (WhenMappings.$EnumSwitchMapping$0[$this$getHighlightInfoType.getSeverity().ordinal()]) {
                case 1 -> HighlightInfoType.INFORMATION;
                case 2 -> HighlightInfoType.ERROR;
                case 3 -> HighlightInfoType.WARNING;
                default -> throw new NoWhenBranchMatchedException();
            };
            highlightInfoType = highlightInfoType4;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoType4, (String)"when (severity) {\n      \u2026ype.WARNING\n            }");
        }
        return highlightInfoType;
    }

    private final boolean isUnresolvedDiagnostic(KtAnalysisSession _context_receiver_0, KtDiagnosticWithPsi<?> $this$isUnresolvedDiagnostic) {
        KtDiagnosticWithPsi<?> ktDiagnosticWithPsi = $this$isUnresolvedDiagnostic;
        return ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedReference ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedLabel ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedReferenceWrongReceiver ? true : (ktDiagnosticWithPsi instanceof KtFirDiagnostic.UnresolvedImport ? true : ktDiagnosticWithPsi instanceof KtFirDiagnostic.MissingStdlibClass)));
    }

    private final boolean isDeprecatedDiagnostic(KtAnalysisSession _context_receiver_0, KtDiagnosticWithPsi<?> $this$isDeprecatedDiagnostic) {
        return $this$isDeprecatedDiagnostic instanceof KtFirDiagnostic.Deprecation;
    }

    public void visit(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
    }

    @NotNull
    public HighlightVisitor clone() {
        return new KotlinDiagnosticHighlightVisitor();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

