/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractMessage", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findVariableDeclaration", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "fixText", "inspectionText", "isApplicable", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifyAssertNotNullInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyAssertNotNullInspection.kt\norg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,112:1\n15#2,2:113\n*S KotlinDebug\n*F\n+ 1 SimplifyAssertNotNullInspection.kt\norg/jetbrains/kotlin/idea/inspections/SimplifyAssertNotNullInspection\n*L\n100#1:113,2\n*E\n"})
public final class SimplifyAssertNotNullInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    public SimplifyAssertNotNullInspection() {
        super(KtCallExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null), (Object)"assert")) {
            return false;
        }
        List list2 = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.valueArguments");
        List arguments2 = list2;
        if (arguments2.size() != 1 && arguments2.size() != 2) {
            return false;
        }
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first((List)arguments2)).getArgumentExpression();
        KtBinaryExpression ktBinaryExpression = ktExpression2 instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression2 : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)KtTokens.EXCLEQ)) {
            return false;
        }
        KtExpression ktExpression3 = IfThenUtilsKt.expressionComparedToNull(condition2);
        KtNameReferenceExpression ktNameReferenceExpression2 = ktExpression3 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression3 : null;
        if (ktNameReferenceExpression2 == null) {
            return false;
        }
        KtNameReferenceExpression value2 = ktNameReferenceExpression2;
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return false;
        }
        KtVariableDeclaration prevDeclaration = ktVariableDeclaration;
        if (!Intrinsics.areEqual((Object)value2.getReferencedNameAsName(), (Object)prevDeclaration.getNameAsName())) {
            return false;
        }
        if (prevDeclaration.getInitializer() == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)element3, null, 1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall3)) {
            return false;
        }
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        FunctionDescriptor functionDescriptor2 = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor function2 = functionDescriptor2;
        FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)function2);
        if (!Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)"kotlin.assert")) {
            return false;
        }
        return arguments2.size() == 1 || this.extractMessage(element3) != null;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("assert.should.be.replaced.with.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.assert.with.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtCallExpression element3) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.getValueArguments().size() == 1) {
            Object[] objectArray = new Object[]{"!!"};
            string2 = KotlinBundle.message("replace.with.0.operator", objectArray);
        } else {
            string2 = KotlinBundle.message("replace.with.error", new Object[0]);
        }
        return string2;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtExpression newInitializer;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KtVariableDeclaration ktVariableDeclaration = this.findVariableDeclaration(element3);
        if (ktVariableDeclaration == null) {
            return;
        }
        KtVariableDeclaration declaration2 = ktVariableDeclaration;
        KtExpression ktExpression = declaration2.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KtExpression initializer2 = ktExpression;
        KtExpression message2 = this.extractMessage(element3);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        if (message2 == null) {
            var9_8 = new Object[]{initializer2};
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)"$0!!", (Object[])var9_8, (boolean)false, (int)4, null);
            initializer2.replace((PsiElement)newInitializer);
        } else {
            var9_8 = new Object[]{initializer2, message2};
            newInitializer = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)"$0 ?: kotlin.error($1)", (Object[])var9_8, (boolean)false, (int)4, null);
            PsiElement result2 = initializer2.replace((PsiElement)newInitializer);
            Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            KtExpression ktExpression2 = ((KtBinaryExpression)result2).getRight();
            Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
            KtDotQualifiedExpression qualifiedExpression = (KtDotQualifiedExpression)ktExpression2;
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)qualifiedExpression));
            KtExpression ktExpression3 = qualifiedExpression.getSelectorExpression();
            Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            KtExpression ktExpression4 = ((KtCallExpression)ktExpression3).getCalleeExpression();
            Intrinsics.checkNotNull((Object)ktExpression4);
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktFile, n, PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktExpression4)), null, false, 24, null);
        }
        element3.delete();
        CommentSaver.restore$default(commentSaver, (PsiElement)declaration2, false, 2, null);
        if (editor2 != null) {
            int n;
            KtVariableDeclaration ktVariableDeclaration2 = (KtVariableDeclaration)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)declaration2));
            if (ktVariableDeclaration2 == null || (ktVariableDeclaration2 = ktVariableDeclaration2.getInitializer()) == null) {
                return;
            }
            newInitializer = ktVariableDeclaration2;
            if (message2 == null) {
                n = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newInitializer));
            } else {
                KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)newInitializer).getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"newInitializer as KtBina\u2026ssion).operationReference");
                n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktOperationReferenceExpression));
            }
            int offset2 = n;
            GenerateUtilsKt.moveCaret$default(editor2, offset2, null, 2, null);
        }
    }

    private final KtVariableDeclaration findVariableDeclaration(KtCallExpression element3) {
        Object v0;
        block2: {
            if (!(element3.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.siblings((PsiElement)((PsiElement)element3), (boolean)false, (boolean)false);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object var2_6 = v0;
        return var2_6 instanceof KtVariableDeclaration ? (KtVariableDeclaration)var2_6 : null;
    }

    private final KtExpression extractMessage(KtCallExpression element3) {
        List list2;
        List list3 = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"element.valueArguments");
        List arguments2 = list3;
        if (arguments2.size() != 2) {
            return null;
        }
        KtExpression ktExpression = ((KtValueArgument)arguments2.get(1)).getArgumentExpression();
        KtLambdaExpression ktLambdaExpression2 = ktExpression instanceof KtLambdaExpression ? (KtLambdaExpression)ktExpression : null;
        return ktLambdaExpression2 != null && (ktExpression = ktLambdaExpression2.getBodyExpression()) != null && (list2 = ktExpression.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)list2) : null;
    }
}

