/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.inspections.collections.CallChain;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u000fH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000eH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"collectionTerminationFunctionNames", "", "", "getCollectionTerminationFunctionNames", "()Ljava/util/List;", "collectionTransformationFunctionNames", "getCollectionTransformationFunctionNames", "lazyTerminations", "", "Lorg/jetbrains/kotlin/name/FqName;", "terminations", "transformationAndTerminations", "transformations", "collectCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findCallChain", "Lorg/jetbrains/kotlin/idea/inspections/collections/CallChain;", "hasReturn", "", "isLazyTermination", "isTermination", "isTransformationOrTermination", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertCallChainIntoSequenceInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertCallChainIntoSequenceInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,319:1\n731#2,9:320\n1747#2,2:329\n1749#2:343\n1271#2,2:344\n1285#2,4:346\n1271#2,2:350\n1285#2,4:352\n243#3:331\n254#3,10:332\n276#3:342\n526#4:356\n511#4,6:357\n*S KotlinDebug\n*F\n+ 1 ConvertCallChainIntoSequenceInspection.kt\norg/jetbrains/kotlin/idea/inspections/collections/ConvertCallChainIntoSequenceInspectionKt\n*L\n162#1:320,9\n168#1:329,2\n168#1:343\n229#1:344,2\n229#1:346,4\n311#1:350,2\n311#1:352,4\n169#1:331\n169#1:332,10\n169#1:342\n316#1:356\n316#1:357,6\n*E\n"})
public final class ConvertCallChainIntoSequenceInspectionKt {
    @NotNull
    private static final List<String> collectionTransformationFunctionNames;
    @NonNls
    @NotNull
    private static final Map<String, FqName> transformations;
    @NotNull
    private static final List<String> collectionTerminationFunctionNames;
    @NonNls
    @NotNull
    private static final Map<String, FqName> terminations;
    @NotNull
    private static final Map<String, FqName> lazyTerminations;
    @NotNull
    private static final Map<String, FqName> transformationAndTerminations;

    private static final CallChain findCallChain(KtQualifiedExpression $this$findCallChain) {
        KotlinType receiverType2;
        if ($this$findCallChain.getParent() instanceof KtQualifiedExpression) {
            return null;
        }
        BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$findCallChain, BodyResolveMode.PARTIAL);
        List<KtCallExpression> calls = ConvertCallChainIntoSequenceInspectionKt.collectCallExpression($this$findCallChain, context2);
        if (calls.isEmpty()) {
            return null;
        }
        KtCallExpression lastCall = (KtCallExpression)CollectionsKt.last(calls);
        KotlinType kotlinType = receiverType2 = FunctionUtilsKt.receiverType(lastCall, context2);
        if (!(kotlinType != null ? FunctionUtilsKt.isIterable$default(kotlinType, null, 1, null) : false)) {
            return null;
        }
        KtCallExpression firstCall = (KtCallExpression)CollectionsKt.first(calls);
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)firstCall));
        if (ktQualifiedExpression == null && (ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)firstCall))) == null) {
            return null;
        }
        KtQualifiedExpression qualified = ktQualifiedExpression;
        return new CallChain(qualified, lastCall, calls.size());
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtCallExpression> collectCallExpression(KtQualifiedExpression $this$collectCallExpression, BindingContext context2) {
        List transformationCalls2;
        void $this$dropLastWhile$iv;
        List calls = new ArrayList();
        ConvertCallChainIntoSequenceInspectionKt.collectCallExpression$collect(calls, context2, $this$collectCallExpression);
        if (calls.size() < 2) {
            return CollectionsKt.emptyList();
        }
        List list2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)calls), (Function1)((Function1)new Function1<KtCallExpression, Boolean>(context2){
            final /* synthetic */ BindingContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtCallExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !ConvertCallChainIntoSequenceInspectionKt.access$isTransformationOrTermination(it, this.$context);
            }
        })), (Function1)((Function1)new Function1<KtCallExpression, Boolean>(context2){
            final /* synthetic */ BindingContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtCallExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ConvertCallChainIntoSequenceInspectionKt.access$isTransformationOrTermination(it, this.$context) && !ConvertCallChainIntoSequenceInspectionKt.access$hasReturn(it);
            }
        })));
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                KtCallExpression it = (KtCallExpression)iterator$iv.previous();
                boolean bl = false;
                if (ConvertCallChainIntoSequenceInspectionKt.isLazyTermination(it, context2)) continue;
                v0 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            v0 = transformationCalls2 = CollectionsKt.emptyList();
        }
        if (transformationCalls2.size() < 2) {
            return CollectionsKt.emptyList();
        }
        return transformationCalls2;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReturn(KtCallExpression $this$hasReturn) {
        boolean bl;
        block3: {
            List list2 = $this$hasReturn.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"valueArguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    void $this$anyDescendantOfType$iv;
                    KtValueArgument arg = (KtValueArgument)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"arg");
                    PsiElement psiElement2 = (PsiElement)arg;
                    Function1 predicate$iv = hasReturn.1.1.INSTANCE;
                    boolean $i$f$anyDescendantOfType = false;
                    void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                    boolean $i$f$findDescendantOfType = false;
                    void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                    boolean $i$f$findDescendantOfType2 = false;
                    PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
                    Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(@NotNull PsiElement element3) {
                            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                            if (element3 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                this.$result.element = element3;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element3;
                            boolean bl = false;
                            super.visitElement(element3);
                        }
                    });
                    boolean bl3 = (PsiElement)result$iv$iv$iv.element != null;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isTransformationOrTermination(KtCallExpression $this$isTransformationOrTermination, BindingContext context2) {
        Map<String, FqName> map2 = transformationAndTerminations;
        KtExpression ktExpression = $this$isTransformationOrTermination.getCalleeExpression();
        FqName fqName2 = map2.get(ktExpression != null ? ktExpression.getText() : null);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTransformationOrTermination, fqName3, context2);
    }

    private static final boolean isTermination(KtCallExpression $this$isTermination, BindingContext context2) {
        Map<String, FqName> map2 = terminations;
        KtExpression ktExpression = $this$isTermination.getCalleeExpression();
        FqName fqName2 = map2.get(ktExpression != null ? ktExpression.getText() : null);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isTermination, fqName3, context2);
    }

    private static final boolean isLazyTermination(KtCallExpression $this$isLazyTermination, BindingContext context2) {
        Map<String, FqName> map2 = lazyTerminations;
        KtExpression ktExpression = $this$isLazyTermination.getCalleeExpression();
        FqName fqName2 = map2.get(ktExpression != null ? ktExpression.getText() : null);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        return FunctionUtilsKt.isCalling($this$isLazyTermination, fqName3, context2);
    }

    @NotNull
    public static final List<String> getCollectionTransformationFunctionNames() {
        return collectionTransformationFunctionNames;
    }

    @NotNull
    public static final List<String> getCollectionTerminationFunctionNames() {
        return collectionTerminationFunctionNames;
    }

    private static final void collectCallExpression$collect(List<KtCallExpression> calls, BindingContext $context, KtQualifiedExpression qualified) {
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(qualified);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression call = ktCallExpression;
        calls.add(call);
        KtExpression receiver2 = qualified.getReceiverExpression();
        if (receiver2 instanceof KtCallExpression && FunctionUtilsKt.implicitReceiver((KtCallExpression)receiver2, $context) != null) {
            calls.add((KtCallExpression)receiver2);
            return;
        }
        if (receiver2 instanceof KtQualifiedExpression) {
            ConvertCallChainIntoSequenceInspectionKt.collectCallExpression$collect(calls, $context, (KtQualifiedExpression)receiver2);
        }
    }

    public static final /* synthetic */ CallChain access$findCallChain(KtQualifiedExpression $receiver) {
        return ConvertCallChainIntoSequenceInspectionKt.findCallChain($receiver);
    }

    public static final /* synthetic */ List access$collectCallExpression(KtQualifiedExpression $receiver, BindingContext context2) {
        return ConvertCallChainIntoSequenceInspectionKt.collectCallExpression($receiver, context2);
    }

    public static final /* synthetic */ boolean access$isTermination(KtCallExpression $receiver, BindingContext context2) {
        return ConvertCallChainIntoSequenceInspectionKt.isTermination($receiver, context2);
    }

    public static final /* synthetic */ boolean access$isTransformationOrTermination(KtCallExpression $receiver, BindingContext context2) {
        return ConvertCallChainIntoSequenceInspectionKt.isTransformationOrTermination($receiver, context2);
    }

    public static final /* synthetic */ boolean access$hasReturn(KtCallExpression $receiver) {
        return ConvertCallChainIntoSequenceInspectionKt.hasReturn($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        FqName fqName2;
        String it;
        Map map2;
        Object t;
        Object object;
        Object[] objectArray = new String[]{"chunked", "distinct", "distinctBy", "drop", "dropWhile", "filter", "filterIndexed", "filterIsInstance", "filterNot", "filterNotNull", "flatten", "map", "mapIndexed", "mapIndexedNotNull", "mapNotNull", "minus", "minusElement", "onEach", "onEachIndexed", "plus", "plusElement", "requireNoNulls", "runningFold", "runningFoldIndexed", "runningReduce", "runningReduceIndexed", "scan", "scanIndexed", "sorted", "sortedBy", "sortedByDescending", "sortedDescending", "sortedWith", "take", "takeWhile", "windowed", "withIndex", "zipWithNext"};
        collectionTransformationFunctionNames = CollectionsKt.listOf((Object[])objectArray);
        Object $this$associateWith$iv = (Object[])collectionTransformationFunctionNames;
        boolean $i$f$associateWith = false;
        Map<Object, Object> result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            object = (String)element$iv$iv;
            t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            fqName2 = new FqName("kotlin.collections." + it);
            map2.put(t, fqName2);
        }
        transformations = result$iv;
        $this$associateWith$iv = new String[]{"all", "any", "asIterable", "asSequence", "associate", "associateBy", "associateByTo", "associateTo", "average", "contains", "count", "elementAt", "elementAtOrElse", "elementAtOrNull", "filterIndexedTo", "filterIsInstanceTo", "filterNotNullTo", "filterNotTo", "filterTo", "find", "findLast", "first", "firstNotNullOf", "firstNotNullOfOrNull", "firstOrNull", "fold", "foldIndexed", "groupBy", "groupByTo", "groupingBy", "indexOf", "indexOfFirst", "indexOfLast", "joinTo", "joinToString", "last", "lastIndexOf", "lastOrNull", "mapIndexedNotNullTo", "mapIndexedTo", "mapNotNullTo", "mapTo", "maxOrNull", "maxByOrNull", "maxWithOrNull", "maxOf", "maxOfOrNull", "maxOfWith", "maxOfWithOrNull", "minOrNull", "minByOrNull", "minWithOrNull", "minOf", "minOfOrNull", "minOfWith", "minOfWithOrNull", "none", "partition", "reduce", "reduceIndexed", "reduceIndexedOrNull", "reduceOrNull", "single", "singleOrNull", "sum", "sumBy", "sumByDouble", "sumOf", "toCollection", "toHashSet", "toList", "toMutableList", "toMutableSet", "toSet", "toSortedSet", "unzip"};
        collectionTerminationFunctionNames = CollectionsKt.listOf((Object[])$this$associateWith$iv);
        $this$associateWith$iv = collectionTerminationFunctionNames;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (String)element$iv$iv;
            t = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{"contains", "indexOf", "lastIndexOf"};
            String pkg = CollectionsKt.listOf((Object[])objectArray2).contains(it) ? "kotlin.collections.List" : "kotlin.collections";
            fqName2 = new FqName(pkg + "." + it);
            map2.put(t, fqName2);
        }
        terminations = result$iv;
        Map<String, FqName> $this$filter$iv = terminations;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            object = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            String key = (String)object.getKey();
            if (!Intrinsics.areEqual((Object)key, (Object)"groupingBy")) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        lazyTerminations = var3_3;
        transformationAndTerminations = MapsKt.plus(transformations, terminations);
    }
}

