/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.ConvertConcatenationToBuildStringIntentionUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\n*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertConcatenationToBuildStringIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "isConcatenation", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class ConvertConcatenationToBuildStringIntention
extends SelfTargetingIntention<KtBinaryExpression> {
    public ConvertConcatenationToBuildStringIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("convert.concatenation.to.build.string", new Object[0]), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!this.isConcatenation((PsiElement)element3)) return false;
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        if (this.isConcatenation(psiElement2)) return false;
        if (KotlinPsiUtils.isAnnotationArgument((KtExpression)element3)) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression buildStringCall = ConvertConcatenationToBuildStringIntentionUtilsKt.convertConcatenationToBuildStringCall(element3);
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)buildStringCall, null, 2, null);
    }

    private final boolean isConcatenation(PsiElement $this$isConcatenation) {
        if (!($this$isConcatenation instanceof KtBinaryExpression)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isConcatenation).getOperationToken(), (Object)KtTokens.PLUS)) {
            return false;
        }
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)$this$isConcatenation), (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$isConcatenation, BodyResolveMode.PARTIAL));
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isString((KotlinType)type2);
    }
}

