/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertUnsafeCastCallToUnsafeCastIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class ConvertUnsafeCastCallToUnsafeCastIntention
extends SelfTargetingIntention<KtDotQualifiedExpression> {
    public ConvertUnsafeCastCallToUnsafeCastIntention() {
        super(KtDotQualifiedExpression.class, KotlinBundle.lazyMessage("convert.to.unsafe.cast", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtDotQualifiedExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)element3))) {
            return false;
        }
        KtExpression ktExpression = element3.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"unsafeCast")) {
            return false;
        }
        Object object = ResolutionUtils.resolveToCall$default((KtElement)element3, null, 1, null);
        if (object == null || (object = object.getResultingDescriptor()) == null || (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return false;
        }
        Object fqName2 = object;
        if (!Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.js.unsafeCast")) {
            return false;
        }
        Object object2 = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
        if (object2 == null || (object2 = object2.getTypeArguments()) == null || (object2 = (KtTypeProjection)CollectionsKt.singleOrNull((List)object2)) == null) {
            return false;
        }
        Object type2 = object2;
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)element3.getReceiverExpression().getText(), (String)"element.receiverExpression.text");
        Intrinsics.checkNotNullExpressionValue((Object)type2.getText(), (String)"type.text");
        this.setTextGetter(KotlinBundle.lazyMessage("convert.to.0.as.1", objectArray));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Object object = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
        if (object == null || (object = object.getTypeArguments()) == null || (object = (KtTypeProjection)CollectionsKt.singleOrNull((List)object)) == null) {
            return;
        }
        Object type2 = object;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        Object[] objectArray = new Object[2];
        objectArray[0] = element3.getReceiverExpression();
        Intrinsics.checkNotNullExpressionValue((Object)type2.getText(), (String)"type.text");
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 as $1", (Object[])objectArray, (boolean)false, (int)4, null);
        element3.replace((PsiElement)newExpression2);
    }
}

