/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceWithOrdinaryAssignmentIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceWithOrdinaryAssignmentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceWithOrdinaryAssignmentIntention.kt\norg/jetbrains/kotlin/idea/intentions/ReplaceWithOrdinaryAssignmentIntention\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,44:1\n110#2:45\n*S KotlinDebug\n*F\n+ 1 ReplaceWithOrdinaryAssignmentIntention.kt\norg/jetbrains/kotlin/idea/intentions/ReplaceWithOrdinaryAssignmentIntention\n*L\n25#1:45\n*E\n"})
public final class ReplaceWithOrdinaryAssignmentIntention
extends SelfTargetingIntention<KtBinaryExpression>
implements LowPriorityAction {
    public ReplaceWithOrdinaryAssignmentIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("replace.with.ordinary.assignment", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3, int caretOffset) {
        KtExpression left;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
        KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
        if (!operationReference.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (!KtTokens.AUGMENTED_ASSIGNMENTS.contains(element3.getOperationToken())) {
            return false;
        }
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            return false;
        }
        KtExpression $this$safeAs$iv = left = ktExpression;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression2 = $this$safeAs$iv;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        if ((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtQualifiedExpression) {
            return false;
        }
        if (element3.getRight() == null) {
            return false;
        }
        CallableDescriptor callableDescriptor = ResolutionUtils.resolveToCall((KtElement)operationReference, BodyResolveMode.PARTIAL);
        if (callableDescriptor == null || (callableDescriptor = callableDescriptor.getResultingDescriptor()) == null) {
            return false;
        }
        CallableDescriptor resultingDescriptor = callableDescriptor;
        return !OperatorNameConventions.ASSIGNMENT_OPERATIONS.contains(resultingDescriptor.getName());
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getLeft();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = element3.getRight();
        Intrinsics.checkNotNull((Object)ktExpression2);
        KtExpression right2 = ktExpression2;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        String assignOpText = element3.getOperationReference().getText();
        Intrinsics.checkNotNullExpressionValue((Object)assignOpText, (String)"assignOpText");
        boolean bl = StringsKt.endsWith$default((String)assignOpText, (String)"=", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = assignOpText.substring(0, assignOpText.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String operationText = string3;
        Object[] objectArray = new Object[]{left, right2};
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0 = $0 " + operationText + " $1"), (Object[])objectArray, (boolean)false, (int)4, null));
    }
}

