/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SplitIfIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFirstValidOperator", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getRight", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "condition", "commentSaver", "Lorg/jetbrains/kotlin/idea/util/CommentSaver;", "isApplicableTo", "", "caretOffset", "", "isOperatorValid", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSplitIfIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitIfIntention.kt\norg/jetbrains/kotlin/idea/intentions/SplitIfIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n146#2:121\n288#3,2:122\n*S KotlinDebug\n*F\n+ 1 SplitIfIntention.kt\norg/jetbrains/kotlin/idea/intentions/SplitIfIntention\n*L\n39#1:121\n93#1:122,2\n*E\n"})
public final class SplitIfIntention
extends SelfTargetingIntention<KtExpression> {
    public SplitIfIntention() {
        super(KtExpression.class, KotlinBundle.lazyMessage("split.if.into.two", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        return ktExpression instanceof KtOperationReferenceExpression ? this.isOperatorValid((KtOperationReferenceExpression)element3) : (ktExpression instanceof KtIfExpression ? this.getFirstValidOperator((KtIfExpression)element3) != null && ((KtIfExpression)element3).getIfKeyword().getTextRange().containsOffset(caretOffset) : false);
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor2) {
        KtIfExpression ktIfExpression;
        KtIfExpression ifExpression2;
        KtOperationReferenceExpression ktOperationReferenceExpression;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3 instanceof KtIfExpression) {
            KtOperationReferenceExpression ktOperationReferenceExpression2 = this.getFirstValidOperator((KtIfExpression)element3);
            ktOperationReferenceExpression = ktOperationReferenceExpression2;
            Intrinsics.checkNotNull((Object)ktOperationReferenceExpression2);
        } else {
            ktOperationReferenceExpression = (KtOperationReferenceExpression)element3;
        }
        KtOperationReferenceExpression operator = ktOperationReferenceExpression;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)operator;
        boolean $i$f$getNonStrictParentOfType = false;
        KtIfExpression ktIfExpression2 = ifExpression2 = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtIfExpression.class, (boolean)false);
        Intrinsics.checkNotNull((Object)ktIfExpression2);
        CommentSaver commentSaver = new CommentSaver((PsiElement)ktIfExpression2, false, 2, null);
        PsiElement psiElement2 = operator.getParent();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        KtBinaryExpression expression2 = (KtBinaryExpression)psiElement2;
        KtExpression ktExpression = ifExpression2.getCondition();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize((KtExpression)this.getRight(expression2, ktExpression, commentSaver));
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"safeDeparenthesize(getRi\u2026ndition!!, commentSaver))");
        KtExpression rightExpression = ktExpression2;
        KtExpression ktExpression3 = expression2.getLeft();
        Intrinsics.checkNotNull((Object)ktExpression3);
        KtExpression ktExpression4 = KtPsiUtil.safeDeparenthesize((KtExpression)ktExpression3);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"safeDeparenthesize(expression.left!!)");
        KtExpression leftExpression = ktExpression4;
        KtExpression ktExpression5 = ifExpression2.getThen();
        Intrinsics.checkNotNull((Object)ktExpression5);
        KtExpression thenBranch = ktExpression5;
        KtExpression elseBranch = ifExpression2.getElse();
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtIfExpression innerIf = psiFactory.createIf(rightExpression, thenBranch, elseBranch);
        IElementType iElementType = operator.getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            ktIfExpression = psiFactory.createIf(leftExpression, (KtExpression)KtPsiFactory.createSingleStatementBlock$default((KtPsiFactory)psiFactory, (KtExpression)((KtExpression)innerIf), null, null, (int)6, null), elseBranch);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            PsiElement container2 = ifExpression2.getParent();
            if (container2 instanceof KtBlockExpression && elseBranch == null && UtilsKt.isExitStatement(KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)thenBranch))) {
                PsiElement secondIf = container2.addAfter((PsiElement)innerIf, (PsiElement)ifExpression2);
                container2.addAfter(psiFactory.createNewLine(), (PsiElement)ifExpression2);
                PsiElement firstIf = ifExpression2.replace((PsiElement)KtPsiFactory.createIf$default((KtPsiFactory)psiFactory, (KtExpression)leftExpression, (KtExpression)thenBranch, null, (int)4, null));
                CommentSaver.restore$default(commentSaver, new PsiChildRange(firstIf, secondIf), false, false, false, 14, null);
                return;
            }
            ktIfExpression = psiFactory.createIf(leftExpression, thenBranch, (KtExpression)innerIf);
        } else {
            throw new IllegalArgumentException();
        }
        KtIfExpression newIf = ktIfExpression;
        PsiElement result2 = ifExpression2.replace((PsiElement)newIf);
        CommentSaver.restore$default(commentSaver, result2, false, 2, null);
    }

    private final KtExpression getRight(KtBinaryExpression element3, KtExpression condition2, CommentSaver commentSaver) {
        TextRange conditionRange = condition2.getTextRange();
        KtExpression ktExpression = element3.getRight();
        Intrinsics.checkNotNull((Object)ktExpression);
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression)) - conditionRange.getStartOffset();
        int endOffset2 = conditionRange.getLength();
        String string2 = condition2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"condition.text");
        String string3 = string2.substring(startOffset, endOffset2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String rightString = string3;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtExpression expression2 = new KtPsiFactory(project2, false, 2, null).createExpression(rightString);
        commentSaver.elementCreatedByText((PsiElement)expression2, (PsiElement)condition2, new TextRange(startOffset, endOffset2));
        return expression2;
    }

    private final KtOperationReferenceExpression getFirstValidOperator(KtIfExpression element3) {
        Object v2;
        block2: {
            KtExpression ktExpression = element3.getCondition();
            if (ktExpression == null) {
                return null;
            }
            KtExpression condition2 = ktExpression;
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)condition2), KtOperationReferenceExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(condi\u2026ceExpression::class.java)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtOperationReferenceExpression it = (KtOperationReferenceExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.isOperatorValid(it)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final boolean isOperatorValid(KtOperationReferenceExpression element3) {
        KtBinaryExpression expression2;
        block7: {
            KtBinaryExpression ktBinaryExpression;
            IElementType operator = element3.getReferencedNameElementType();
            if (!Intrinsics.areEqual((Object)operator, (Object)KtTokens.ANDAND) && !Intrinsics.areEqual((Object)operator, (Object)KtTokens.OROR)) {
                return false;
            }
            PsiElement psiElement2 = element3.getParent();
            KtBinaryExpression ktBinaryExpression2 = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression2 == null) {
                return false;
            }
            expression2 = ktBinaryExpression2;
            if (expression2.getRight() == null || expression2.getLeft() == null) {
                return false;
            }
            do {
                ktBinaryExpression = (psiElement2 = expression2.getParent()) instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
                if (ktBinaryExpression == null) break block7;
            } while (Intrinsics.areEqual((Object)(expression2 = ktBinaryExpression).getOperationToken(), (Object)operator));
            return false;
        }
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtContainerNode.class)};
        KtIfExpression ktIfExpression = (KtIfExpression)CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)((PsiElement)expression2)), kClassArray, Reflection.getOrCreateKotlinClass(KtIfExpression.class));
        if (ktIfExpression == null) {
            return false;
        }
        KtIfExpression ifExpression2 = ktIfExpression;
        if (ifExpression2.getCondition() == null) {
            return false;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ifExpression2.getCondition()), (PsiElement)((PsiElement)element3), (boolean)false)) {
            return false;
        }
        return ifExpression2.getThen() != null;
    }
}

