/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtReferenceShortenerMixIn;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenOption;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbolOrigin;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.AbstractKotlinApplicableIntentionWithContext;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ImportAllMembersIntentionKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u00020\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/AbstractKotlinApplicableIntentionWithContext;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "apply", "", "element", "context", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getActionName", "", "getApplicabilityRange", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicabilityRange;", "getFamilyName", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports", "starImportsToAdd", "", "Lorg/jetbrains/kotlin/name/FqName;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "Context", "kotlin.code-insight.intentions-k2"})
public final class ImportAllMembersIntention
extends AbstractKotlinApplicableIntentionWithContext<KtExpression, Context>
implements HighPriorityAction {
    public ImportAllMembersIntention() {
        super(Reflection.getOrCreateKotlinClass(KtExpression.class));
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("import.members.with", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionName(@NotNull KtExpression element3, @NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)context2.getFqName().asString(), (String)"context.fqName.asString()");
        return KotlinBundle.message("import.members.from.0", objectArray);
    }

    @Override
    @NotNull
    public KotlinApplicabilityRange<KtExpression> getApplicabilityRange() {
        return ApplicabilityRanges.INSTANCE.getSELF();
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return ImportAllMembersIntentionKt.access$isOnTheLeftOfQualificationDot(element3) && !KtPsiUtilKt.isInImportDirective((KtExpression)element3);
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KtAnalysisSession _context_receiver_0, @NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)_context_receiver_0, (String)"_context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtReference ktReference = ImportAllMembersIntentionKt.access$getActualReference(element3);
        KtSymbol ktSymbol = ktReference != null ? _context_receiver_0.resolveToSymbol(ktReference) : null;
        KtNamedClassOrObjectSymbol ktNamedClassOrObjectSymbol = ktSymbol instanceof KtNamedClassOrObjectSymbol ? (KtNamedClassOrObjectSymbol)ktSymbol : null;
        if (ktNamedClassOrObjectSymbol == null) {
            return null;
        }
        KtNamedClassOrObjectSymbol target2 = ktNamedClassOrObjectSymbol;
        ClassId classId = target2.getClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        if (target2.getOrigin() != KtSymbolOrigin.JAVA && (target2.getClassKind() == KtClassKind.OBJECT || ImportAllMembersIntentionKt.access$isReferenceToObjectMemberOrUnresolved(_context_receiver_0, element3))) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)element3);
        boolean bl = ktQualifiedExpression != null ? ImportAllMembersIntentionKt.access$isEnumSyntheticMethodCall(ktQualifiedExpression, target2) : false;
        if (bl) {
            return null;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        if (ImportAllMembersIntentionKt.access$hasImportedEnumSyntheticMethodCall(ktFile, _context_receiver_0)) {
            return null;
        }
        KtReferenceShortenerMixIn ktReferenceShortenerMixIn = _context_receiver_0;
        KtFile ktFile2 = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"element.containingKtFile");
        ShortenCommand shortenCommand2 = KtReferenceShortenerMixIn.collectPossibleReferenceShortenings$default(ktReferenceShortenerMixIn, ktFile2, null, (Function1)new Function1<KtClassLikeSymbol, ShortenOption>(classId2){
            final /* synthetic */ ClassId $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final ShortenOption invoke(@NotNull KtClassLikeSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClassId classId = it.getClassIdIfNonLocal();
                return (classId != null ? ImportAllMembersIntentionKt.access$isNestedClassIn(classId, this.$classId) : false) ? ShortenOption.SHORTEN_AND_STAR_IMPORT : ShortenOption.DO_NOT_SHORTEN;
            }
        }, (Function1)new Function1<KtCallableSymbol, ShortenOption>(target2, classId2){
            final /* synthetic */ KtNamedClassOrObjectSymbol $target;
            final /* synthetic */ ClassId $classId;
            {
                this.$target = $target;
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final ShortenOption invoke(@NotNull KtCallableSymbol it) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ImportAllMembersIntentionKt.access$isEnumSyntheticMethodCall(it, this.$target)) {
                    return ShortenOption.DO_NOT_SHORTEN;
                }
                if (it instanceof KtConstructorSymbol) {
                    ClassId classId = ((KtConstructorSymbol)it).getContainingClassIdIfNonLocal();
                    object = classId != null ? classId.getOuterClassId() : null;
                } else {
                    CallableId callableId = it.getCallableIdIfNonLocal();
                    object = callableId != null ? callableId.getClassId() : null;
                }
                ClassId containingClassId = object;
                return Intrinsics.areEqual((Object)containingClassId, (Object)this.$classId) ? ShortenOption.SHORTEN_AND_STAR_IMPORT : ShortenOption.DO_NOT_SHORTEN;
            }
        }, 2, null);
        if (shortenCommand2.isEmpty()) {
            return null;
        }
        FqName fqName2 = classId2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.asSingleFqName()");
        return new Context(fqName2, shortenCommand2);
    }

    @Override
    public void apply(@NotNull KtExpression element3, @NotNull Context context2, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ShortenCommand shortenCommand2 = context2.getShortenCommand();
        KtFile ktFile = (KtFile)shortenCommand2.getTargetFile().getElement();
        if (ktFile == null) {
            return;
        }
        KtFile file2 = ktFile;
        this.removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports(shortenCommand2.getStarImportsToAdd(), file2);
        ShortenUtilsKt.invokeShortening(shortenCommand2);
    }

    private final void removeExistingImportsWhichWillBecomeRedundantAfterAddingStarImports(List<FqName> starImportsToAdd, KtFile ktFile) {
        for (FqName starImportFqName : starImportsToAdd) {
            for (KtImportDirective existingImportFromFile : ktFile.getImportDirectives()) {
                ImportPath importPath;
                if (existingImportFromFile.getAlias() != null || !Intrinsics.areEqual((Object)((importPath = existingImportFromFile.getImportPath()) != null && (importPath = importPath.getFqName()) != null ? importPath.parent() : null), (Object)starImportFqName)) continue;
                existingImportFromFile.delete();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ImportAllMembersIntention$Context;", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "shortenCommand", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getShortenCommand", "()Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "kotlin.code-insight.intentions-k2"})
    public static final class Context {
        @NotNull
        private final FqName fqName;
        @NotNull
        private final ShortenCommand shortenCommand;

        public Context(@NotNull FqName fqName2, @NotNull ShortenCommand shortenCommand2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)shortenCommand2, (String)"shortenCommand");
            this.fqName = fqName2;
            this.shortenCommand = shortenCommand2;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final ShortenCommand getShortenCommand() {
            return this.shortenCommand;
        }
    }
}

