/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocElementFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createKDocFromText", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "text", "", "createNameFromText", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "kotlin.base.kdoc"})
@SourceDebugExtension(value={"SMAP\nKDocElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocElementFactory.kt\norg/jetbrains/kotlin/idea/kdoc/KDocElementFactory\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,28:1\n154#2:29\n*S KotlinDebug\n*F\n+ 1 KDocElementFactory.kt\norg/jetbrains/kotlin/idea/kdoc/KDocElementFactory\n*L\n26#1:29\n*E\n"})
public final class KDocElementFactory {
    @NotNull
    private final Project project;

    public KDocElementFactory(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final KDoc createKDocFromText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String fileText2 = text2 + " fun foo { }";
        KtFunction function2 = (KtFunction)new KtPsiFactory(this.project, false, 2, null).createDeclaration(fileText2);
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)function2), KDoc.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        return (KDoc)psiElement2;
    }

    @NotNull
    public final KDocName createNameFromText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String kdocText = "/** @param " + text2 + " foo*/";
        KDoc kdoc2 = this.createKDocFromText(kdocText);
        KDocSection section = kdoc2.getDefaultSection();
        KDocTag tag = section.findTagByName("param");
        KDocTag kDocTag = tag;
        if (kDocTag == null || (kDocTag = kDocTag.getSubjectLink()) == null) {
            throw new IllegalArgumentException("Cannot find subject link in doc comment '" + kdocText + "'");
        }
        KDocTag link2 = kDocTag;
        PsiElement $this$getChildOfType$iv = (PsiElement)link2;
        boolean $i$f$getChildOfType = false;
        PsiElement psiElement2 = PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KDocName.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        return (KDocName)psiElement2;
    }
}

