/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectConfiguration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.projectConfiguration.CommonStandardLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationUtils;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.WasmIdePlatformKind;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u001a$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f\u001a\u0016\u0010 \u001a\u0004\u0018\u00010\u0014*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006!"}, d2={"askUpdateRuntime", "", "module", "Lcom/intellij/openapi/module/Module;", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "project", "Lcom/intellij/openapi/project/Project;", "librariesToUpdate", "", "Lcom/intellij/openapi/roots/libraries/Library;", "checkUpdateRuntime", "findKotlinRuntimeLibrary", "getDefaultJvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "version", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getJvmStdlibArtifactId", "", "getLibraryDescription", "Lcom/intellij/openapi/roots/ui/configuration/libraries/CustomLibraryDescription;", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "hasJdkLikeUpdatedRuntime", "hasJreSpecificRuntime", "updateLibraries", "", "upToMavenVersion", "libraries", "", "toMavenArtifactVersion", "kotlin.project-configuration"})
@JvmName(name="KotlinProjectConfigurationUtils")
@SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationUtils.kt\norg/jetbrains/kotlin/idea/projectConfiguration/KotlinProjectConfigurationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,208:1\n1#2:209\n1#2:223\n3792#3:210\n4307#3,2:211\n12474#3,2:227\n1603#4,9:213\n1855#4:222\n1856#4:224\n1612#4:225\n76#5:226\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationUtils.kt\norg/jetbrains/kotlin/idea/projectConfiguration/KotlinProjectConfigurationUtils\n*L\n120#1:223\n114#1:210\n114#1:211,2\n178#1:227,2\n120#1:213,9\n120#1:222\n120#1:224\n120#1:225\n130#1:226\n*E\n"})
public final class KotlinProjectConfigurationUtils {
    @Nullable
    public static final CustomLibraryDescription getLibraryDescription(@NotNull Project project2, @NotNull IdePlatformKind platformKind) {
        CustomLibraryDescription customLibraryDescription;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)platformKind, (String)"platformKind");
        IdePlatformKind idePlatformKind = platformKind;
        if (Intrinsics.areEqual((Object)idePlatformKind, (Object)CommonIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new CommonStandardLibraryDescription(project2);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)JvmIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new JavaRuntimeLibraryDescription(project2);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)JsIdePlatformKind.INSTANCE)) {
            customLibraryDescription = new JSLibraryStdDescription(project2);
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)WasmIdePlatformKind.INSTANCE)) {
            customLibraryDescription = null;
        } else if (Intrinsics.areEqual((Object)idePlatformKind, (Object)NativeIdePlatformKind.INSTANCE)) {
            customLibraryDescription = null;
        } else {
            throw new IllegalArgumentException("Unsupported platform kind: " + platformKind);
        }
        return customLibraryDescription;
    }

    @NotNull
    public static final String getJvmStdlibArtifactId(@Nullable Sdk sdk2, @NotNull IdeKotlinVersion version2) {
        Sdk sdk3;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                if (!KotlinProjectConfigurationUtils.hasJreSpecificRuntime(version2)) {
                    return "kotlin-stdlib";
                }
                sdk3 = sdk2;
                if (sdk3 == null) break block5;
                Sdk it = sdk3;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(it);
                sdk3 = javaSdkVersion;
                if (javaSdkVersion != null) break block6;
            }
            return "kotlin-stdlib";
        }
        Sdk jdkVersion = sdk3;
        if (KotlinProjectConfigurationUtils.hasJdkLikeUpdatedRuntime(version2)) {
            return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? "kotlin-stdlib-jdk8" : (jdkVersion == JavaSdkVersion.JDK_1_7 ? "kotlin-stdlib-jdk7" : "kotlin-stdlib");
        }
        return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? "kotlin-stdlib-jre8" : (jdkVersion == JavaSdkVersion.JDK_1_7 ? "kotlin-stdlib-jre7" : "kotlin-stdlib");
    }

    @Nullable
    public static final JvmTarget getDefaultJvmTarget(@Nullable Sdk sdk2, @NotNull IdeKotlinVersion version2) {
        Sdk sdk3;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                if (!KotlinProjectConfigurationUtils.hasJreSpecificRuntime(version2)) {
                    return null;
                }
                sdk3 = sdk2;
                if (sdk3 == null) break block4;
                Sdk it = sdk3;
                boolean bl = false;
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(it);
                sdk3 = javaSdkVersion;
                if (javaSdkVersion != null) break block5;
            }
            return null;
        }
        Sdk jdkVersion = sdk3;
        return jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) ? JvmTarget.JVM_1_8 : (jdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6) ? JvmTarget.JVM_1_6 : null);
    }

    @ApiStatus.Internal
    public static final boolean hasJdkLikeUpdatedRuntime(@NotNull IdeKotlinVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return version2.compare("1.2.0-rc-39") >= 0 || version2.isSnapshot();
    }

    @ApiStatus.Internal
    public static final boolean hasJreSpecificRuntime(@NotNull IdeKotlinVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return version2.compare("1.1.0") >= 0 || version2.isSnapshot();
    }

    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        return ProjectStructureUtils.findLibrary(module2, (Function1<? super Library, Boolean>)((Function1)new Function1<Library, Boolean>(project3){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Library library2) {
                Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                return StdlibDetectorFacility.isStdlib$default(KotlinJvmStdlibDetectorFacility.INSTANCE, this.$project, library2, false, 4, null) || StdlibDetectorFacility.isStdlib$default(KotlinJavaScriptStdlibDetectorFacility.INSTANCE, this.$project, library2, false, 4, null);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkUpdateRuntime(@NotNull Project project2, @NotNull ApiVersion requiredVersion) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Module[] $this$filter$iv = ProjectUtil.getModules((Project)project2);
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void module2 = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module2);
            Object parsedModuleRuntimeVersion = ideKotlinVersion != null ? ideKotlinVersion.getApiVersion() : null;
            if (!(parsedModuleRuntimeVersion != null && parsedModuleRuntimeVersion.compareTo(requiredVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithOutdatedRuntime = (List)destination$iv$iv;
        if (!((Collection)modulesWithOutdatedRuntime).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = modulesWithOutdatedRuntime;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Library it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Module it = (Module)element$iv$iv;
                boolean bl2 = false;
                if (KotlinProjectConfigurationUtils.findKotlinRuntimeLibrary(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List librariesToUpdate2 = (List)destination$iv$iv2;
            if (!KotlinProjectConfigurationUtils.askUpdateRuntime(project2, requiredVersion, librariesToUpdate2)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Project project2, @NotNull ApiVersion requiredVersion, @NotNull List<? extends Library> librariesToUpdate2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Intrinsics.checkNotNullParameter(librariesToUpdate2, (String)"librariesToUpdate");
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] objectArray = new Object[]{requiredVersion};
            int rc = Messages.showOkCancelDialog((Project)project2, (String)KotlinProjectConfigurationBundle.message("this.language.feature.requires.version.0.or.later.of.the.kotlin.runtime.library.would.you.like.to.update.the.runtime.library.in.your.project", objectArray), (String)KotlinProjectConfigurationBundle.message("update.runtime.library", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return false;
            }
        }
        String string2 = KotlinProjectConfigurationUtils.toMavenArtifactVersion(requiredVersion, project2);
        if (string2 == null) {
            boolean bl = false;
            Messages.showErrorDialog((String)KotlinProjectConfigurationBundle.message("cant.fetch.available.maven.versions", new Object[0]), (String)KotlinProjectConfigurationBundle.message("cant.fetch.available.maven.versions.title", new Object[0]));
            return false;
        }
        String upToMavenVersion = string2;
        KotlinProjectConfigurationUtils.updateLibraries(project2, upToMavenVersion, (Collection<? extends Library>)librariesToUpdate2);
        return true;
    }

    private static final String toMavenArtifactVersion(ApiVersion $this$toMavenArtifactVersion, Project project2) {
        ApiVersion apiVersion2 = $this$toMavenArtifactVersion;
        Ref.ObjectRef mavenVersion = new Ref.ObjectRef();
        String string2 = KotlinProjectConfigurationBundle.message("fetching.available.maven.versions.title", new Object[0]);
        new Task.Modal(project2, apiVersion2, (Ref.ObjectRef<String>)mavenVersion, string2){
            final /* synthetic */ ApiVersion $apiVersion;
            final /* synthetic */ Ref.ObjectRef<String> $mavenVersion;
            {
                this.$apiVersion = $apiVersion;
                this.$mavenVersion = $mavenVersion;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Version version2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RepositoryLibraryProperties repositoryLibraryProperties = LibraryJarDescriptor.RUNTIME_JDK8_JAR.getRepositoryLibraryProperties();
                List list2 = new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath()).getAvailableVersions(repositoryLibraryProperties.getGroupId(), repositoryLibraryProperties.getArtifactId(), "[" + this.$apiVersion.getVersionString() + ",)", ArtifactKind.ARTIFACT);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ArtifactRepositoryManage\u2026nd.ARTIFACT\n            )");
                Version version3 = version2 = (Version)CollectionsKt.firstOrNull((List)list2);
                this.$mavenVersion.element = version3 != null ? version3.toString() : null;
            }
        }.queue();
        return (String)mavenVersion.element;
    }

    public static final boolean askUpdateRuntime(@NotNull Module module2, @NotNull ApiVersion requiredVersion) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Library library2 = KotlinProjectConfigurationUtils.findKotlinRuntimeLibrary(module2);
        if (library2 == null) {
            return true;
        }
        Library library3 = library2;
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return KotlinProjectConfigurationUtils.askUpdateRuntime(project2, requiredVersion, CollectionsKt.listOf((Object)library3));
    }

    public static final void updateLibraries(@NotNull Project project2, @NotNull String upToMavenVersion, @NotNull Collection<? extends Library> libraries) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)upToMavenVersion, (String)"upToMavenVersion");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            Module[] $this$any$iv = ProjectUtil.getModules((Project)project2);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                Module element$iv;
                Module module2 = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!(BuildSystemTypeKt.getBuildSystemType(module2) != BuildSystemType.JPS)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            String message2 = KotlinProjectConfigurationBundle.message("automatic.library.version.update.for.maven.and.gradle.projects.is.currently.unsupported.please.update.your.build.scripts.manually", new Object[0]);
            String title = KotlinProjectConfigurationBundle.message("update.kotlin.runtime.library", new Object[0]);
            Messages.showMessageDialog((Project)project2, (String)message2, (String)title, (Icon)Messages.getErrorIcon());
            return;
        }
        Sequence librariesToUpdate2 = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)libraries), (Function1)updateLibraries.librariesToUpdate.1.INSTANCE), (Function1)updateLibraries.librariesToUpdate.2.INSTANCE), (Function1)updateLibraries.librariesToUpdate.3.INSTANCE);
        for (Pair pair : librariesToUpdate2) {
            LibraryEx library2 = (LibraryEx)pair.component1();
            RepositoryLibraryProperties properties2 = (RepositoryLibraryProperties)pair.component2();
            ProjectStructureUtils.updateEx(library2, (Function1<? super LibraryEx.ModifiableModelEx, Unit>)((Function1)new Function1<LibraryEx.ModifiableModelEx, Unit>(properties2, upToMavenVersion, project2){
                final /* synthetic */ RepositoryLibraryProperties $properties;
                final /* synthetic */ String $upToMavenVersion;
                final /* synthetic */ Project $project;
                {
                    this.$properties = $properties;
                    this.$upToMavenVersion = $upToMavenVersion;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(@NotNull LibraryEx.ModifiableModelEx modifiableModel) {
                    Intrinsics.checkNotNullParameter((Object)modifiableModel, (String)"modifiableModel");
                    modifiableModel.setProperties((LibraryProperties)new RepositoryLibraryProperties(this.$properties.getGroupId(), this.$properties.getMavenId(), this.$upToMavenVersion));
                    Object[] objectArray = new OrderRootType[]{OrderRootType.SOURCES, OrderRootType.CLASSES, OrderRootType.DOCUMENTATION};
                    for (OrderRootType orderRootType : CollectionsKt.listOf((Object[])objectArray)) {
                        String[] stringArray = modifiableModel.getUrls(orderRootType);
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"modifiableModel.getUrls(orderRootType)");
                        Object[] $this$forEach$iv = stringArray;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            modifiableModel.removeRoot(it, orderRootType);
                        }
                    }
                    Collection collection = JarRepositoryManager.loadDependenciesModal((Project)this.$project, (RepositoryLibraryProperties)this.$properties, (boolean)true, (boolean)true, null, null);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"loadDependenciesModal(pr\u2026, true, true, null, null)");
                    Iterable $this$forEach$iv = collection;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        OrderRoot it = (OrderRoot)element$iv;
                        boolean bl = false;
                        modifiableModel.addRoot(it.getFile(), it.getType());
                    }
                }
            }));
        }
    }
}

