/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "kotlin.idea"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        super((PsiElement)annotationEntry2);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.annotation.target", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        ClassDescriptor annotationClassDescriptor;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        Pair pair = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry2);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KtClass annotationClass = (KtClass)pair2.component1();
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry2, annotationClass, annotationClassDescriptor = (ClassDescriptor)pair2.component2(), project2);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)annotationClass, false, true, (Function1)new Function1<KtDeclaration, Unit>(project2, (List<? extends KotlinTarget>)requiredAnnotationTargets){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<KotlinTarget> $requiredAnnotationTargets;
            {
                this.$project = $project;
                this.$requiredAnnotationTargets = $requiredAnnotationTargets;
                super(1);
            }

            public final void invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KtDeclaration $this$safeAs$iv = it;
                boolean $i$f$safeAs = false;
                KtDeclaration ktDeclaration = $this$safeAs$iv;
                if (!(ktDeclaration instanceof KtClass)) {
                    ktDeclaration = null;
                }
                KtClass ktClass2 = (KtClass)ktDeclaration;
                if (ktClass2 == null) {
                    return;
                }
                KtClass ktClass3 = ktClass2;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$project, ktClass3, this.$requiredAnnotationTargets){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ KtClass $ktClass;
                    final /* synthetic */ List<KotlinTarget> $requiredAnnotationTargets;
                    {
                        this.$project = $project;
                        this.$ktClass = $ktClass;
                        this.$requiredAnnotationTargets = $requiredAnnotationTargets;
                        super(0);
                    }

                    public final void invoke() {
                        KtPsiFactory psiFactory = new KtPsiFactory(this.$project, false, 2, null);
                        AddAnnotationTargetFixKt.access$addAnnotationTargets(this.$ktClass, this.$requiredAnnotationTargets, psiFactory);
                    }
                }));
            }
        }, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t*\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "toAnnotationClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        private final Pair<KtClass, ClassDescriptor> toAnnotationClass(KtAnnotationEntry $this$toAnnotationClass) {
            Object object;
            ClassDescriptor annotationTypeDescriptor;
            block6: {
                block5: {
                    KtClass ktClass2;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$toAnnotationClass, BodyResolveMode.PARTIAL);
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$toAnnotationClass);
                    if (annotationDescriptor == null) {
                        return null;
                    }
                    AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                    ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    annotationTypeDescriptor = classDescriptor;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)annotationTypeDescriptor));
                    object = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
                    if (object == null) break block5;
                    KtClass it = ktClass2 = object;
                    boolean bl = false;
                    object = it.isAnnotation() && it.isWritable() ? ktClass2 : null;
                    if (object != null) break block6;
                }
                return null;
            }
            KtClass annotationClass = object;
            return TuplesKt.to((Object)annotationClass, (Object)annotationTypeDescriptor);
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET) && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET)) {
                return null;
            }
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement2 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement2 : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            Pair<KtClass, ClassDescriptor> pair = this.toAnnotationClass(entry);
            if (pair == null) {
                return null;
            }
            Pair<KtClass, ClassDescriptor> pair2 = pair;
            KtClass annotationClass = (KtClass)pair2.component1();
            ClassDescriptor annotationClassDescriptor = (ClassDescriptor)pair2.component2();
            Project project2 = entry.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"entry.project");
            if (AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(entry, annotationClass, annotationClassDescriptor, project2).isEmpty()) {
                return null;
            }
            return new AddAnnotationTargetFix(entry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

