/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeserializedDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureHandler;", "()V", "findTargetMember", "Lcom/intellij/psi/PsiElement;", "element", "getTargetNotFoundMessage", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinChangeSignatureHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChangeSignatureHandler.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1#2:231\n*E\n"})
public final class KotlinChangeSignatureHandler
implements ChangeSignatureHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public PsiElement findTargetMember(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return Companion.findTargetForRefactoring(element3);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement psiElement2 = this.findTargetMember(file2, editor2);
        if (psiElement2 == null && (psiElement2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        PsiElement psiElement3 = file2.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement3 == null) {
            return;
        }
        PsiElement elementAtCaret = psiElement3;
        if (!(element3 instanceof KtElement)) {
            throw new KotlinExceptionWithAttachments("This handler must be invoked for Kotlin elements only: " + element3.getClass()).withAttachment("element", (Object)element3);
        }
        Companion.invokeChangeSignature((KtElement)element3, elementAtCaret, project2, editor2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement2 == null || (psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement2)) == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        if (!(element3 instanceof KtElement)) {
            throw new KotlinExceptionWithAttachments("This handler must be invoked for Kotlin elements only: " + element3.getClass()).withAttachment("element", (Object)element3);
        }
        DataContext dataContext2 = dataContext;
        if (dataContext2 != null) {
            DataContext it = dataContext2;
            boolean bl = false;
            editor2 = (Editor)CommonDataKeys.EDITOR.getData(it);
        } else {
            editor2 = null;
        }
        Editor editor3 = editor2;
        Companion.invokeChangeSignature((KtElement)element3, element3, project2, editor3);
    }

    @NotNull
    public String getTargetNotFoundMessage() {
        return KotlinBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler$Companion;", "", "()V", "findDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findTargetForRefactoring", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "invokeChangeSignature", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "context", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinChangeSignatureHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinChangeSignatureHandler.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n57#2,2:231\n57#2,2:233\n57#2,2:235\n57#2,2:237\n57#2,2:239\n1#3:241\n1747#4,3:242\n*S KotlinDebug\n*F\n+ 1 KotlinChangeSignatureHandler.kt\norg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureHandler$Companion\n*L\n75#1:231,2\n81#1:233,2\n85#1:235,2\n99#1:237,2\n102#1:239,2\n185#1:242,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiElement findTargetForRefactoring(@NotNull PsiElement element3) {
            KtCallElement calleeExpr;
            KtCallElement ktCallElement;
            KtCallElement call;
            block15: {
                block14: {
                    boolean $i$f$parentOfType;
                    boolean withSelf$iv;
                    Class[] $this$parentOfType_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    Class[] elementParent = element3.getParent();
                    if ((elementParent instanceof KtNamedFunction || elementParent instanceof KtClass || elementParent instanceof KtProperty) && ((KtNamedDeclaration)elementParent).getNameIdentifier() == element3) {
                        return elementParent;
                    }
                    if (elementParent instanceof KtParameter && ((KtParameter)elementParent).hasValOrVar()) {
                        $this$parentOfType_u24default$iv = elementParent;
                        withSelf$iv = false;
                        $i$f$parentOfType = false;
                        KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtPrimaryConstructor.class, (boolean)true);
                        if ((ktPrimaryConstructor != null ? ktPrimaryConstructor.getValueParameterList() : null) == ((KtParameter)elementParent).getParent()) {
                            return elementParent;
                        }
                    }
                    if (elementParent instanceof KtProperty && ((KtProperty)elementParent).getValOrVarKeyword() == element3) {
                        return elementParent;
                    }
                    if (elementParent instanceof KtConstructor && ((KtConstructor)elementParent).getConstructorKeyword() == element3) {
                        return elementParent;
                    }
                    $this$parentOfType_u24default$iv = element3;
                    withSelf$iv = false;
                    $i$f$parentOfType = false;
                    KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtParameterList.class, (boolean)true);
                    if (ktParameterList != null) {
                        KtParameterList parameterList2 = ktParameterList;
                        boolean bl = false;
                        Class[] classArray = new Class[]{KtFunction.class, KtProperty.class, KtClass.class};
                        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)parameterList2), (Class[])classArray);
                    }
                    $this$parentOfType_u24default$iv = element3;
                    withSelf$iv = false;
                    $i$f$parentOfType = false;
                    ktParameterList = (KtTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtTypeParameterList.class, (boolean)true);
                    if (ktParameterList != null) {
                        KtParameterList typeParameterList = ktParameterList;
                        boolean bl = false;
                        Class[] classArray = new Class[]{KtFunction.class, KtProperty.class, KtClass.class};
                        return PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)typeParameterList), (Class[])classArray);
                    }
                    $this$parentOfType_u24default$iv = new Class[]{KtCallExpression.class, KtSuperTypeCallEntry.class, KtConstructorDelegationCall.class};
                    call = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])$this$parentOfType_u24default$iv);
                    ktCallElement = call;
                    if (ktCallElement == null) break block14;
                    KtCallElement it = ktCallElement;
                    boolean bl = false;
                    KtExpression callee2 = it.getCalleeExpression();
                    KtConstructorCalleeExpression ktConstructorCalleeExpression = callee2 instanceof KtConstructorCalleeExpression ? (KtConstructorCalleeExpression)callee2 : null;
                    KtExpression ktExpression = ktConstructorCalleeExpression != null && (ktConstructorCalleeExpression = ktConstructorCalleeExpression.getConstructorReferenceExpression()) != null ? (KtExpression)ktConstructorCalleeExpression : callee2;
                    ktCallElement = ktExpression;
                    if (ktExpression != null) break block15;
                }
                PsiElement $this$parentOfType_u24default$iv = element3;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                ktCallElement = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtSimpleNameExpression.class, (boolean)true);
            }
            if ((calleeExpr = ktCallElement) instanceof KtSimpleNameExpression || calleeExpr instanceof KtConstructorDelegationReferenceExpression) {
                PsiElement $this$parentOfType_u24default$iv = element3;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtElement.class, (boolean)true);
                if (ktElement == null || (ktElement = ResolutionUtils.analyze(ktElement, BodyResolveMode.FULL)) == null) {
                    return null;
                }
                KtElement bindingContext2 = ktElement;
                KtCallElement ktCallElement2 = call;
                boolean bl = ktCallElement2 != null && (ktCallElement2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktCallElement2), (BindingContext)bindingContext2)) != null && (ktCallElement2 = ktCallElement2.getResultingDescriptor()) != null ? UtilsKt.isInvokeOperator((CallableDescriptor)ktCallElement2) : false;
                if (bl) {
                    return (PsiElement)call;
                }
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)((KtReferenceExpression)calleeExpr));
                if (descriptor2 instanceof ClassDescriptor || descriptor2 instanceof CallableDescriptor) {
                    return (PsiElement)calleeExpr;
                }
            }
            return null;
        }

        public final void invokeChangeSignature(@NotNull KtElement element3, @NotNull PsiElement context2, @NotNull Project project2, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            BindingContext bindingContext2 = ResolutionUtils.analyze(element3, BodyResolveMode.FULL);
            CallableDescriptor callableDescriptor = this.findDescriptor((PsiElement)element3, project2, editor2, bindingContext2);
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof DeserializedDescriptor) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)KotlinBundle.message("error.hint.library.declarations.cannot.be.changed", new Object[0]), (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
                return;
            }
            if (callableDescriptor2 instanceof JavaCallableMemberDescriptor) {
                PsiElement declaration2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)callableDescriptor2);
                if (declaration2 instanceof PsiClass) {
                    String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
                    return;
                }
                boolean bl = declaration2 instanceof PsiMethod;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "PsiMethod expected: " + callableDescriptor2;
                    throw new AssertionError((Object)string2);
                }
                Intrinsics.checkNotNull((Object)declaration2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                ChangeSignatureUtil.invokeChangeSignatureOn((PsiMethod)((PsiMethod)declaration2), (Project)project2);
                return;
            }
            if (DynamicCallsKt.isDynamic((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor2))) {
                if (editor2 != null) {
                    KotlinSurrounderUtils.showErrorHint(project2, editor2, KotlinBundle.message("message.change.signature.is.not.applicable.to.dynamically.invoked.functions", new Object[0]), RefactoringBundle.message((String)"changeSignature.refactoring.name"), null);
                }
                return;
            }
            KotlinChangeSignatureKt.runChangeSignature(project2, editor2, callableDescriptor2, KotlinChangeSignatureConfiguration.Empty.INSTANCE, context2, null);
        }

        private final DeclarationDescriptor getDescriptor(BindingContext bindingContext2, PsiElement element3) {
            DeclarationDescriptor declarationDescriptor;
            if (element3 instanceof KtParameter && ((KtParameter)element3).hasValOrVar()) {
                declarationDescriptor = (DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)element3);
            } else if (element3 instanceof KtReferenceExpression) {
                declarationDescriptor = (DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)element3);
            } else if (element3 instanceof KtCallExpression) {
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)bindingContext2);
                declarationDescriptor = (DeclarationDescriptor)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null);
            } else {
                declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element3);
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            return descriptor2 instanceof ClassDescriptor ? (DeclarationDescriptor)((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : descriptor2;
        }

        @Nullable
        public final CallableDescriptor findDescriptor(@NotNull PsiElement element3, @NotNull Project project2, @Nullable Editor editor2, @NotNull BindingContext bindingContext2) {
            CallableDescriptor callableDescriptor;
            DeclarationDescriptor declarationDescriptor;
            DeclarationDescriptor declarationDescriptor2;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element3)) {
                return null;
            }
            DeclarationDescriptor descriptor2 = this.getDescriptor(bindingContext2, element3);
            if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isActual() && (declarationDescriptor2 = ExpectActualUtilKt.expectedDescriptor((MemberDescriptor)descriptor2)) == null) {
                declarationDescriptor2 = descriptor2 = descriptor2;
            }
            if ((declarationDescriptor = descriptor2) instanceof PropertyDescriptor) {
                callableDescriptor = (CallableDescriptor)descriptor2;
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                String message2;
                boolean bl;
                block11: {
                    List list2 = ((FunctionDescriptor)descriptor2).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"descriptor.valueParameters");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!(it.getVarargElementType() != null)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    message2 = KotlinBundle.message("error.cant.refactor.vararg.functions", new Object[0]);
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
                    return null;
                }
                if (((FunctionDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)((FunctionDescriptor)descriptor2).getName(), (String)"descriptor.name");
                    message2 = KotlinBundle.message("cannot.refactor.synthesized.function", objectArray);
                    CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
                    return null;
                }
                callableDescriptor = (CallableDescriptor)descriptor2;
            } else {
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)KotlinBundle.message("error.wrong.caret.position.function.or.constructor.name", new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message3, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.changeSignature");
                callableDescriptor = null;
            }
            return callableDescriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

