/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.IncorrectOperationException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.statistics.KotlinMoveRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lcom/intellij/psi/PsiFileSystemItem;", "targetDirectoryName", "", "updatePackageDirective", "", "searchReferences", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;ZZLcom/intellij/refactoring/move/MoveCallback;)V", "getElementsToMove", "()Ljava/util/List;", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchReferences", "()Z", "getTargetDirectoryName", "()Ljava/lang/String;", "getUpdatePackageDirective", "checkModel", "", "checkedGetElementsToMove", "Lcom/intellij/psi/PsiElement;", "selectedDirectory", "Lcom/intellij/psi/PsiDirectory;", "checkedGetTargetDirectory", "computeModelResult", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/ModelResultWithFUSData;", "throwOnConflicts", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinAwareMoveFilesOrDirectoriesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAwareMoveFilesOrDirectoriesModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n819#2:121\n847#2,2:122\n1855#2,2:124\n288#2,2:126\n*S KotlinDebug\n*F\n+ 1 KotlinAwareMoveFilesOrDirectoriesModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/KotlinAwareMoveFilesOrDirectoriesModel\n*L\n38#1:121\n38#1:122,2\n49#1:124,2\n75#1:126,2\n*E\n"})
public final class KotlinAwareMoveFilesOrDirectoriesModel
implements Model {
    @NotNull
    private final Project project;
    @NotNull
    private final List<PsiFileSystemItem> elementsToMove;
    @NotNull
    private final String targetDirectoryName;
    private final boolean updatePackageDirective;
    private final boolean searchReferences;
    @Nullable
    private final MoveCallback moveCallback;

    public KotlinAwareMoveFilesOrDirectoriesModel(@NotNull Project project2, @NotNull List<? extends PsiFileSystemItem> elementsToMove, @NotNull String targetDirectoryName, boolean updatePackageDirective, boolean searchReferences2, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)targetDirectoryName, (String)"targetDirectoryName");
        this.project = project2;
        this.elementsToMove = elementsToMove;
        this.targetDirectoryName = targetDirectoryName;
        this.updatePackageDirective = updatePackageDirective;
        this.searchReferences = searchReferences2;
        this.moveCallback = moveCallback;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<PsiFileSystemItem> getElementsToMove() {
        return this.elementsToMove;
    }

    @NotNull
    public final String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public final boolean getUpdatePackageDirective() {
        return this.updatePackageDirective;
    }

    public final boolean getSearchReferences() {
        return this.searchReferences;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> checkedGetElementsToMove(PsiDirectory selectedDirectory) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.elementsToMove;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiFileSystemItem it = (PsiFileSystemItem)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiFile && Intrinsics.areEqual((Object)((PsiFile)it).getContainingDirectory(), (Object)selectedDirectory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List preparedElementsToMove = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), KotlinAwareMoveFilesOrDirectoriesModel::checkedGetElementsToMove$lambda$1);
        try {
            Iterable $this$forEach$iv = preparedElementsToMove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                boolean bl = false;
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)((PsiElement)it), (PsiElement)((PsiElement)selectedDirectory));
                if (!(it instanceof KtFile) || !KotlinRefactoringUtilKt.isInKotlinAwareSourceRoot((PsiElement)it)) continue;
                MoveUtilKt.setUpdatePackageDirective((KtFile)it, this.updatePackageDirective);
            }
        }
        catch (IncorrectOperationException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return preparedElementsToMove;
    }

    private final PsiDirectory checkedGetTargetDirectory() {
        try {
            return MoveUtilKt.getOrCreateDirectory(this.project, this.targetDirectoryName);
        }
        catch (IncorrectOperationException e) {
            Object[] objectArray = new Object[]{this.targetDirectoryName};
            throw new ConfigurationException(KotlinBundle.message("text.cannot.create.target.directory.0", objectArray));
        }
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    private final void checkModel() {
        Object v0;
        block6: {
            Iterable $this$firstOrNull$iv = this.elementsToMove;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiFileSystemItem it = (PsiFileSystemItem)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiFile) && !(it instanceof PsiDirectory))) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        PsiFileSystemItem psiFileSystemItem = v0;
        if (psiFileSystemItem != null) {
            PsiFileSystemItem it = psiFileSystemItem;
            boolean bl = false;
            Object[] objectArray = new Object[]{it};
            throw new ConfigurationException(KotlinBundle.message("text.unexpected.element.type.0", objectArray));
        }
        if (this.elementsToMove.isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message("text.no.files.to.move", new Object[0]));
        }
        try {
            Paths.get(this.targetDirectoryName, new String[0]);
        }
        catch (InvalidPathException e) {
            Object[] objectArray = new Object[]{this.targetDirectoryName};
            throw new ConfigurationException(KotlinBundle.message("text.invalid.target.path.0", objectArray));
        }
        if (DumbService.Companion.isDumb(this.project)) {
            throw new ConfigurationException(KotlinBundle.message("text.move.refactoring.not.available.during.indexing", new Object[0]));
        }
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        this.checkModel();
        PsiDirectory selectedDir = this.checkedGetTargetDirectory();
        List<PsiElement> elementsToMove = this.checkedGetElementsToMove(selectedDir);
        KotlinAwareMoveFilesOrDirectoriesProcessor processor2 = new KotlinAwareMoveFilesOrDirectoriesProcessor(this.project, elementsToMove, selectedDir, this.searchReferences, false, false, this.moveCallback, null, false, 384, null);
        return new ModelResultWithFUSData((BaseRefactoringProcessor)processor2, elementsToMove.size(), KotlinMoveRefactoringFUSCollector.MovedEntity.FILES, KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination.PACKAGE);
    }

    private static final int checkedGetElementsToMove$lambda$1(PsiFileSystemItem o1, PsiFileSystemItem o2) {
        return o1 instanceof KtElement && !(o2 instanceof KtElement) ? -1 : (!(o1 instanceof KtElement) && o2 instanceof KtElement ? 1 : 0);
    }
}

