/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "dispose", "", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getScratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runScratch", "scratchFile", "Companion", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nScratchFileAutoRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class ScratchFileAutoRunner
implements DocumentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm myAlarm;
    public static final int AUTO_RUN_DELAY_IN_SECONDS = 2;

    public ScratchFileAutoRunner(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        if (this.project.isDisposed()) {
            return;
        }
        ScratchFile scratchFile = this.getScratchFile(file2, this.project);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        if (!scratchFile2.getOptions().isInteractiveMode()) {
            return;
        }
        CharSequence charSequence2 = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"event.newFragment");
        if (!StringsKt.isBlank((CharSequence)charSequence2)) {
            this.runScratch(scratchFile2);
        }
    }

    private final void runScratch(ScratchFile scratchFile) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile) && !scratchFile.getOptions().isRepl()) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(() -> ScratchFileAutoRunner.runScratch$lambda$2(scratchFile), 2000, true);
    }

    private final ScratchFile getScratchFile(VirtualFile file2, Project project2) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2);
        TextEditor editor2 = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        TextEditor textEditor = editor2;
        return textEditor != null && (textEditor = KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview(textEditor)) != null ? textEditor.getScratchFile() : null;
    }

    public void dispose() {
    }

    private static final void runScratch$lambda$2(ScratchFile $scratchFile) {
        block3: {
            KtFile ktFile;
            Intrinsics.checkNotNullParameter((Object)$scratchFile, (String)"$scratchFile");
            Object object = $scratchFile.getKtScratchFile();
            if (object == null) break block3;
            KtFile it = ktFile = object;
            boolean bl = false;
            object = it.isValid() && !$scratchFile.hasErrors() ? ktFile : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                if ($scratchFile.getOptions().isRepl()) {
                    RunScratchFromHereAction.Handler.INSTANCE.doAction($scratchFile);
                } else {
                    RunScratchAction.Handler.INSTANCE.doAction($scratchFile, true);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion;", "", "()V", "AUTO_RUN_DELAY_IN_SECONDS", "", "addListener", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getInstance", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nScratchFileAutoRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n29#2,3:81\n*S KotlinDebug\n*F\n+ 1 ScratchFileAutoRunner.kt\norg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion\n*L\n32#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addListener(@NotNull Project project2, @NotNull TextEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (ScratchUtilsKt.getScratchFile(editor2) != null) {
                editor2.getEditor().getDocument().addDocumentListener((DocumentListener)this.getInstance(project2));
                Disposer.register((Disposable)((Disposable)editor2), () -> Companion.addListener$lambda$0(editor2, project2));
            }
        }

        private final ScratchFileAutoRunner getInstance(Project project2) {
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ScratchFileAutoRunner> serviceClass$iv = ScratchFileAutoRunner.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (ScratchFileAutoRunner)object;
        }

        private static final void addListener$lambda$0(TextEditor $editor, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            $editor.getEditor().getDocument().removeDocumentListener((DocumentListener)Companion.getInstance($project));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

