/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchAction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchFromHereAction;", "Lorg/jetbrains/kotlin/idea/scratch/actions/ScratchAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Handler", "kotlin.jvm"})
public final class RunScratchFromHereAction
extends ScratchAction {
    public RunScratchFromHereAction() {
        String string2 = KotlinJvmBundle.message("scratch.run.from.here.button", new Object[0]);
        Icon icon = AllIcons.Diff.ArrowRight;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ArrowRight");
        super(string2, icon);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ScratchFile scratchFile = this.getCurrentScratchFile(e);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        Handler.INSTANCE.doAction(scratchFile2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/actions/RunScratchFromHereAction$Handler;", "", "()V", "doAction", "", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "kotlin.jvm"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void doAction(@NotNull ScratchFile scratchFile) {
            Intrinsics.checkNotNullParameter((Object)scratchFile, (String)"scratchFile");
            SequentialScratchExecutor sequentialScratchExecutor = scratchFile.getReplScratchExecutor();
            if (sequentialScratchExecutor == null) {
                return;
            }
            SequentialScratchExecutor executor = sequentialScratchExecutor;
            try {
                executor.executeNew();
            }
            catch (Throwable ex) {
                executor.errorOccurs(KotlinJvmBundle.message("exception.occurred.during.run.scratch.action1", new Object[0]), ex, true);
            }
        }
    }
}

