/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.output.OutputStylingUtilsKt;
import org.jetbrains.kotlin.idea.scratch.output.PreviewEditorScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u00190\u0018J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u0015R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "blocks", "Ljava/util/NavigableMap;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "foldingModel", "Lcom/intellij/openapi/editor/FoldingModel;", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "targetDocument", "Lcom/intellij/openapi/editor/Document;", "addBlockToTheEnd", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "expression", "clear", "", "computeCellLineStart", "", "scratchExpression", "computeSourceToPreviewAlignments", "", "Lkotlin/Pair;", "getBlock", "getBlockAtLine", "line", "OutputBlock", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nPreviewEditorScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1549#2:217\n1620#2,3:218\n1#3:221\n*S KotlinDebug\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager\n*L\n84#1:217\n84#1:218,3\n*E\n"})
public final class PreviewOutputBlocksManager {
    @NotNull
    private final Document targetDocument;
    @NotNull
    private final FoldingModel foldingModel;
    @NotNull
    private final MarkupModel markupModel;
    @NotNull
    private final NavigableMap<ScratchExpression, OutputBlock> blocks;

    public PreviewOutputBlocksManager(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        this.targetDocument = document;
        FoldingModel foldingModel = editor2.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModel, (String)"editor.foldingModel");
        this.foldingModel = foldingModel;
        MarkupModel markupModel = editor2.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"editor.markupModel");
        this.markupModel = markupModel;
        this.blocks = new TreeMap(Comparator.comparingInt(arg_0 -> PreviewOutputBlocksManager.blocks$lambda$0(blocks.1.INSTANCE, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Integer, Integer>> computeSourceToPreviewAlignments() {
        void $this$mapTo$iv$iv;
        Collection collection = this.blocks.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputBlock outputBlock = (OutputBlock)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)it.getSourceExpression().getLineStart(), (Object)it.getLineStart()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ScratchOutputBlock getBlock(@NotNull ScratchExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (ScratchOutputBlock)this.blocks.get(expression2);
    }

    @NotNull
    public final ScratchOutputBlock addBlockToTheEnd(@NotNull ScratchExpression expression2) {
        OutputBlock outputBlock;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        OutputBlock it = outputBlock = new OutputBlock(expression2);
        boolean bl = false;
        if (this.blocks.putIfAbsent(expression2, it) != null) {
            throw new IllegalStateException(("There is already a cell for " + expression2 + "!").toString());
        }
        return outputBlock;
    }

    public final void clear() {
        this.blocks.clear();
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ PreviewOutputBlocksManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                PreviewOutputBlocksManager previewOutputBlocksManager = this.this$0;
                Project project$iv = null;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(previewOutputBlocksManager){
                    final /* synthetic */ PreviewOutputBlocksManager this$0;
                    {
                        this.this$0 = previewOutputBlocksManager;
                    }

                    public final void run() {
                        boolean bl = false;
                        PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0).setText((CharSequence)"");
                    }
                }, name$iv, groupId$iv);
            }
        }));
    }

    private final int computeCellLineStart(ScratchExpression scratchExpression) {
        Map.Entry<ScratchExpression, OutputBlock> entry = this.blocks.lowerEntry(scratchExpression);
        OutputBlock outputBlock = entry != null ? entry.getValue() : null;
        if (outputBlock == null) {
            return scratchExpression.getLineStart();
        }
        OutputBlock previous = outputBlock;
        int distanceBetweenSources = scratchExpression.getLineStart() - previous.getSourceExpression().getLineEnd();
        int differenceBetweenSourceAndOutputHeight = PreviewEditorScratchOutputHandlerKt.access$getHeight(previous.getSourceExpression()) - previous.getHeight();
        int compensation = Math.max(differenceBetweenSourceAndOutputHeight, 0);
        return previous.getLineEnd() + compensation + distanceBetweenSources;
    }

    @Nullable
    public final ScratchOutputBlock getBlockAtLine(int line) {
        Object v2;
        block1: {
            Collection collection = this.blocks.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.values");
            Iterable iterable = collection;
            for (Object t : iterable) {
                OutputBlock it = (OutputBlock)t;
                boolean bl = false;
                int n = it.getLineStart();
                boolean bl2 = line <= it.getLineEnd() ? n <= line : false;
                if (!bl2) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final int blocks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputBlock;", "sourceExpression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "(Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;)V", "foldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "height", "", "getHeight", "()I", "isLastCell", "", "()Z", "isOutputSmall", "lineEnd", "getLineEnd", "<set-?>", "lineStart", "getLineStart", "outputs", "", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "getSourceExpression", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "addOutput", "", "output", "printAndSaveOutput", "recalculatePosition", "updateFolding", "kotlin.jvm"})
    @SourceDebugExtension(value={"SMAP\nPreviewEditorScratchOutputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1855#2,2:217\n1#3:219\n*S KotlinDebug\n*F\n+ 1 PreviewEditorScratchOutputHandler.kt\norg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager$OutputBlock\n*L\n118#1:217,2\n*E\n"})
    private final class OutputBlock
    implements ScratchOutputBlock {
        @NotNull
        private final ScratchExpression sourceExpression;
        @NotNull
        private final List<ScratchOutput> outputs;
        private int lineStart;
        @Nullable
        private FoldRegion foldRegion;

        public OutputBlock(ScratchExpression sourceExpression) {
            Intrinsics.checkNotNullParameter((Object)sourceExpression, (String)"sourceExpression");
            this.sourceExpression = sourceExpression;
            this.outputs = new ArrayList();
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        @Override
        @NotNull
        public ScratchExpression getSourceExpression() {
            return this.sourceExpression;
        }

        @Override
        public int getLineStart() {
            return this.lineStart;
        }

        @Override
        public int getLineEnd() {
            return this.getLineStart() + PreviewEditorScratchOutputHandlerKt.access$countNewLines(this.outputs);
        }

        public final int getHeight() {
            return this.getLineEnd() - this.getLineStart() + 1;
        }

        @Override
        public void addOutput(@NotNull ScratchOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.printAndSaveOutput(output);
            Map.Entry entry = PreviewOutputBlocksManager.this.blocks.lowerEntry(this.getSourceExpression());
            if (entry != null && (entry = (OutputBlock)entry.getValue()) != null) {
                super.updateFolding();
            }
            Collection collection = PreviewOutputBlocksManager.this.blocks.tailMap(this.getSourceExpression()).values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"blocks.tailMap(sourceExpression).values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutputBlock it = (OutputBlock)element$iv;
                boolean bl = false;
                it.recalculatePosition();
                it.updateFolding();
            }
        }

        private final void printAndSaveOutput(ScratchOutput output) {
            int beforeAdding = this.getLineEnd();
            int currentOutputStartLine = this.outputs.isEmpty() ? this.getLineStart() : beforeAdding + 1;
            this.outputs.add(output);
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(PreviewOutputBlocksManager.this, currentOutputStartLine, output){
                final /* synthetic */ PreviewOutputBlocksManager this$0;
                final /* synthetic */ int $currentOutputStartLine;
                final /* synthetic */ ScratchOutput $output;
                {
                    this.this$0 = $receiver;
                    this.$currentOutputStartLine = $currentOutputStartLine;
                    this.$output = $output;
                    super(0);
                }

                public final void invoke() {
                    PreviewOutputBlocksManager previewOutputBlocksManager = this.this$0;
                    int n = this.$currentOutputStartLine;
                    ScratchOutput scratchOutput = this.$output;
                    Project project$iv = null;
                    String name$iv = null;
                    Object groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(previewOutputBlocksManager, n, scratchOutput){
                        final /* synthetic */ PreviewOutputBlocksManager this$0;
                        final /* synthetic */ int $currentOutputStartLine$inlined;
                        final /* synthetic */ ScratchOutput $output$inlined;
                        {
                            this.this$0 = previewOutputBlocksManager;
                            this.$currentOutputStartLine$inlined = n;
                            this.$output$inlined = scratchOutput;
                        }

                        public final void run() {
                            boolean bl = false;
                            PreviewEditorScratchOutputHandlerKt.access$insertStringAtLine(PreviewOutputBlocksManager.access$getTargetDocument$p(this.this$0), this.$currentOutputStartLine$inlined, this.$output$inlined.getText());
                        }
                    }, name$iv, groupId$iv);
                }
            }));
            PreviewEditorScratchOutputHandlerKt.highlightLines$default(PreviewOutputBlocksManager.this.markupModel, currentOutputStartLine, this.getLineEnd(), OutputStylingUtilsKt.getAttributesForOutputType(output.getType()), null, 8, null);
        }

        private final void recalculatePosition() {
            this.lineStart = PreviewOutputBlocksManager.this.computeCellLineStart(this.getSourceExpression());
        }

        private final void updateFolding() {
            PreviewOutputBlocksManager.this.foldingModel.runBatchFoldingOperation(() -> OutputBlock.updateFolding$lambda$1(this, PreviewOutputBlocksManager.this));
        }

        private final boolean isLastCell() {
            return false;
        }

        private final boolean isOutputSmall() {
            return true;
        }

        private static final void updateFolding$lambda$1(OutputBlock this$0, PreviewOutputBlocksManager this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            FoldRegion foldRegion = this$0.foldRegion;
            if (foldRegion != null) {
                FoldRegion foldRegion2 = foldRegion;
                FoldingModel foldingModel = this$1.foldingModel;
                FoldRegion p0 = foldRegion2;
                boolean bl = false;
                foldingModel.removeFoldRegion(p0);
            }
            if (this$0.getHeight() <= PreviewEditorScratchOutputHandlerKt.access$getHeight(this$0.getSourceExpression())) {
                return;
            }
            int firstFoldedLine = this$0.getLineStart() + (PreviewEditorScratchOutputHandlerKt.access$getHeight(this$0.getSourceExpression()) - 1);
            String placeholderLine = PreviewEditorScratchOutputHandlerKt.access$getLineContent(this$1.targetDocument, firstFoldedLine) + "...";
            FoldRegion foldRegion3 = this$0.foldRegion = this$1.foldingModel.addFoldRegion(this$1.targetDocument.getLineStartOffset(firstFoldedLine), this$1.targetDocument.getLineEndOffset(this$0.getLineEnd()), placeholderLine);
            if (foldRegion3 != null) {
                foldRegion3.setExpanded(this$0.isLastCell() && this$0.isOutputSmall());
            }
        }
    }
}

