/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.ImpreciseResolveResult;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.PsiBasedClassResolver;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasShortNameIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0002$%B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J,\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\"\u001a\u00020\u0015*\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "", "target", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "targetClassFqName", "", "(Ljava/lang/String;)V", "conflictingPackages", "", "forceAmbiguity", "", "forceAmbiguityForInnerAnnotations", "forceAmbiguityForNonAnnotations", "packagesWithTypeAliases", "targetPackage", "targetShortName", "addConflict", "", "fqName", "analyzeSingleImport", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "result", "importedFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isAllUnder", "aliasName", "canBeTargetReference", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "ref", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkQualifiedReferenceToTarget", "findPotentialClassConflicts", "findPotentialTypeAliasConflicts", "changeTo", "newResult", "Companion", "Result", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPsiBasedClassResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,252:1\n142#2:253\n193#2,2:254\n125#2:256\n125#2:257\n110#3:258\n*S KotlinDebug\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver\n*L\n151#1:253\n152#1:254,2\n152#1:256\n156#1:257\n222#1:258\n*E\n"})
public final class PsiBasedClassResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String targetClassFqName;
    @NotNull
    private final String targetShortName;
    @NotNull
    private final String targetPackage;
    @NotNull
    private final List<String> conflictingPackages;
    @NotNull
    private final List<String> packagesWithTypeAliases;
    private boolean forceAmbiguity;
    private boolean forceAmbiguityForInnerAnnotations;
    private boolean forceAmbiguityForNonAnnotations;
    @NotNull
    private static final AtomicInteger attempts = new AtomicInteger();
    @NotNull
    private static final AtomicInteger trueHits = new AtomicInteger();
    @NotNull
    private static final AtomicInteger falseHits = new AtomicInteger();
    @NotNull
    private static final Key<CachedValue<PsiBasedClassResolver>> PSI_BASED_CLASS_RESOLVER_KEY = new Key("PsiBasedClassResolver");

    @TestOnly
    public PsiBasedClassResolver(@NotNull String targetClassFqName) {
        Intrinsics.checkNotNullParameter((Object)targetClassFqName, (String)"targetClassFqName");
        this.targetClassFqName = targetClassFqName;
        this.targetShortName = StringsKt.substringAfterLast$default((String)this.targetClassFqName, (char)'.', null, (int)2, null);
        this.targetPackage = StringsKt.substringBeforeLast((String)this.targetClassFqName, (char)'.', (String)"");
        this.conflictingPackages = new ArrayList();
        this.packagesWithTypeAliases = new ArrayList();
    }

    private PsiBasedClassResolver(final PsiClass target2) {
        String string2 = target2.getQualifiedName();
        if (string2 == null) {
            string2 = "";
        }
        this(string2);
        if (target2.getQualifiedName() == null || target2.getContainingClass() != null || ((CharSequence)this.targetPackage).length() == 0) {
            this.forceAmbiguity = true;
            return;
        }
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.findPotentialClassConflicts(target2);
                this.findPotentialTypeAliasConflicts(target2);
            }
        }));
    }

    private final void findPotentialClassConflicts(PsiClass target2) {
        PsiShortNamesCache psiShortNamesCache = PsiShortNamesCache.getInstance((Project)target2.getProject());
        Project project2 = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"target.project");
        PsiClass[] psiClassArray = psiShortNamesCache.getClassesByName(this.targetShortName, KotlinScopeUtils.allScope(project2));
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getInstance(target.proje\u2026arget.project.allScope())");
        for (PsiClass candidate2 : psiClassArray) {
            if (candidate2.getContainingClass() != null && !candidate2.hasModifierProperty("private")) {
                if (candidate2.isAnnotationType()) {
                    this.forceAmbiguityForInnerAnnotations = true;
                    break;
                }
                this.forceAmbiguityForNonAnnotations = true;
                break;
            }
            if (Intrinsics.areEqual((Object)candidate2.getQualifiedName(), (Object)target2.getQualifiedName())) {
                if (candidate2 == target2 || Intrinsics.areEqual((Object)candidate2.getNavigationElement().getContainingFile(), (Object)target2.getNavigationElement().getContainingFile())) continue;
                this.forceAmbiguity = true;
                break;
            }
            String string2 = candidate2.getQualifiedName();
            if (string2 == null || (string2 = StringsKt.substringBeforeLast((String)string2, (char)'.', (String)"")) == null) continue;
            String candidatePackage = string2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)candidatePackage, (Object)"")) {
                this.forceAmbiguity = true;
                continue;
            }
            this.conflictingPackages.add(candidatePackage);
        }
    }

    private final void findPotentialTypeAliasConflicts(PsiClass target2) {
        Project project2 = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"target.project");
        Project project3 = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"target.project");
        Collection candidates2 = KotlinTypeAliasShortNameIndex.Helper.get(this.targetShortName, project2, KotlinScopeUtils.allScope(project3));
        for (KtTypeAlias candidate2 : candidates2) {
            String string2 = candidate2.getContainingKtFile().getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"candidate.containingKtFi\u2026.packageFqName.asString()");
            this.packagesWithTypeAliases.add(string2);
        }
    }

    @TestOnly
    public final void addConflict(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.conflictingPackages.add(StringsKt.substringBeforeLast$default((String)fqName2, (char)'.', null, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ImpreciseResolveResult canBeTargetReference(@NotNull KtSimpleNameExpression ref) {
        Result qualifiedCheckResult;
        KtDeclaration declaration2;
        void $this$getParentOfTypeAndBranch_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        attempts.incrementAndGet();
        if (!Intrinsics.areEqual((Object)ref.getReferencedName(), (Object)this.targetShortName)) {
            return ImpreciseResolveResult.UNSURE;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)ref;
        boolean $i$f$getStrictParentOfType = false;
        KtUserType ktUserType2 = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtUserType.class, (boolean)true);
        if (ktUserType2 == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtUserType userType2 = ktUserType2;
        $this$getStrictParentOfType$iv = (PsiElement)userType2;
        Function1 branch$iv = canBeTargetReference.parentAnnotation.1.INSTANCE;
        boolean strict$iv2 = false;
        boolean $i$f$getParentOfTypeAndBranch = false;
        void $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch_u24default$iv;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)strict$iv2);
        KtAnnotationEntry parentAnnotation2 = (KtAnnotationEntry)(psiElement2 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement2, (PsiElement)$this$getParentOfTypeAndBranch_u24default$iv, (Function1)branch$iv) : null);
        if (this.forceAmbiguityForNonAnnotations && parentAnnotation2 == null) {
            return ImpreciseResolveResult.UNSURE;
        }
        KtAnnotationEntry ktAnnotationEntry = parentAnnotation2;
        if (ktAnnotationEntry != null) {
            void $this$getParentOfType$iv;
            PsiElement strict$iv2 = (PsiElement)ktAnnotationEntry;
            boolean strict$iv3 = true;
            boolean $i$f$getParentOfType2 = false;
            v3 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv3);
        } else {
            v3 = declaration2 = null;
        }
        if (this.forceAmbiguityForInnerAnnotations) {
            KtDeclaration ktDeclaration = declaration2;
            if (!((ktDeclaration != null ? ktDeclaration.getParent() : null) instanceof KtFile)) {
                return ImpreciseResolveResult.UNSURE;
            }
        }
        if (this.forceAmbiguity) {
            return ImpreciseResolveResult.UNSURE;
        }
        Result result2 = qualifiedCheckResult = this.checkQualifiedReferenceToTarget(ref);
        if (result2 != null) {
            return result2.getReturnValue();
        }
        KtFile ktFile = ref.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ref.containingKtFile");
        KtFile file2 = ktFile;
        Result result3 = Result.NothingFound;
        Iterator iterator2 = file2.getPackageFqName().asString();
        if (Intrinsics.areEqual((Object)iterator2, (Object)this.targetPackage)) {
            result3 = this.changeTo(result3, Result.Found);
        } else if (this.conflictingPackages.contains(iterator2)) {
            result3 = this.changeTo(result3, Result.FoundOther);
        } else if (this.packagesWithTypeAliases.contains(iterator2)) {
            return ImpreciseResolveResult.UNSURE;
        }
        for (ImportPath importPath : KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getDefaultImports(file2)) {
            Name name2 = importPath.getAlias();
            if ((result3 = this.analyzeSingleImport(result3, importPath.getFqName(), importPath.isAllUnder(), name2 != null ? name2.asString() : null)) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        for (KtImportDirective importDirective2 : file2.getImportDirectives()) {
            if ((result3 = this.analyzeSingleImport(result3, importDirective2.getImportedFqName(), importDirective2.isAllUnder(), importDirective2.getAliasName())) != Result.Ambiguity) continue;
            return ImpreciseResolveResult.UNSURE;
        }
        if (result3.getReturnValue() == ImpreciseResolveResult.MATCH) {
            trueHits.incrementAndGet();
        } else if (result3.getReturnValue() == ImpreciseResolveResult.NO_MATCH) {
            falseHits.incrementAndGet();
        }
        return result3.getReturnValue();
    }

    private final Result analyzeSingleImport(Result result2, FqName importedFqName, boolean isAllUnder, String aliasName) {
        if (!isAllUnder) {
            FqName fqName2 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)this.targetClassFqName) && (aliasName == null || Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName))) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName3 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName3 != null && (fqName3 = fqName3.shortName()) != null ? fqName3.asString() : null), (Object)this.targetShortName) && this.conflictingPackages.contains(importedFqName.parent().asString()) && aliasName == null) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName4 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName4 != null && (fqName4 = fqName4.shortName()) != null ? fqName4.asString() : null), (Object)this.targetShortName) && this.packagesWithTypeAliases.contains(importedFqName.parent().asString()) && aliasName == null) {
                return Result.Ambiguity;
            }
            if (Intrinsics.areEqual((Object)aliasName, (Object)this.targetShortName)) {
                return this.changeTo(result2, Result.FoundOther);
            }
        } else {
            FqName fqName5 = importedFqName;
            if (Intrinsics.areEqual((Object)(fqName5 != null ? fqName5.asString() : null), (Object)this.targetPackage)) {
                return this.changeTo(result2, Result.Found);
            }
            FqName fqName6 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.conflictingPackages, (Object)(fqName6 != null ? fqName6.asString() : null))) {
                return this.changeTo(result2, Result.FoundOther);
            }
            FqName fqName7 = importedFqName;
            if (CollectionsKt.contains((Iterable)this.packagesWithTypeAliases, (Object)(fqName7 != null ? fqName7.asString() : null))) {
                return Result.Ambiguity;
            }
        }
        return result2;
    }

    private final Result checkQualifiedReferenceToTarget(KtSimpleNameExpression ref) {
        KtUserType ktUserType2;
        KtUserType ktUserType3;
        PsiElement $this$safeAs$iv = ref.getParent();
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtUserType)) {
            psiElement2 = null;
        }
        if ((ktUserType3 = (KtUserType)psiElement2) != null && (ktUserType2 = ktUserType3.getQualifier()) != null) {
            KtUserType qualifier2 = ktUserType2;
            boolean bl = false;
            String fqName2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(qualifier2, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ KtUserType $qualifier;
                {
                    this.$qualifier = $qualifier;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            q = this.$qualifier;
lbl7:
                            // 2 sources

                            while (true) {
                                v0 = q;
                                if ((v0 != null ? v0.getReferencedName() : null) == null || (v1 /* !! */  = q) == null || (v1 /* !! */  = v1 /* !! */ .getReferencedName()) == null) break block0;
                                this.L$0 = $this$sequence;
                                this.L$1 = q;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)v1 /* !! */ , (Continuation)this);
                                if (v2 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl22
                                break;
                            }
                        }
                        case 1: {
                            q = (KtUserType)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl22:
                            // 2 sources

                            v3 = var3_4;
                            var3_4 = v3 != null ? v3.getQualifier() : null;
                            ** continue;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })))), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            return Intrinsics.areEqual((Object)fqName2, (Object)this.targetPackage) ? Result.Ambiguity : Result.FoundOther;
        }
        return null;
    }

    private final Result changeTo(Result $this$changeTo, Result newResult) {
        if ($this$changeTo == Result.NothingFound || $this$changeTo.getReturnValue() == newResult.getReturnValue()) {
            return newResult;
        }
        return Result.Ambiguity;
    }

    public /* synthetic */ PsiBasedClassResolver(PsiClass target2, DefaultConstructorMarker $constructor_marker) {
        this(target2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion;", "", "()V", "PSI_BASED_CLASS_RESOLVER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver;", "attempts", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAttempts", "()Ljava/util/concurrent/atomic/AtomicInteger;", "falseHits", "getFalseHits", "trueHits", "getTrueHits", "getInstance", "target", "Lcom/intellij/psi/PsiClass;", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPsiBasedClassResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiBasedClassResolver.kt\norg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getAttempts() {
            return attempts;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getTrueHits() {
            return trueHits;
        }

        @TestOnly
        @NotNull
        public final AtomicInteger getFalseHits() {
            return falseHits;
        }

        @NotNull
        public final PsiBasedClassResolver getInstance(@NotNull PsiClass target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            CachedValue cachedValue2 = (CachedValue)target2.getUserData(PSI_BASED_CLASS_RESOLVER_KEY);
            if (cachedValue2 != null) {
                CachedValue it = cachedValue2;
                boolean bl = false;
                Object object = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value");
                return (PsiBasedClassResolver)object;
            }
            CachedValue cachedValue3 = CachedValuesManager.getManager((Project)target2.getProject()).createCachedValue(() -> Companion.getInstance$lambda$1(target2), false);
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue3, (String)"getManager(target.projec\u2026   }, false\n            )");
            CachedValue cachedValue4 = cachedValue3;
            target2.putUserData(PSI_BASED_CLASS_RESOLVER_KEY, (Object)cachedValue4);
            Object object = cachedValue4.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cachedValue.value");
            return (PsiBasedClassResolver)object;
        }

        private static final CachedValueProvider.Result getInstance$lambda$1(PsiClass $target) {
            Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
            PsiBasedClassResolver psiBasedClassResolver = new PsiBasedClassResolver($target, null);
            Object[] objectArray = new Object[1];
            Project project2 = $target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"target.project");
            objectArray[0] = KotlinCodeBlockModificationListener.Companion.getInstance(project2).getKotlinOutOfCodeBlockTracker();
            return new CachedValueProvider.Result((Object)psiBasedClassResolver, objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/PsiBasedClassResolver$Result;", "", "returnValue", "Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "(Ljava/lang/String;ILorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;)V", "getReturnValue", "()Lorg/jetbrains/kotlin/asJava/ImpreciseResolveResult;", "NothingFound", "Found", "FoundOther", "Ambiguity", "kotlin.base.analysis"})
    public static final class Result
    extends Enum<Result> {
        @NotNull
        private final ImpreciseResolveResult returnValue;
        public static final /* enum */ Result NothingFound = new Result(ImpreciseResolveResult.NO_MATCH);
        public static final /* enum */ Result Found = new Result(ImpreciseResolveResult.MATCH);
        public static final /* enum */ Result FoundOther = new Result(ImpreciseResolveResult.NO_MATCH);
        public static final /* enum */ Result Ambiguity = new Result(ImpreciseResolveResult.UNSURE);
        private static final /* synthetic */ Result[] $VALUES;

        private Result(ImpreciseResolveResult returnValue) {
            this.returnValue = returnValue;
        }

        @NotNull
        public final ImpreciseResolveResult getReturnValue() {
            return this.returnValue;
        }

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value2) {
            return Enum.valueOf(Result.class, value2);
        }

        static {
            $VALUES = resultArray = new Result[]{Result.NothingFound, Result.Found, Result.FoundOther, Result.Ambiguity};
        }
    }
}

