/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.IndexId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J*\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/KotlinNonSourceRootIndexFilter;", "Lcom/intellij/util/indexing/GlobalIndexFilter;", "()V", "enabled", "", "affectsIndex", "indexId", "Lcom/intellij/util/indexing/IndexId;", "getVersion", "", "isExcludedFromIndex", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
public final class KotlinNonSourceRootIndexFilter
implements GlobalIndexFilter {
    private final boolean enabled = !Boolean.parseBoolean(System.getProperty("kotlin.index.non.source.roots", "false"));

    public boolean isExcludedFromIndex(@NotNull VirtualFile virtualFile2, @NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExcludedFromIndex(@NotNull VirtualFile virtualFile2, @NotNull IndexId<?, ?> indexId, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        if (project2 == null) return false;
        if (virtualFile2.isDirectory()) return false;
        if (!this.affectsIndex(indexId)) return false;
        CharSequence charSequence2 = virtualFile2.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"virtualFile.nameSequence");
        if (!StringsKt.endsWith$default((CharSequence)charSequence2, (CharSequence)".kt", (boolean)false, (int)2, null)) return false;
        if ((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project2, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return !ProjectFileIndex.getInstance((Project)this.$project).isInSource(this.$virtualFile);
            }
        })) == false) return false;
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public boolean affectsIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return this.enabled && indexId != TrigramIndex.INDEX_ID && indexId != FilenameIndex.NAME;
    }
}

