/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.formatting.ASTBlock;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\u0004\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\"\u0010\u0004\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\f2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u000f*\u00020\u0002\u001a!\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0015\u001a\f\u0010\u0016\u001a\u00020\u0001*\u0004\u0018\u00010\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a*\u0010\u0018\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u001b\u001a \u0010\u001c\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0001\u001a \u0010\u001e\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0001\u001a\u000f\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!*\u00020\"\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006#"}, d2={"isComma", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "applyKotlinCodeStyle", "codeStyleId", "", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "modifyCodeStyle", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "containsLineBreakInChild", "globalStartOffset", "", "globalEndOffset", "getLineCount", "getLineCountByDocument", "startOffset", "endOffset", "(Lcom/intellij/psi/PsiElement;II)Ljava/lang/Integer;", "isLineBreak", "isMultiline", "leaf", "forward", "filter", "Lkotlin/Function1;", "leafIgnoringWhitespace", "skipEmptyElements", "leafIgnoringWhitespaceAndComments", "requireNode", "Lcom/intellij/lang/ASTNode;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/formatting/ASTBlock;", "kotlin.formatter"})
@SourceDebugExtension(value={"SMAP\nFormatterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatterUtil.kt\norg/jetbrains/kotlin/idea/util/FormatterUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n1#2:96\n1247#3,2:97\n*S KotlinDebug\n*F\n+ 1 FormatterUtil.kt\norg/jetbrains/kotlin/idea/util/FormatterUtilKt\n*L\n64#1:97,2\n*E\n"})
public final class FormatterUtilKt {
    @NotNull
    public static final ASTNode requireNode(@NotNull ASTBlock $this$requireNode) {
        Intrinsics.checkNotNullParameter((Object)$this$requireNode, (String)"<this>");
        ASTNode aSTNode = $this$requireNode.getNode();
        if (aSTNode == null) {
            throw new IllegalStateException("ASTBlock.getNode() returned null".toString());
        }
        return aSTNode;
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getLineCount, (String)"<this>");
        TextRange textRange = $this$getLineCount.getTextRange();
        if (textRange == null) {
            textRange = TextRange.EMPTY_RANGE;
        }
        TextRange spaceRange = textRange;
        Integer n2 = FormatterUtilKt.getLineCountByDocument($this$getLineCount, spaceRange.getStartOffset(), spaceRange.getEndOffset());
        if (n2 != null) {
            n = n2;
        } else {
            String string2 = $this$getLineCount.getText();
            if (string2 == null) {
                throw new IllegalStateException("Cannot count number of lines".toString());
            }
            n = StringUtil.getLineBreakCount((CharSequence)string2) + 1;
        }
        return n;
    }

    @Nullable
    public static final Integer getLineCountByDocument(@NotNull PsiElement $this$getLineCountByDocument, int startOffset, int endOffset2) {
        PsiFile psiFile2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$getLineCountByDocument, (String)"<this>");
                psiFile2 = $this$getLineCountByDocument.getContainingFile();
                if (psiFile2 == null) break block4;
                PsiFile it = psiFile2;
                boolean bl = false;
                Document document = PsiDocumentManager.getInstance((Project)$this$getLineCountByDocument.getProject()).getDocument(it);
                psiFile2 = document;
                if (document != null) break block5;
            }
            return null;
        }
        PsiFile doc = psiFile2;
        if (endOffset2 > doc.getTextLength() || startOffset >= endOffset2) {
            return null;
        }
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset2);
        return endLine - startLine + 1;
    }

    public static final boolean isMultiline(@NotNull PsiElement $this$isMultiline) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiline, (String)"<this>");
        return FormatterUtilKt.getLineCount($this$isMultiline) > 1;
    }

    public static final boolean isLineBreak(@Nullable PsiElement $this$isLineBreak) {
        return $this$isLineBreak instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)((PsiWhiteSpace)$this$isLineBreak).getText());
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespace(@NotNull PsiElement $this$leafIgnoringWhitespace, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespace, (String)"<this>");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespace, forward, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(skipEmptyElements){
            final /* synthetic */ boolean $skipEmptyElements;
            {
                this.$skipEmptyElements = $skipEmptyElements;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (!this.$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace);
            }
        }));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespace$default(PsiElement psiElement2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespace(psiElement2, bl, bl2);
    }

    @Nullable
    public static final PsiElement leafIgnoringWhitespaceAndComments(@NotNull PsiElement $this$leafIgnoringWhitespaceAndComments, boolean forward, boolean skipEmptyElements) {
        Intrinsics.checkNotNullParameter((Object)$this$leafIgnoringWhitespaceAndComments, (String)"<this>");
        return FormatterUtilKt.leaf($this$leafIgnoringWhitespaceAndComments, forward, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(skipEmptyElements){
            final /* synthetic */ boolean $skipEmptyElements;
            {
                this.$skipEmptyElements = $skipEmptyElements;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (!this.$skipEmptyElements || it.getTextLength() != 0) && !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment);
            }
        }));
    }

    public static /* synthetic */ PsiElement leafIgnoringWhitespaceAndComments$default(PsiElement psiElement2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return FormatterUtilKt.leafIgnoringWhitespaceAndComments(psiElement2, bl, bl2);
    }

    @Nullable
    public static final PsiElement leaf(@NotNull PsiElement $this$leaf, boolean forward, @NotNull Function1<? super PsiElement, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)$this$leaf, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return forward ? PsiUtilsKt.nextLeaf((PsiElement)$this$leaf, filter2) : PsiUtilsKt.prevLeaf((PsiElement)$this$leaf, filter2);
    }

    public static /* synthetic */ PsiElement leaf$default(PsiElement psiElement2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return FormatterUtilKt.leaf(psiElement2, bl, (Function1<? super PsiElement, Boolean>)function1);
    }

    public static final boolean isComma(@NotNull PsiElement $this$isComma) {
        Intrinsics.checkNotNullParameter((Object)$this$isComma, (String)"<this>");
        return Intrinsics.areEqual((Object)PsiUtil.getElementType((PsiElement)$this$isComma), (Object)KtTokens.COMMA);
    }

    public static final boolean containsLineBreakInChild(@NotNull PsiElement $this$containsLineBreakInChild, int globalStartOffset, int globalEndOffset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$containsLineBreakInChild, (String)"<this>");
            Integer n = FormatterUtilKt.getLineCountByDocument($this$containsLineBreakInChild, globalStartOffset, globalEndOffset);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                bl = it > 1;
            } else {
                PsiElement psiElement2 = $this$containsLineBreakInChild.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"firstChild");
                Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((PsiElement)psiElement2, (boolean)true, (boolean)true), (Function1)((Function1)new Function1<PsiElement, Boolean>(globalStartOffset){
                    final /* synthetic */ int $globalStartOffset;
                    {
                        this.$globalStartOffset = $globalStartOffset;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return PsiUtilsKt.getStartOffset((PsiElement)it) < this.$globalStartOffset;
                    }
                })), (Function1)((Function1)new Function1<PsiElement, Boolean>(globalEndOffset){
                    final /* synthetic */ int $globalEndOffset;
                    {
                        this.$globalEndOffset = $globalEndOffset;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return PsiUtilsKt.getEndOffset((PsiElement)it) <= this.$globalEndOffset;
                    }
                }));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it.textContains('\n') || it.textContains('\r'))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull KotlinCodeStyleSettings codeStyleSettings, boolean modifyCodeStyle) {
        block1: {
            String string2;
            block0: {
                Intrinsics.checkNotNullParameter((Object)((Object)codeStyleSettings), (String)"codeStyleSettings");
                string2 = codeStyleId;
                if (!Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OFFICIAL")) break block0;
                KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings(codeStyleSettings, modifyCodeStyle);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OLD_DEFAULTS")) break block1;
            KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings(codeStyleSettings, modifyCodeStyle);
        }
    }

    public static /* synthetic */ void applyKotlinCodeStyle$default(String string2, KotlinCodeStyleSettings kotlinCodeStyleSettings, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        FormatterUtilKt.applyKotlinCodeStyle(string2, kotlinCodeStyleSettings, bl);
    }

    public static final void applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull CommonCodeStyleSettings codeStyleSettings, boolean modifyCodeStyle) {
        block1: {
            String string2;
            block0: {
                Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
                string2 = codeStyleId;
                if (!Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OFFICIAL")) break block0;
                KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings(codeStyleSettings, modifyCodeStyle);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OLD_DEFAULTS")) break block1;
            KotlinObsoleteCodeStyle.Companion.applyToCommonSettings(codeStyleSettings, modifyCodeStyle);
        }
    }

    public static /* synthetic */ void applyKotlinCodeStyle$default(String string2, CommonCodeStyleSettings commonCodeStyleSettings, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        FormatterUtilKt.applyKotlinCodeStyle(string2, commonCodeStyleSettings, bl);
    }

    public static final boolean applyKotlinCodeStyle(@Nullable String codeStyleId, @NotNull CodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        String string2 = codeStyleId;
        if (Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OFFICIAL")) {
            KotlinStyleGuideCodeStyle.Companion.apply(codeStyleSettings);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"KOTLIN_OLD_DEFAULTS")) {
            KotlinObsoleteCodeStyle.Companion.apply(codeStyleSettings);
        } else {
            return false;
        }
        return true;
    }
}

