/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.impl.CollectionDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.indices.names.InternalUtilsKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u000fH\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00020\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinShortClassNameFileIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "", "()V", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/EnumeratorStringDescriptor;", "getName", "Lcom/intellij/util/indexing/ID;", "getValueExternalizer", "Lcom/intellij/util/indexing/impl/CollectionDataExternalizer;", "kotlin.jvm.PlatformType", "getVersion", "", "traceKeyHashToVirtualFileMapping", "Companion", "kotlin.base.indices"})
public final class KotlinShortClassNameFileIndex
extends FileBasedIndexExtension<String, Collection<? extends String>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ID<String, Collection<String>> NAME;

    @NotNull
    public ID<String, Collection<String>> getName() {
        return NAME;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public EnumeratorStringDescriptor getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        return enumeratorStringDescriptor;
    }

    @NotNull
    public CollectionDataExternalizer<String> getValueExternalizer() {
        return new CollectionDataExternalizer((DataExternalizer)EnumeratorStringDescriptor.INSTANCE);
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{KotlinFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE, JavaClassFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 3;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @NotNull
    public DataIndexer<String, Collection<String>, FileContent> getIndexer() {
        return KotlinShortClassNameFileIndex::getIndexer$lambda$0;
    }

    private static final Map getIndexer$lambda$0(FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        HashMap<String, Collection<String>> map2 = new HashMap<String, Collection<String>>();
        FileType fileType = fileContent.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
            ClsKotlinBinaryClassCache clsKotlinBinaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
            VirtualFile virtualFile2 = fileContent.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"fileContent.file");
            KotlinJvmBinaryClass kotlinBinaryClass = clsKotlinBinaryClassCache.getKotlinBinaryClass(virtualFile2, fileContent.getContent());
            if (kotlinBinaryClass != null) {
                ClassId classId = kotlinBinaryClass.getClassId();
                Map map3 = map2;
                String string2 = classId.getShortClassName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.asString()");
                String string3 = string2;
                List list2 = CollectionsKt.listOf((Object)classId.asFqNameString());
                map3.put(string3, list2);
            }
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInFileType.INSTANCE)) {
            KotlinMetadataStubBuilder.FileWithMetadata.Compatible builtins = InternalUtilsKt.readKotlinMetadataDefinition(fileContent);
            if (builtins != null) {
                for (ProtoBuf.Class classProto : builtins.getClassesToDecompile()) {
                    String string4;
                    ClassId classId = NameResolverUtilKt.getClassId((NameResolver)((NameResolver)builtins.getNameResolver()), (int)classProto.getFqName());
                    Map map4 = map2;
                    Intrinsics.checkNotNullExpressionValue((Object)classId.getShortClassName().asString(), (String)"classId.shortClassName.asString()");
                    List list3 = CollectionsKt.listOf((Object)classId.asFqNameString());
                    map4.put(string4, list3);
                }
            }
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE)) {
            PsiFile psiFile2 = fileContent.getPsiFile();
            KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile == null) {
                return MapsKt.emptyMap();
            }
            KtFile ktFile2 = ktFile;
            ktFile2.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(map2){
                final /* synthetic */ HashMap<String, Collection<String>> $map;
                {
                    this.$map = $map;
                }

                public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
                    Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
                    FqName fqName2 = enumEntry.getFqName();
                    this.add(enumEntry.getName(), fqName2 != null ? fqName2.asString() : null);
                    super.visitEnumEntry(enumEntry);
                }

                public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
                    Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                    FqName fqName2 = classOrObject.getFqName();
                    this.add(classOrObject.getName(), fqName2 != null ? fqName2.asString() : null);
                    super.visitClassOrObject(classOrObject);
                }

                private final void add(String name2, String fqName2) {
                    if (name2 != null && fqName2 != null) {
                        Object object;
                        Map $this$getOrPut$iv = this.$map;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(name2);
                        if (value$iv == null) {
                            boolean bl = false;
                            Collection answer$iv = new ArrayList<E>();
                            $this$getOrPut$iv.put(name2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        ArrayList fqNames = (ArrayList)object;
                        ((Collection)fqNames).add(fqName2);
                    }
                }
            });
        }
        return map2;
    }

    static {
        ID iD = ID.create((String)KotlinShortClassNameFileIndex.class.getCanonicalName());
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(KotlinShortClassN\u2026class.java.canonicalName)");
        NAME = iD;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinShortClassNameFileIndex$Companion;", "", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "", "", "getNAME", "()Lcom/intellij/util/indexing/ID;", "kotlin.base.indices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<String, Collection<String>> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

