/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.licensecommon.util;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import com.intellij.licensecommon.util.SubscriptionLicenseDecoder;
import com.intellij.licensecommon.util.SubscriptionLicenseInfo;

public class RubyMineLicenseDecoder {
    public static final int DEFAULT_SUBSCRIPTION_LENGTH = 365;

    private RubyMineLicenseDecoder() {
    }

    public static SubscriptionLicenseInfo decode(String key, String userName) throws InvalidLicenseKeyException {
        SubscriptionLicenseInfo info = new SubscriptionLicenseInfo();
        byte[] bytes = SubscriptionLicenseDecoder.decodeKeyAndCustomerId(key, info);
        try {
            SubscriptionLicenseDecoder.decodeData(bytes, info, userName, 14);
            SubscriptionLicenseDecoder.fillLicenseInfo(bytes, info, userName, -1);
            return info;
        }
        catch (InvalidLicenseKeyException invalidLicenseKeyException) {
            try {
                SubscriptionLicenseDecoder.decodeData(bytes, info, userName, 12);
                SubscriptionLicenseDecoder.fillLicenseInfo(bytes, info, userName, 365);
                return info;
            }
            catch (InvalidLicenseKeyException ignore) {
                throw new InvalidLicenseKeyException();
            }
        }
    }
}

