/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.details.model;

import git4idea.commands.Git;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.dto.GitLabProjectDTO;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010\r\u001a\u0004\u0018\u00010\u0006*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"findNameForRemote", "", "repository", "Lgit4idea/repo/GitRepository;", "preferredName", "findRemote", "Lgit4idea/repo/GitRemote;", "project", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabProjectDTO;", "isBranchCheckedOut", "", "sourceBranch", "shouldAddHttpRemote", "createRemote", "Lgit4idea/commands/Git;", "remoteName", "url", "findOrCreateRemote", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestBranchesViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestBranchesViewModel.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestBranchesViewModelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n1620#3,3:194\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestBranchesViewModel.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestBranchesViewModelKt\n*L\n181#1:194,3\n*E\n"})
public final class GitLabMergeRequestBranchesViewModelKt {
    private static final boolean isBranchCheckedOut(GitRepository repository, String sourceBranch2) {
        String currentBranchName = repository.getCurrentBranchName();
        return Intrinsics.areEqual((Object)currentBranchName, (Object)sourceBranch2);
    }

    private static final GitRemote findOrCreateRemote(Git $this$findOrCreateRemote, GitRepository repository, GitLabProjectDTO project) {
        GitRemote existingRemote = GitLabMergeRequestBranchesViewModelKt.findRemote(repository, project);
        if (existingRemote != null) {
            return existingRemote;
        }
        String httpUrl = project.getHttpUrlToRepo();
        String sshUrl = project.getSshUrlToRepo();
        boolean preferHttp = GitLabMergeRequestBranchesViewModelKt.shouldAddHttpRemote(repository);
        return preferHttp && httpUrl != null ? GitLabMergeRequestBranchesViewModelKt.createRemote($this$findOrCreateRemote, repository, project.getOwnerPath(), httpUrl) : (sshUrl != null ? GitLabMergeRequestBranchesViewModelKt.createRemote($this$findOrCreateRemote, repository, project.getOwnerPath(), sshUrl) : null);
    }

    private static final GitRemote findRemote(GitRepository repository, GitLabProjectDTO project) {
        Object v1;
        block1: {
            Collection collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
            Iterable iterable = collection;
            for (Object t : iterable) {
                GitRemote it = (GitRemote)t;
                boolean bl = false;
                String url = it.getFirstUrl();
                if (!(url != null && StringsKt.endsWith$default((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)url, (CharSequence)"/"), (CharSequence)".git"), (String)project.getFullPath(), (boolean)false, (int)2, null))) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final boolean shouldAddHttpRemote(GitRepository repository) {
        Object preferredRemoteUrl;
        Object object;
        block5: {
            Object v1;
            block4: {
                Collection collection = repository.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
                Iterable iterable = collection;
                for (Object object2 : iterable) {
                    GitRemote it = (GitRemote)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"origin")) continue;
                    v1 = object2;
                    break block4;
                }
                v1 = null;
            }
            if ((object = (GitRemote)v1) == null || (object = object.getFirstUrl()) == null) {
                Collection collection = repository.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
                for (GitRemote it : (Iterable)collection) {
                    Object object2;
                    boolean bl = false;
                    object2 = it.getFirstUrl();
                    if (object2 == null) continue;
                    object = object2;
                    break block5;
                }
                object = null;
            }
        }
        if ((preferredRemoteUrl = object) != null) {
            return StringsKt.startsWith$default((String)preferredRemoteUrl, (String)"http", (boolean)false, (int)2, null);
        }
        return true;
    }

    private static final GitRemote createRemote(Git $this$createRemote, GitRepository repository, String remoteName, String url) {
        Object v2;
        block2: {
            String string = GitLabMergeRequestBranchesViewModelKt.findNameForRemote(repository, remoteName);
            if (string == null) {
                return null;
            }
            String actualName = string;
            GitRepository $this$createRemote_u24lambda_u244 = repository;
            boolean bl = false;
            $this$createRemote.addRemote($this$createRemote_u24lambda_u244, actualName, url);
            $this$createRemote_u24lambda_u244.update();
            Collection collection = $this$createRemote_u24lambda_u244.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"remotes");
            Iterable iterable = collection;
            for (Object t : iterable) {
                GitRemote it = (GitRemote)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)actualName)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private static final String findNameForRemote(GitRepository repository, String preferredName) {
        Iterator<Object> iterator;
        block3: {
            void destination$iv;
            void $this$mapTo$iv;
            Collection collection = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.remotes");
            Object[] objectArray = (Object[])collection;
            Collection collection2 = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                GitRemote gitRemote = (GitRemote)item$iv;
                void var10_11 = destination$iv;
                boolean bl = false;
                var10_11.add(p0.getName());
            }
            Set exitingNames = (Set)destination$iv;
            if (!exitingNames.contains(preferredName)) {
                return preferredName;
            }
            objectArray = new IntRange[]{new IntRange(1, Integer.MAX_VALUE)};
            collection2 = SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)((Function1)new Function1<IntRange, String>(preferredName){
                final /* synthetic */ String $preferredName;
                {
                    this.$preferredName = $preferredName;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull IntRange it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$preferredName + "_" + it;
                }
            }));
            for (Iterator<Object> iterator2 : collection2) {
                String it = (String)((Object)iterator2);
                boolean bl = false;
                if (!exitingNames.contains(it)) continue;
                iterator = iterator2;
                break block3;
            }
            iterator = null;
        }
        return (String)((Object)iterator);
    }

    public static final /* synthetic */ GitRemote access$findOrCreateRemote(Git $receiver, GitRepository repository, GitLabProjectDTO project) {
        return GitLabMergeRequestBranchesViewModelKt.findOrCreateRemote($receiver, repository, project);
    }

    public static final /* synthetic */ boolean access$isBranchCheckedOut(GitRepository repository, String sourceBranch2) {
        return GitLabMergeRequestBranchesViewModelKt.isBranchCheckedOut(repository, sourceBranch2);
    }
}

