/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.codehaus.plexus.component.repository.ComponentDependency;

@Singleton
@Named
class Maven2DependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    Maven2DependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        Set maven2Versions = mojoDescriptor.getPluginDescriptor().getDependencies().stream().filter(d -> "org.apache.maven".equals(d.getGroupId())).filter(d -> !this.expectedProvidedScopeExclusions.contains(d.getGroupId() + ":" + d.getArtifactId())).map(ComponentDependency::getVersion).filter(v -> v.startsWith("2.")).collect(Collectors.toSet());
        if (!maven2Versions.isEmpty()) {
            this.pluginValidationManager.reportPluginValidationIssue(mavenSession, mojoDescriptor, "Plugin is a Maven 2.x plugin, which will be not supported in Maven 4.x");
        }
    }
}

