/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

class TMHAssertionGenerator {
    private static final String DEFAULT_APPLICATION_MANAGER_CLASS_NAME = "com/intellij/openapi/application/ApplicationManager";
    private static final String DEFAULT_APPLICATION_CLASS_NAME = "com/intellij/openapi/application/Application";
    private static final String GENERATE_ASSERTION_PARAMETER = "generateAssertion";
    private static final String GET_APPLICATION_METHOD_NAME = "getApplication";
    private static final Type[] EMPTY = new Type[0];
    private final Type myAnnotationClass;
    private final Type myApplicationManagerClass;
    private final Type myApplicationClass;
    private final Method myGetApplicationMethod;
    private final Method myAssetionMethod;

    TMHAssertionGenerator(Type annotationClass, Type applicationManagerClass, Type applicationClass, Method assetionMethod) {
        this.myAnnotationClass = annotationClass;
        this.myApplicationManagerClass = applicationManagerClass;
        this.myApplicationClass = applicationClass;
        this.myGetApplicationMethod = new Method(GET_APPLICATION_METHOD_NAME, applicationClass, EMPTY);
        this.myAssetionMethod = assetionMethod;
    }

    boolean isMyAnnotation(String annotationDescriptor) {
        return this.myAnnotationClass.getDescriptor().equals(annotationDescriptor);
    }

    public AnnotationChecker getAnnotationChecker(int api, Runnable onShouldGenerateAssertion) {
        return new AnnotationChecker(api, onShouldGenerateAssertion);
    }

    void generateAssertion(MethodVisitor writer, int methodStartLineNumber) {
        if (methodStartLineNumber != -1) {
            Label generatedCodeStart = new Label();
            writer.visitLabel(generatedCodeStart);
            writer.visitLineNumber(methodStartLineNumber, generatedCodeStart);
        }
        writer.visitMethodInsn(184, this.myApplicationManagerClass.getInternalName(), this.myGetApplicationMethod.getName(), this.myGetApplicationMethod.getDescriptor(), false);
        writer.visitMethodInsn(185, this.myApplicationClass.getInternalName(), this.myAssetionMethod.getName(), this.myAssetionMethod.getDescriptor(), true);
    }

    static class AnnotationChecker
    extends AnnotationVisitor {
        private boolean myShouldGenerateAssertion = true;
        private final Runnable myOnShouldGenerateAssertion;

        private AnnotationChecker(int api, Runnable onShouldGenerateAssertion) {
            super(api);
            this.myOnShouldGenerateAssertion = onShouldGenerateAssertion;
        }

        public void visit(String annotationParameterName, Object value) {
            if (TMHAssertionGenerator.GENERATE_ASSERTION_PARAMETER.equals(annotationParameterName) && Boolean.FALSE.equals(value)) {
                this.myShouldGenerateAssertion = false;
            }
        }

        public void visitEnd() {
            if (this.myShouldGenerateAssertion) {
                this.myOnShouldGenerateAssertion.run();
            }
        }
    }

    static class AssertNoReadAccess
    extends TMHAssertionGenerator {
        private static final String DEFAULT_ANNOTATION_CLASS_NAME = "com/intellij/util/concurrency/annotations/RequiresReadLockAbsence";

        AssertNoReadAccess() {
            this(DEFAULT_ANNOTATION_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_MANAGER_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_CLASS_NAME);
        }

        AssertNoReadAccess(String annotationClassName, String applicationManagerClassName, String applicationClassName) {
            this(Type.getType((String)("L" + annotationClassName + ";")), Type.getType((String)("L" + applicationManagerClassName + ";")), Type.getType((String)("L" + applicationClassName + ";")));
        }

        AssertNoReadAccess(Type annotationClass, Type applicationManagerClass, Type applicationClass) {
            super(annotationClass, applicationManagerClass, applicationClass, new Method("assertReadAccessNotAllowed", "()V"));
        }
    }

    static class AssertWriteAccess
    extends TMHAssertionGenerator {
        private static final String DEFAULT_ANNOTATION_CLASS_NAME = "com/intellij/util/concurrency/annotations/RequiresWriteLock";

        AssertWriteAccess() {
            this(Type.getType((String)"Lcom/intellij/util/concurrency/annotations/RequiresWriteLock;"), Type.getType((String)"Lcom/intellij/openapi/application/ApplicationManager;"), Type.getType((String)"Lcom/intellij/openapi/application/Application;"));
        }

        AssertWriteAccess(String annotationClassName, String applicationManagerClassName, String applicationClassName) {
            this(Type.getType((String)("L" + annotationClassName + ";")), Type.getType((String)("L" + applicationManagerClassName + ";")), Type.getType((String)("L" + applicationClassName + ";")));
        }

        AssertWriteAccess(Type annotationClass, Type applicationManagerClass, Type applicationClass) {
            super(annotationClass, applicationManagerClass, applicationClass, new Method("assertWriteAccessAllowed", "()V"));
        }
    }

    static class AssertReadAccess
    extends TMHAssertionGenerator {
        private static final String DEFAULT_ANNOTATION_CLASS_NAME = "com/intellij/util/concurrency/annotations/RequiresReadLock";

        AssertReadAccess() {
            this(Type.getType((String)"Lcom/intellij/util/concurrency/annotations/RequiresReadLock;"), Type.getType((String)"Lcom/intellij/openapi/application/ApplicationManager;"), Type.getType((String)"Lcom/intellij/openapi/application/Application;"));
        }

        AssertReadAccess(String annotationClassName, String applicationManagerClassName, String applicationClassName) {
            this(Type.getType((String)("L" + annotationClassName + ";")), Type.getType((String)("L" + applicationManagerClassName + ";")), Type.getType((String)("L" + applicationClassName + ";")));
        }

        AssertReadAccess(Type annotationClass, Type applicationManagerClass, Type applicationClass) {
            super(annotationClass, applicationManagerClass, applicationClass, new Method("assertReadAccessAllowed", "()V"));
        }
    }

    static class AssertBackgroundThread
    extends TMHAssertionGenerator {
        private static final String DEFAULT_ANNOTATION_CLASS_NAME = "com/intellij/util/concurrency/annotations/RequiresBackgroundThread";

        AssertBackgroundThread() {
            this(DEFAULT_ANNOTATION_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_MANAGER_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_CLASS_NAME);
        }

        AssertBackgroundThread(String annotationClassName, String applicationManagerClassName, String applicationClassName) {
            this(Type.getType((String)("L" + annotationClassName + ";")), Type.getType((String)("L" + applicationManagerClassName + ";")), Type.getType((String)("L" + applicationClassName + ";")));
        }

        AssertBackgroundThread(Type annotationClass, Type applicationManagerClass, Type applicationClass) {
            super(annotationClass, applicationManagerClass, applicationClass, new Method("assertIsNonDispatchThread", "()V"));
        }
    }

    static class AssertEdt
    extends TMHAssertionGenerator {
        private static final String DEFAULT_ANNOTATION_CLASS_NAME = "com/intellij/util/concurrency/annotations/RequiresEdt";

        AssertEdt() {
            this(DEFAULT_ANNOTATION_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_MANAGER_CLASS_NAME, TMHAssertionGenerator.DEFAULT_APPLICATION_CLASS_NAME);
        }

        AssertEdt(String annotationClassName, String applicationManagerClassName, String applicationClassName) {
            this(Type.getType((String)("L" + annotationClassName + ";")), Type.getType((String)("L" + applicationManagerClassName + ";")), Type.getType((String)("L" + applicationClassName + ";")));
        }

        AssertEdt(Type annotationClass, Type applicationManagerClass, Type applicationClass) {
            super(annotationClass, applicationManagerClass, applicationClass, new Method("assertIsDispatchThread", "()V"));
        }
    }
}

