/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.devkit.DevKitJpsBundle;
import org.jetbrains.jps.devkit.threadingModelHelper.TMHInstrumenter;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class TMHInstrumentingBuilder
extends BaseInstrumentingBuilder {
    private static final Logger LOG = Logger.getInstance(TMHInstrumentingBuilder.class);
    static final String INSTRUMENT_ANNOTATIONS_PROPERTY = "tmh.instrument.annotations";
    static final String GENERATE_LINE_NUMBERS_PROPERTY = "tmh.generate.line.numbers";

    @NotNull
    public String getPresentableName() {
        String string = DevKitJpsBundle.message("tmh.instrumenting.builder.name", new Object[0]);
        if (string == null) {
            TMHInstrumentingBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected String getProgressMessage() {
        return DevKitJpsBundle.message("tmh.instrumenting.builder.progress", new Object[0]);
    }

    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        return SystemProperties.getBooleanProperty((String)INSTRUMENT_ANNOTATIONS_PROPERTY, (boolean)false) || Boolean.TRUE.toString().equals(context.getBuilderParameter(INSTRUMENT_ANNOTATIONS_PROPERTY));
    }

    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return !"module-info".equals(compiledClass.getClassName());
    }

    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiledClass, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        try {
            boolean generateLineNumbers = SystemProperties.getBooleanProperty((String)GENERATE_LINE_NUMBERS_PROPERTY, (boolean)false);
            if (TMHInstrumenter.instrument(reader, (ClassVisitor)writer, generateLineNumbers)) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            Collection sourceFiles = compiledClass.getSourceFiles();
            String msg = DevKitJpsBundle.message("tmh.cannot.instrument", StringUtil.join((Collection)sourceFiles, File::getName, (String)", "), e.getMessage());
            String firstFile = (String)ContainerUtil.getFirstItem((List)compiledClass.getSourceFilesPaths());
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, msg, firstFile));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/threadingModelHelper/TMHInstrumentingBuilder", "getPresentableName"));
    }
}

