/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.holder;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.eventtrace.abstractevent.MetadataRenameEventType;
import com.intellij.profiler.eventtrace.abstractevent.MetadataType;
import com.intellij.profiler.eventtrace.abstractevent.TraceEvent;
import com.intellij.profiler.eventtrace.abstractevent.TraceGlobalEvent;
import com.intellij.profiler.eventtrace.abstractevent.TraceGlobalEventType;
import com.intellij.profiler.eventtrace.abstractevent.TraceMetadataEvent;
import com.intellij.profiler.eventtrace.abstractevent.TracePartialEvent;
import com.intellij.profiler.eventtrace.holder.ClosableEventHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001fH\u0014J,\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030'H\u0014R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/profiler/eventtrace/holder/EventNodeHolder;", "Lcom/intellij/profiler/eventtrace/holder/ClosableEventHolder;", "level", "", "name", "splitKey", "globalLevel", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceGlobalEventType;", "childConstructor", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/profiler/eventtrace/abstractevent/TraceGlobalEventType;Lkotlin/jvm/functions/Function1;)V", "childes", "Ljava/util/HashMap;", "globalEvents", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceGlobalEvent;", "getLevel", "()Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "forcePush", "", "higherLevelEvents", "Ljava/util/LinkedList;", "metadataAdd", "", "e", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceMetadataEvent;", "safeAdd", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceEvent;", "safeBuildNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "isCompact", "isReverseList", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "model", "Lkotlin/reflect/KClass;", "intellij.profiler.common"})
public class EventNodeHolder
extends ClosableEventHolder {
    @NotNull
    private final String level;
    @NotNull
    private String name;
    @NotNull
    private final String splitKey;
    @Nullable
    private final TraceGlobalEventType globalLevel;
    @NotNull
    private final Function1<Long, ClosableEventHolder> childConstructor;
    @NotNull
    private final HashMap<Long, ClosableEventHolder> childes;
    @NotNull
    private final ArrayList<TraceGlobalEvent> globalEvents;

    public EventNodeHolder(@NotNull String level, @NotNull String name, @NotNull String splitKey, @Nullable TraceGlobalEventType globalLevel, @NotNull Function1<? super Long, ? extends ClosableEventHolder> childConstructor) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)splitKey, (String)"splitKey");
        Intrinsics.checkNotNullParameter(childConstructor, (String)"childConstructor");
        this.level = level;
        this.name = name;
        this.splitKey = splitKey;
        this.globalLevel = globalLevel;
        this.childConstructor = childConstructor;
        this.childes = new HashMap();
        this.globalEvents = new ArrayList();
    }

    @NotNull
    public final String getLevel() {
        return this.level;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public boolean metadataAdd(@NotNull TraceMetadataEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getMetadata() instanceof MetadataRenameEventType) {
            MetadataType metadataType = e.getMetadata();
            Intrinsics.checkNotNull((Object)metadataType, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.abstractevent.MetadataRenameEventType");
            if (Intrinsics.areEqual((Object)((MetadataRenameEventType)metadataType).getLevel(), (Object)this.level)) {
                MetadataType metadataType2 = e.getMetadata();
                Intrinsics.checkNotNull((Object)metadataType2, (String)"null cannot be cast to non-null type com.intellij.profiler.eventtrace.abstractevent.MetadataRenameEventType");
                this.name = ((MetadataRenameEventType)metadataType2).getName();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void safeAdd(@NotNull TraceEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof TraceGlobalEvent && this.globalLevel != null && ((TraceGlobalEvent)e).getTypeEvent().compareTo(this.globalLevel) <= 0) {
            this.globalEvents.add((TraceGlobalEvent)e);
            return;
        }
        if (e instanceof TraceMetadataEvent && this.metadataAdd((TraceMetadataEvent)e)) {
            return;
        }
        if (e instanceof TracePartialEvent && ((TracePartialEvent)e).getPart().containsKey(this.splitKey)) {
            Long l = ((TracePartialEvent)e).getPart().get(this.splitKey);
            Intrinsics.checkNotNull((Object)l);
            long splitter = ((Number)l).longValue();
            if (!this.childes.containsKey(splitter)) {
                Long l2 = splitter;
                ((Map)this.childes).put(l2, this.childConstructor.invoke((Object)splitter));
            }
            ClosableEventHolder closableEventHolder = this.childes.get(splitter);
            Intrinsics.checkNotNull((Object)closableEventHolder);
            closableEventHolder.add(e);
        }
    }

    @Override
    protected void forcePush(@NotNull LinkedList<ArrayList<TraceGlobalEvent>> higherLevelEvents) {
        Intrinsics.checkNotNullParameter(higherLevelEvents, (String)"higherLevelEvents");
        higherLevelEvents.addLast(this.globalEvents);
        for (ClosableEventHolder child : this.childes.values()) {
            child.close(higherLevelEvents);
        }
        higherLevelEvents.removeLast();
        this.globalEvents.clear();
    }

    @Override
    @NotNull
    protected DefaultMutableTreeNode safeBuildNode(boolean isCompact, boolean isReverseList, @NotNull ProgressIndicator progressIndicator, @NotNull KClass<?> model2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.name);
        for (ClosableEventHolder it : this.childes.values()) {
            root.add(it.buildNode(isCompact, isReverseList, progressIndicator, model2));
            if (!progressIndicator.isCanceled()) continue;
            return root;
        }
        return root;
    }
}

