/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.profiler.api.NameBasedFilterProvider;
import com.intellij.profiler.settings.CallTreeFilterRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H&J\b\u0010\u0014\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016R\u001f\u0010\u0004\u001a\u00060\u0005R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/settings/CallTreeFilterRuleManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "cache", "Lcom/intellij/profiler/settings/CallTreeFilterRuleManager$Compiled;", "getCache", "()Lcom/intellij/profiler/settings/CallTreeFilterRuleManager$Compiled;", "cache$delegate", "Lkotlin/Lazy;", "rules", "Ljava/util/ArrayList;", "Lcom/intellij/profiler/settings/CallTreeFilterRule;", "Lkotlin/collections/ArrayList;", "getRules", "()Ljava/util/ArrayList;", "setRules", "(Ljava/util/ArrayList;)V", "getDefaultRules", "", "getName", "", "getState", "loadState", "", "state", "noStateLoaded", "Compiled", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallTreeFilterRuleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeFilterRuleManager.kt\ncom/intellij/profiler/settings/CallTreeFilterRuleManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n*S KotlinDebug\n*F\n+ 1 CallTreeFilterRuleManager.kt\ncom/intellij/profiler/settings/CallTreeFilterRuleManager\n*L\n38#1:65,2\n*E\n"})
public abstract class CallTreeFilterRuleManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Lazy cache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Compiled>(this){
        final /* synthetic */ CallTreeFilterRuleManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Compiled invoke() {
            return new Compiled(this.this$0, null, null, 3, null);
        }
    }));
    @NotNull
    private ArrayList<CallTreeFilterRule> rules = new ArrayList();

    @NotNull
    public final Compiled getCache() {
        Lazy lazy = this.cache$delegate;
        return (Compiled)lazy.getValue();
    }

    @NotNull
    public final ArrayList<CallTreeFilterRule> getRules() {
        return this.rules;
    }

    public final void setRules(@NotNull ArrayList<CallTreeFilterRule> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.rules = arrayList;
    }

    @NotNull
    public Element getState() {
        Element el = new Element(this.getName());
        for (CallTreeFilterRule group2 : this.rules) {
            Element gel = new Element("group").setAttribute("name", group2.getGroupName());
            Iterable $this$forEach$iv = group2.getRules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                gel.addContent(new Element("item").addContent(it));
            }
            el.addContent(gel);
        }
        return el;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.rules.clear();
        for (Element element2 : state.getChildren()) {
            Intrinsics.checkNotNull((Object)element2, (String)"null cannot be cast to non-null type org.jdom.Element");
            String groupName = element2.getAttribute("name").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)groupName, (String)"groupName");
            CallTreeFilterRule jr = new CallTreeFilterRule(groupName, new String[0]);
            for (Element rule : element2.getChildren()) {
                List<String> list = jr.getRules();
                String string = rule.getContent(0).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rule.getContent(0).value");
                list.add(string);
            }
            this.rules.add(jr);
        }
    }

    public void noStateLoaded() {
        this.rules.addAll((Collection<CallTreeFilterRule>)this.getDefaultRules());
    }

    @NotNull
    public abstract List<CallTreeFilterRule> getDefaultRules();

    @NotNull
    public abstract String getName();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/settings/CallTreeFilterRuleManager$Compiled;", "", "filters", "", "Ljava/util/regex/Pattern;", "exclusions", "(Lcom/intellij/profiler/settings/CallTreeFilterRuleManager;Ljava/util/List;Ljava/util/List;)V", "getExclusions", "()Ljava/util/List;", "getFilters", "recompile", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nCallTreeFilterRuleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTreeFilterRuleManager.kt\ncom/intellij/profiler/settings/CallTreeFilterRuleManager$Compiled\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1360#2:65\n1446#2,5:66\n1855#2,2:71\n*S KotlinDebug\n*F\n+ 1 CallTreeFilterRuleManager.kt\ncom/intellij/profiler/settings/CallTreeFilterRuleManager$Compiled\n*L\n21#1:65\n21#1:66,5\n21#1:71,2\n*E\n"})
    public final class Compiled {
        @NotNull
        private final List<Pattern> filters;
        @NotNull
        private final List<Pattern> exclusions;
        final /* synthetic */ CallTreeFilterRuleManager this$0;

        public Compiled(@NotNull CallTreeFilterRuleManager this$0, @NotNull List<Pattern> filters, List<Pattern> exclusions) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
            this.this$0 = this$0;
            this.filters = filters;
            this.exclusions = exclusions;
            this.recompile();
        }

        public /* synthetic */ Compiled(CallTreeFilterRuleManager callTreeFilterRuleManager, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                list2 = new ArrayList();
            }
            this(callTreeFilterRuleManager, list, list2);
        }

        @NotNull
        public final List<Pattern> getFilters() {
            return this.filters;
        }

        @NotNull
        public final List<Pattern> getExclusions() {
            return this.exclusions;
        }

        /*
         * WARNING - void declaration
         */
        public final void recompile() {
            void $this$flatMapTo$iv$iv;
            this.filters.clear();
            this.exclusions.clear();
            Iterable $this$flatMap$iv = this.this$0.getRules();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CallTreeFilterRule it = (CallTreeFilterRule)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getRules();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((CharSequence)it, (char)'+', (boolean)false, (int)2, null)) {
                    String string = it.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    this.exclusions.add(NameBasedFilterProvider.Companion.compile(string));
                    continue;
                }
                this.filters.add(NameBasedFilterProvider.Companion.compile(it));
            }
        }
    }
}

