/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainDetector;
import com.intellij.debugger.streams.psi.impl.JavaStreamChainDetector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/psi/impl/PackageChainDetector;", "Lcom/intellij/debugger/streams/psi/ChainDetector;", "delegate", "packageName", "", "(Lcom/intellij/debugger/streams/psi/ChainDetector;Ljava/lang/String;)V", "extractPackage", "callExpression", "Lcom/intellij/psi/PsiMethodCallExpression;", "isIntermediateCall", "", "isPackageSupported", "name", "isStreamCall", "isTerminationCall", "Companion", "intellij.java.debugger.streams"})
public final class PackageChainDetector
implements ChainDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChainDetector delegate;
    @NotNull
    private final String packageName;

    public PackageChainDetector(@NotNull ChainDetector delegate, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.delegate = delegate;
        this.packageName = packageName;
    }

    @Override
    public boolean isTerminationCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return this.delegate.isTerminationCall(callExpression) && this.isPackageSupported(callExpression);
    }

    @Override
    public boolean isIntermediateCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return this.delegate.isIntermediateCall(callExpression) && this.isPackageSupported(callExpression);
    }

    @Override
    public boolean isStreamCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return this.delegate.isStreamCall(callExpression) && this.isPackageSupported(callExpression);
    }

    private final boolean isPackageSupported(String name) {
        return StringsKt.startsWith$default((String)name, (String)this.packageName, (boolean)false, (int)2, null);
    }

    private final boolean isPackageSupported(PsiMethodCallExpression callExpression) {
        return this.isPackageSupported(this.extractPackage(callExpression));
    }

    private final String extractPackage(PsiMethodCallExpression callExpression) {
        String packageName;
        PsiClass topClass;
        PsiMethod psiMethod = callExpression.resolveMethod();
        if (psiMethod != null && (topClass = PsiUtil.getTopLevelClass((PsiElement)((PsiElement)psiMethod))) != null && (packageName = PsiUtil.getPackageName((PsiClass)topClass)) != null) {
            return packageName;
        }
        return "";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/psi/impl/PackageChainDetector$Companion;", "", "()V", "forJavaStreams", "Lcom/intellij/debugger/streams/psi/impl/PackageChainDetector;", "packageName", "", "intellij.java.debugger.streams"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PackageChainDetector forJavaStreams(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return new PackageChainDetector(new JavaStreamChainDetector(), packageName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

